# @package      hubzero-submit-common
# @file         RemoteTunnelMonitor.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

from hubzero.submit.LogMessage  import logID as log
from hubzero.submit.MessageCore import MessageCore

class RemoteTunnelMonitor(MessageCore):
   def __init__(self,
                host,
                port,
                repeatDelay=5,
                fixedBufferSize=64):
      MessageCore.__init__(self,listenerHost=host,listenerPort=port,repeatDelay=repeatDelay)
      self.fixedBufferSize = fixedBufferSize


   def getTunnelAddressPort(self,
                            tunnelName):
      address = ""
      port    = ""

      queryMessage = "A:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: A(%d):%s" % (nTry,response))

      if response != "":
         address,port = response.split()

      return(address,port)


   def incrementTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "I:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: I(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def decrementTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "D:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: D(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def terminateTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "T:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: T(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def reportTunnelUse(self,
                       tunnelName=""):
      report = ""

      queryMessage = "R:" + tunnelName
      nTry,report = self.requestMessageVariableResponse(queryMessage,
                                                        self.fixedBufferSize,
                                                        self.fixedBufferSize,
                                                        True)

      if nTry > 1:
         log("confirmation: R(%d): %d" % (nTry,len(report)))

      return(report.strip())


