/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/


#ifndef __CLASSAD_CLASSAD_STL_H__
#define __CLASSAD_CLASSAD_STL_H__

#include <map>
#include <list>

/* #undef PREFER_CPP11 */
#define PREFER_TR1

#ifdef PREFER_CPP11
	#include <memory>
	#include <unordered_map>
	
	#define classad_unordered std::unordered_map
	#define classad_weak_ptr std::weak_ptr
	#define classad_shared_ptr std::shared_ptr

#elif defined(PREFER_TR1)
	#include <tr1/memory>
	#include <tr1/unordered_map>

	#define classad_unordered std::tr1::unordered_map
	#define classad_weak_ptr std::tr1::weak_ptr
	#define classad_shared_ptr std::tr1::shared_ptr 
#else
	#include <boost/shared_ptr.hpp>
	#include <boost/weak_ptr.hpp>
	#include <boost/unordered_map.hpp>

	#define classad_unordered boost::unordered_map
	#define classad_weak_ptr boost::weak_ptr
	#define classad_shared_ptr boost::shared_ptr
#endif

#define classad_map   std::map 
#define classad_slist std::list

#endif /* __CLASSAD_CLASSAD_STL_H__ */
