#
# @package      hubzero-submit-distributor
# @file         TarCommand.py
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
import os.path

def __buildTarball(tarball,
                   tarOptions,
                   inputFiles):
   absolutePaths = []
   for inputFile in inputFiles:
      absolutePath = os.path.abspath(inputFile)
      absolutePaths.append(absolutePath)

   absolutePaths.sort()

   tarCommandArgs = []
   tarCommandArgs.append("tar")
   tarCommandArgs.append(tarOptions)
   tarCommandArgs.append(tarball)
   tarCommandArgs.append("--exclude='*.svn*'")
   oldDirName = ""
   for absolutePath in absolutePaths:
      dirName  = os.path.dirname(absolutePath)
      baseName = os.path.basename(absolutePath)
      if dirName != oldDirName:
         tarCommandArgs.append("-C")
         tarCommandArgs.append(dirName)
         oldDirName = dirName
      tarCommandArgs.append(baseName)

   tarCommand = ' '.join(tarCommandArgs)

   return(tarCommand)


def buildCreate(tarball,
                inputFiles):
   tarCommand = __buildTarball(tarball,'vchf',inputFiles)

   return(tarCommand)


def buildAppend(tarball,
                inputFiles):
   tarCommand = __buildTarball(tarball,'vrhf',inputFiles)

   return(tarCommand)

