HUBNAME =

SUBMITSERVERSRCDIR = SubmitServer
SUBMITCLIENTSRCDIR = SubmitClient

CONDORVERSION = 7.6.6
CONDORSRCDIR = Condor
CONDORTARBALL = condor-7.6.6-x86_64_deb_6.0-updated-stripped.tar.gz

PEGASUSVERSION = 4.0.0
PEGASUSSRCDIR = Pegasus
PEGASUSTARBALL = pegasus-binary-4.0.0-x86_64_deb_6.tar.gz
PEGASUSINSTALLER = install_pegasus.sh

SUBMITVERSION = 2.0
PYTHONLIBRARYSRCDIR = Library
PYTHONLIBRARY = submit-$(SUBMITVERSION).tar.gz
DISTRIBUTORSRCDIR = Distributor
BATCHMONITORS = monitorCondor.py monitorCondorG.py monitorFactory.py monitorLL.py \
                monitorLSF.py monitorPBS.py monitorSLURM.py monitorWF.py
BATCHSCHEDULERS = condor ll lsf pbs slurm
BATCHSCRIPTS = cleanupjob.sh killbatchjob.sh receiveinput.sh submitbatchjob.sh transmitresults.sh
DISTRIBUTORSCRIPTS = genuserid genuserpki update-known-hosts
DISTRIBUTORMAINS = distributor.py distributor.sh
DISTRIBUTORDFTFILES = environmentwhitelist.dft managers.dft monitors.dft sites.dft tools.dft tunnels.dft
DISTRIBUTORDATFILES = environmentwhitelist.dat managers.dat monitors.dat sites.dat tools.dat tunnels.dat
MONITORJOB = monitorJob.py
MONITORJOBUTILS = monitorJobQ.py monitorJobR.py monitorJobS.py monitorJobT.py
MONITORTUNNEL = monitorTunnel.py
MONITORTUNNELUTILS = monitorTunnelA.py monitorTunnelD.py monitorTunnelI.py monitorTunnelR.py monitorTunnelT.py

PEGASUSLOCALCONFIGS = pegasus_local.rc sites_local.xml

# checkUser takes 1 argument - user name
checkUser = getent passwd $(1) > /dev/null 2>&1

# checkGroup takes 1 argument - group name
checkGroup = getent group $(1) > /dev/null 2>&1

# addUser takes two arguments - user name and gecos entry
addUser = $(call checkUser,$(1)) || adduser --force-badname --home /var/$(1) --shell /bin/bash \
                                            --disabled-password --gecos $(2) --firstuid 100 --lastuid 200 $(1)
# makeHome takes 1 argument - user name
makeHome = [ -d /var/$(1) ] || install -o $(1) -g $(1) -m 0755 --directory /var/$(1)

.PHONY: checkTunneler \
        install-user-condor install-user-gridman install-users \
        create-optsubmit create-etcsubmit create-container-etcsubmit \
        install-server-script configure-server install-server-init \
        install-client-script configure-client \
        install-condor-tar randomLockId hubHostName condorIds configure-condor install-condor-init \
        install-pegasus-tar \
        install-distributor-batchmonitors install-distributor-scripts \
        install-distributor-bin install-distributor-mains \
        install-python-library \
        install-distributor-dft install-distributor-dat \
        install-monitor-job install-monitor-tunnel install-monitor-condor \
        install-pegasus-diagrid \
        install-distributor-keys \
        install-distributor-condor-scripts initialize-monitor-job \
        install-distributor-logs install-monitor-logs \
        install-server install-client install-condor install-pegasus \
        install-distributor install-monitors install-logs \
        install-server-host install-client-host \
        usage

usage:
	@echo "This Makefile directs the installation of the constituent components of submit."
	@echo "   install-users - create system ccounts for the required submit users" 
	@echo "   install-server - install submit server on submit host"
	@echo "   install-client - install submit client in execution host containers"
	@echo "   install-condor - install condor, default job submission method"
	@echo "   install-pegasus - install pegasus workflow manager"
	@echo "   install-distributor - install remote job distributor"
	@echo "   install-monitors - install master and condor job monitors"
	@echo "   install-logs - create log directory and files with proper permissions"
	@echo "   install-server-host - install all server side software"
	@echo "   install-client-host - install all client side software"
	@echo ""
	@echo "   A typical installation can be accomplished with the command"
	@echo "       make HUBNAME=myhub install"
	@echo ""
#
# user utilities
#
checkTunneler:
	@$(call checkGroup,tunneler) || ( echo "tunneler group doesn't exist.  Fix this from the CMS before continuing" && exit 1 )
	@if [ `grep -c '^tunneler:' /etc/group` -eq 0 ] ; then \
            gid=`getent group tunneler | cut -d':' -f 3`; \
            echo "tunneler:x:$${gid}:" >> /etc/group; \
         fi

install-user-condor:
	@$(call addUser,condor,Condor)
	@$(call makeHome,condor)

install-user-gridman: checkTunneler
	@$(call addUser,gridman,Gridman)
	@if [ `id gridman | grep -c '(tunneler)'` -eq 0 ] ; then adduser --quiet gridman tunneler; fi
	@$(call makeHome,gridman)

install-users: install-user-condor install-user-gridman
#
# directory utilities
#
create-optsubmit:
	install -o apps -g apps -m 2775 --directory /opt/submit

create-etcsubmit:
	install -o root -g root -m 0755 --directory /etc/submit
#
# submit server
#
install-server-script: $(SUBMITSERVERSRCDIR)/submit-server.py
	install -o root -g root -m 0740 --target-directory /usr/sbin $(SUBMITSERVERSRCDIR)/submit-server.py

configure-server: create-etcsubmit $(SUBMITSERVERSRCDIR)/submit-server.conf.in
	sed -e "s/@HUBNAME@/$(HUBNAME)/" $(SUBMITSERVERSRCDIR)/submit-server.conf.in > $(SUBMITSERVERSRCDIR)/submit-server.conf.example
	install -o root -g root -m 0600 --target-directory /etc/submit $(SUBMITSERVERSRCDIR)/submit-server.conf.example
	rm -f $(SUBMITSERVERSRCDIR)/submit-server.conf.example

install-server-init: install-user-gridman $(SUBMITSERVERSRCDIR)/submit-server $(SUBMITSERVERSRCDIR)/jobmon $(SUBMITSERVERSRCDIR)/tunnelmon
	install -o root -g root -m 0755 --target-directory /etc/init.d $(SUBMITSERVERSRCDIR)/jobmon
	insserv jobmon
	install -o root -g root -m 0755 --target-directory /etc/init.d $(SUBMITSERVERSRCDIR)/tunnelmon
	insserv tunnelmon
	install -o root -g root -m 0755 --target-directory /etc/init.d $(SUBMITSERVERSRCDIR)/submit-server
	insserv submit-server
	insserv
#
# submit client
#
install-client-script: $(SUBMITCLIENTSRCDIR)/submit
	install -o root -g root -m 0755 --target-directory /usr/bin $(SUBMITCLIENTSRCDIR)/submit

configure-client: create-etcsubmit $(SUBMITCLIENTSRCDIR)/submit-client.conf.in hubHostName
	sed -e "s/@HUBHOSTNAME@/$(HUBHOSTNAME)/" $(SUBMITCLIENTSRCDIR)/submit-client.conf.in > $(SUBMITCLIENTSRCDIR)/submit-client.conf.example
	install -o root -g root -m 0644 --target-directory /etc/submit $(SUBMITCLIENTSRCDIR)/submit-client.conf.example
	rm -f $(SUBMITCLIENTSRCDIR)/submit-client.conf.example
#
# condor
#
install-condor-tar: install-user-condor $(CONDORSRCDIR)/$(CONDORTARBALL)
	install -o condor -g condor -m 0755 --directory /var/condor/Condor/$(CONDORVERSION)
	install -o condor -g condor -m 0600 --target-directory /var/condor/Condor/$(CONDORVERSION) $(CONDORSRCDIR)/$(CONDORTARBALL)
	tar x --preserve-permissions --directory /var/condor/Condor/$(CONDORVERSION) \
	      --file /var/condor/Condor/$(CONDORVERSION)/$(CONDORTARBALL) --strip-components 1
	chown -R condor:condor /var/condor/Condor/$(CONDORVERSION)

randomLockId:
	$(eval RANDOMLOCKID := $(shell tr -dc "[:digit:]" < /dev/urandom | head -c 15))
#	$(eval RANDOMLOCKID := $(shell wget --quiet 'http://www.random.org/decimal-fractions/?num=1&dec=15&col=1&format=plain&rnd=new' -O -))

hubHostName:
	$(eval HUBHOSTNAME := $(shell hostname))

condorIds:
	$(eval CONDORUID := $(shell id --user condor))
	$(eval CONDORGID := $(shell id --group condor))

configure-condor: install-user-condor randomLockId hubHostName condorIds
	install -o condor -g condor -m 0755 --directory /var/condor/Grid/etc
	install -o condor -g condor -m 0755 --directory /var/condor/Grid/etc/sysconfig
	install -o condor -g condor -m 1777 --directory /var/condor/Grid/execute
	install -o condor -g condor -m 1777 --directory /var/condor/Grid/log
	install -o condor -g condor -m 0755 --directory /var/condor/Grid/spool
	install -o condor -g condor -m 1777 --directory /var/condor/Grid/tmp
	sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" $(CONDORSRCDIR)/condor.in            > $(CONDORSRCDIR)/condor
	sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" $(CONDORSRCDIR)/condor_config.in     > $(CONDORSRCDIR)/condor_config
	sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" \
            -e "s/@HUBHOSTNAME@/$(HUBHOSTNAME)/" \
            -e "s/@CONDORUID@/$(CONDORUID)/" \
            -e "s/@CONDORGID@/$(CONDORGID)/" \
            -e "s/@RANDOMLOCKID@/$(RANDOMLOCKID)/" $(CONDORSRCDIR)/condor_config.local.in > $(CONDORSRCDIR)/condor_config.local
	install -o condor -g condor -m 0644 --target-directory /var/condor/Grid/etc/sysconfig $(CONDORSRCDIR)/condor
	install -o condor -g condor -m 0644 --target-directory /var/condor/Grid/etc $(CONDORSRCDIR)/condor_config
	install -o condor -g condor -m 0644 --target-directory /var/condor/Grid/etc $(CONDORSRCDIR)/condor_config.local
	rm -f $(CONDORSRCDIR)/condor $(CONDORSRCDIR)/condor_config $(CONDORSRCDIR)/condor_config.local

install-condor-init: install-user-condor $(CONDORSRCDIR)/condor_grid
	install -o root -g root -m 0755 --target-directory /etc/init.d $(CONDORSRCDIR)/condor_grid
	insserv condor_grid
	insserv
#
# pegasus
#
install-pegasus-tar: $(PEGASUSSRCDIR)/$(PEGASUSTARBALL) $(PEGASUSSRCDIR)/$(PEGASUSINSTALLER).in
	install -o apps -g apps -m 0755 --directory /apps/share64
	install -o apps -g apps -m 0755 --directory /apps/share64/environ
	install -o apps -g apps -m 0755 --directory /apps/share64/pegasus
	install -o apps -g apps -m 0700 --directory /apps/share64/pegasus/build
	install -o apps -g apps -m 0600 --target-directory /apps/share64/pegasus/build $(PEGASUSSRCDIR)/$(PEGASUSTARBALL)
	sed -e "s/@PEGASUSVERSION@/$(PEGASUSVERSION)/" $(PEGASUSSRCDIR)/$(PEGASUSINSTALLER).in > $(PEGASUSSRCDIR)/$(PEGASUSINSTALLER)
	install -o apps -g apps -m 0755 --target-directory /apps/share64/pegasus/build $(PEGASUSSRCDIR)/$(PEGASUSINSTALLER)
	cd /apps/share64/pegasus/build; ./$(PEGASUSINSTALLER)
	rm -f $(PEGASUSSRCDIR)/$(PEGASUSINSTALLER)
#
# distributor
#
install-distributor-batchmonitors: create-optsubmit
	install -o apps -g apps -m 2750 --directory /opt/submit/BatchMonitors
	for batchMonitor in $(BATCHMONITORS) ; do \
           install -o apps -g apps -m 0750 --target-directory /opt/submit/BatchMonitors $(DISTRIBUTORSRCDIR)/BatchMonitors/$${batchMonitor}; \
        done

install-distributor-scripts: create-optsubmit
	install -o apps -g apps -m 2750 --directory /opt/submit/Scripts
	for batchScheduler in $(BATCHSCHEDULERS) ; do \
	   install -o apps -g apps -m 2750 --directory /opt/submit/Scripts/$${batchScheduler}; \
           for batchScript in $(BATCHSCRIPTS) ; do \
              install -o apps -g apps -m 0755 --target-directory /opt/submit/Scripts/$${batchScheduler} $(DISTRIBUTORSRCDIR)/Scripts/$${batchScheduler}/$${batchScript}; \
           done \
        done

install-distributor-bin: create-optsubmit hubHostName
	install -o apps -g apps -m 2751 --directory /opt/submit/bin
	for distributorScript in $(DISTRIBUTORSCRIPTS) ; do \
           install -o apps -g apps -m 0755 --target-directory /opt/submit/bin $(DISTRIBUTORSRCDIR)/bin/$${distributorScript}; \
        done
	/opt/submit/bin/update-known-hosts $(HUBHOSTNAME)

install-distributor-mains: create-optsubmit
	for distributorMain in $(DISTRIBUTORMAINS) ; do \
           install -o apps -g apps -m 0755 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${distributorMain}; \
           sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" --in-place /opt/submit/$${distributorMain}; \
        done
	cd /opt/submit; ln --force --symbolic distributor.py distributor

install-python-library: $(PYTHONLIBRARYSRCDIR)/$(PYTHONLIBRARY)
	tar x --directory /tmp --file $(PYTHONLIBRARYSRCDIR)/$(PYTHONLIBRARY)
	cd /tmp/submit-$(SUBMITVERSION); python setup.py install
	rm -rf /tmp/submit-$(SUBMITVERSION)

install-distributor-dft: create-optsubmit
	for dftFile in $(DISTRIBUTORDFTFILES) ; do \
           install -o apps -g apps -m 0640 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${dftFile}; \
        done

install-distributor-dat: create-optsubmit hubHostName
	for datFile in $(DISTRIBUTORDATFILES) ; do \
           install -o apps -g apps -m 0644 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${datFile}; \
        done
	sed -e "s/@HUBHOSTNAME@/$(HUBHOSTNAME)/" --in-place /opt/submit/monitors.dat

install-monitor-job: install-user-gridman create-optsubmit
	install -o gridman -g apps -m 0750 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$(MONITORJOB); \
	for monitorJobUtil in $(MONITORJOBUTILS) ; do \
           install -o apps -g apps -m 0750 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${monitorJobUtil}; \
        done

install-monitor-tunnel: install-user-gridman create-optsubmit
	install -o gridman -g apps -m 0750 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$(MONITORTUNNEL); \
	for monitorTunnelUtil in $(MONITORTUNNELUTILS) ; do \
           install -o apps -g apps -m 0750 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${monitorTunnelUtil}; \
        done

install-pegasus-local: create-optsubmit
	for pegasusLocalConfig in $(PEGASUSLOCALCONFIGS) ; do \
           install -o apps -g apps -m 0644 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/$${pegasusLocalConfig}; \
           sed -e "s/@PEGASUSVERSION@/$(PEGASUSVERSION)/" --in-place /opt/submit/$${pegasusLocalConfig}; \
        done

install-distributor-keys: install-user-gridman create-optsubmit hubHostName
	install -o apps -g apps -m 0751 --directory /opt/submit/etc
	install -o apps -g apps -m 0751 --directory /opt/submit/.ssh
	ssh-keygen -t rsa -q -N "" -f /opt/submit/.ssh/submit_rsa -C "submit@$(HUBHOSTNAME)"
	chown gridman:apps /opt/submit/.ssh/submit_rsa /opt/submit/.ssh/submit_rsa.pub
	install -o apps -g apps -m 0644 --target-directory /opt/submit/etc /opt/submit/.ssh/submit_rsa.pub
	install -o gridman -g gridman -m 0700 --directory /var/gridman/.ssh
	cat /opt/submit/.ssh/submit_rsa.pub >> /var/gridman/.ssh/authorized_keys
	chown gridman:gridman /var/gridman/.ssh/authorized_keys
	chmod 0600 /var/gridman/.ssh/authorized_keys

install-distributor-condor-scripts: create-optsubmit
	install -o apps -g apps -m 2751 --directory /opt/submit/bin
	for batchScript in $(BATCHSCRIPTS) ; do \
           install -o apps -g apps -m 0755 --target-directory /opt/submit/bin $(DISTRIBUTORSRCDIR)/Scripts/condor/$${batchScript}; \
           sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" \
               -e "s/@PEGASUSVERSION@/$(PEGASUSVERSION)/" --in-place /opt/submit/bin/$${batchScript}; \
        done

initialize-monitor-job: create-optsubmit
	python $(DISTRIBUTORSRCDIR)/monitorJobInitialize.py
	chown gridman:apps /opt/submit/monitorJobDB /opt/submit/monitorJob.dump
	chmod 0640 /opt/submit/monitorJobDB /opt/submit/monitorJob.dump

install-distributor-logs:
	install -o root -g root -m 0775 --directory /var/log/submit
	install -o apps -g public -m 0755 --directory /var/log/submit/distributor
	touch emptyFile
	[ -f /var/log/submit/distributor/distributor.log ] || \
           install -o apps -g apps -m 0666 --no-target-directory emptyFile /var/log/submit/distributor/distributor.log
	[ -f /var/log/submit/distributor/gridjobhistory.log ] || \
           install -o apps -g apps -m 0666 --no-target-directory emptyFile /var/log/submit/distributor/gridjobhistory.log
	[ -f /var/log/submit/distributor/gridjobid.log ] || \
           install -o apps -g apps -m 0666 --no-target-directory emptyFile /var/log/submit/distributor/gridjobid.log
	rm -f emptyFile

install-monitor-logs:
	install -o root -g root -m 0775 --directory /var/log/submit
	install -o gridman -g public -m 0755 --directory /var/log/submit/monitors
	touch emptyFile
	[ -f /var/log/submit/monitors/monitorCondor.log ] || \
           install -o gridman -g gridman -m 0644 --no-target-directory emptyFile /var/log/submit/monitors/monitorCondor.log
	[ -f /var/log/submit/monitors/monitorJob.log ] || \
           install -o gridman -g gridman -m 0644 --no-target-directory emptyFile /var/log/submit/monitors/monitorJob.log
	[ -f /var/log/submit/monitors/monitorTunnel.log ] || \
           install -o gridman -g gridman -m 0644 --no-target-directory emptyFile /var/log/submit/monitors/monitorTunnel.log
	rm -f emptyFile

install-monitor-condor: install-user-gridman create-optsubmit
	install -o gridman -g apps -m 0750 --target-directory /opt/submit $(DISTRIBUTORSRCDIR)/BatchMonitors/monitorCondor.py
	sed -e "s/@CONDORVERSION@/$(CONDORVERSION)/" --in-place /opt/submit/monitorCondor.py
	touch emptyFile
	[ -f /opt/submit/monitorCondor.history ] || \
           install -o gridman -g apps -m 0644 --no-target-directory emptyFile /opt/submit/monitorCondor.history
	rm -f emptyFile

install-server: install-server-script configure-server install-server-init

install-client: install-client-script configure-client

install-condor: install-condor-tar configure-condor install-condor-init

install-pegasus: install-pegasus-tar

install-distributor: install-distributor-dft install-distributor-dat \
                     install-distributor-batchmonitors install-distributor-scripts \
                     install-distributor-bin install-distributor-mains install-pegasus-diagrid \
                     install-distributor-keys \
                     install-distributor-condor-scripts

install-monitors: install-monitor-job install-monitor-tunnel install-monitor-condor \
                  initialize-monitor-job

install-logs: install-distributor-logs install-monitor-logs

install-server-host: install-python-modules install-server \
                     install-condor install-pegasus install-distributor \
                     install-monitors install-logs

install-client-host: install-python-modules install-client

