#!/usr/bin/python2.6
"""Distribute computation jobs to remote resources
 
   Generate a pair of script files for remote job submission.
   The first file is the batch submission script, the second is a shell script
   that wraps the application and generates time usage data.
 
   RUN AS FOLLOWS:
     distributor -j <jobId> -v <venue> -i <inputfile> -o <outputfile>
                 -n <nCpus> -N <ppn> -w <wallTime> -e <environment variable>
                 -m <manager>
 
   <jobId>                 is the job identifier
   <executable>            is the MPI enabled executable to be run.
   <inputfile>             is a file to be sent to the remote site
   <outputfile>            is a file to be retrieved from the remote site
   <nCpus>                 the number of processors to use
   <ppn>                   the processors/node to use
   <wallTime>              wall time limit for remote process
   <environment variable>  variable=value
   <venue>                 remote venue
   <manager>               multi-processor control manager
 
                                                  | cpu time    |
                                                  | from time() |
                                                  |             |
                                      |  waiting  | real(wall)  |
                                      |   time    |    time     |
                                      |           |             |
     |------------|---------|---------|-----------|-------------|----------|----
  simulate     condor     site      files     simulation    simulation   files
   button        job    selected    staged     started        ended      staged
  pressed    submitted               in                                   out

   """
#
# @package      hubzero-submit-distributor
# @file         distributor.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import os
import sys

from hubzero.submit.JobDistributor import JobDistributor

VERSION            = 'current'
INSTALLEDDIRECTORY = os.path.join(os.sep,'opt','submit')
LOGDIRECTORY       = os.path.join(os.sep,'var','log','submit','distributor')

RUNJOB_ROOT   = "REMOTE"
CONDOR_ROOT   = os.path.join(os.sep,'var','condor','Condor','7.6.6')
CONDOR_CONFIG = os.path.join(os.sep,'var','condor','Grid','etc','condor_config')
PBS_ROOT      = ""

ALLOWEDVENUEMECHANISMS = ['local']

JOBMONITORHOST    = ""
JOBMONITORPORT    = 5727
PROBEMONITORHOST  = ""
PROBEMONITORPORT  = 5728
TUNNELMONITORHOST = ""
TUNNELMONITORPORT = 5729
CLOUDMONITORHOST  = ""
CLOUDMONITORPORT  = 5726

if __name__ == '__main__':
   __jobDistributor__ = JobDistributor(VERSION,INSTALLEDDIRECTORY,LOGDIRECTORY, \
                                       JOBMONITORHOST,JOBMONITORPORT, \
                                       PROBEMONITORHOST,PROBEMONITORPORT, \
                                       TUNNELMONITORHOST,TUNNELMONITORPORT, \
                                       CLOUDMONITORHOST,CLOUDMONITORPORT, \
                                       ALLOWEDVENUEMECHANISMS)
   __jobDistributor__.setEnvironment(PBS_ROOT,CONDOR_ROOT,CONDOR_CONFIG,RUNJOB_ROOT)
   __jobDistributor__.getEnvironment()

   __exitCode__ = __jobDistributor__.parseCommandArguments()
   if __exitCode__:
      __jobDistributor__.reportExitCondition()
      sys.exit(__exitCode__)

   __exitCode__ = __jobDistributor__.setJobId()
   if __exitCode__:
      __jobDistributor__.reportExitCondition()
      sys.exit(__exitCode__)

   __jobDistributor__.setInfo()

   __exitCode__ =  __jobDistributor__.showUsage()
   if __exitCode__:
      __jobDistributor__.reportExitCondition()
      sys.exit(__exitCode__)

   __exitCode__ =  __jobDistributor__.buildJobDescription()
   if __exitCode__:
      __jobDistributor__.reportExitCondition()
      sys.exit(__exitCode__)

   __exitCode__ = __jobDistributor__.buildJobInstances()

   __jobDistributor__.reportExitCondition()
   sys.exit(__exitCode__)


