#!/usr/bin/python2.6
#
# @package      hubzero-submit-distributor
# @file         monitorJob.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJob.py
#
#  script which gathers monitoring statistics from remote sites and
#  reports job status to distributor on demand
#
import sys
import os
import shelve
import traceback

MONITORROOT  = os.path.join(os.sep,'opt','submit')
DBFILENAME   = "monitorJobDB"
DBFILEPATH   = os.path.join(MONITORROOT,DBFILENAME)
DUMPFILENAME = "monitorJob.dump"
DUMPFILEPATH = os.path.join(MONITORROOT,DUMPFILENAME)

 
if __name__ == '__main__':

   try:
      activeJobs = shelve.open(DBFILEPATH)
      activeJobs.close()
   except IOError:
      print traceback.format_exc()

   try:
      dumpFile = open(DUMPFILEPATH,'w')
      dumpFile.close()
   except:
      pass

