#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/condor/movepegtmp2home.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -ne 2 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2

if [ -f ${jobWorkingDirectory}/work/pegasusSetup.sh ] ; then
   . ${jobWorkingDirectory}/work/pegasusSetup.sh
fi

if [ ${jobScratchDirectory} != ${jobWorkingDirectory} ] ; then
   if [ -d ${jobScratchDirectory} ] ; then
      if [ -d ${jobWorkingDirectory} ] ; then
         srcPath=${jobScratchDirectory}/work
         dstPath=${jobWorkingDirectory}/work
         mkdir -p ${srcPath}
         mkdir -p ${dstPath}

         while : ; do
            if [ ! -d ${srcPath} ] ; then
               break
            fi
            if [ ! -d ${dstPath} ] ; then
               break
            fi

            if [ -f ${srcPath}/jobstate.log ] ; then
               cp -p ${srcPath}/jobstate.log ${dstPath}
               jobNames=$(grep JOB_TERMINATED ${dstPath}/jobstate.log 2> /dev/null | grep -v -E ' stage_| create_' | cut -d' ' -f 2)
               if [ -n "${jobNames}" ] ; then
                  for jobName in ${jobNames} ; do
                     cp -n -p ${srcPath}/${jobName}.out.[0-9]* ${dstPath} 2> /dev/null
                  done
               fi
            fi
            pegasus-status --rows ${srcPath} > ${dstPath}/pegasusstatus.txt
            sleep 30
         done
      fi
   fi
else
   if [ -d ${jobWorkingDirectory} ] ; then
      dstPath=${jobWorkingDirectory}/work
      mkdir -p ${dstPath}

      while : ; do
         if [ ! -d ${dstPath} ] ; then
            break
         fi
         pegasus-status --rows ${dstPath} > ${dstPath}/pegasusstatus.txt
         sleep 30
      done
   fi
fi
