#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/ll/killbatchjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -ne 2 ] ; then
   echo usage: $0 jobId jobClass
   exit 64
fi

jobId=$1
jobClass=$2

case ${jobClass} in
   LL)
      llcancel ${jobId}
      exitStatus=$?
      ;;
   *)
      echo "Invalid job class ${jobClass}"
      exitStatus=23
      ;;
esac

exit ${exitStatus}
