# @package      hubzero-submit-distributor
# @file         GroupMembership.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

"""Functions for determining if user is a member of a particular group.
   """
import os
import grp
import logging

from hubzero.submit.LogMessage import getLogJobIdMessage as getLogMessage

def isGroupMember(groupName):
   """
   Is user a member of group groupName?
   """
   try:
#     name,pswd,requestedGroupId,other = grp.getgrnam(groupName)
      _,_,requestedGroupId,_ = grp.getgrnam(groupName)
   except:
      logger = logging.getLogger(__name__)
      logger(logging.ERROR,getLogMessage("Unable to get gid of '%s'" % (groupName)))
      return False

   for groupId in os.getgroups():
      if groupId == requestedGroupId:
         return True

   return False


