#!/usr/bin/env python
#
# @package      hubzero-submit-distributor
# @file         jobStatus.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
"""Report status of batch jobs currently running remotely.
   """

import sys

from hubzero.submit.JobStatus import JobStatus

JOBMONITORHOST    = ""
JOBMONITORPORT    = 5727

if __name__ == '__main__':
   __jobStatus__ = JobStatus(JOBMONITORHOST,JOBMONITORPORT)

   __exitCode__ = __jobStatus__.parseCommandArguments()
   if __exitCode__:
      sys.exit(__exitCode__)

   __exitCode__ = __jobStatus__.report()

   sys.exit(__exitCode__)


