#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/ll/postprocessjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobClass
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobClass=$3

exitStatus=0
if [ ! -d ${jobWorkingDirectory} ] ; then
   echo "Job working directory ${jobWorkingDirectory} does not exist"
   exitStatus=23
fi
if [ ! -d ${jobScratchDirectory} ] ; then
   echo "Job scratch directory ${jobScratchDirectory} does not exist"
   exitStatus=23
fi

if [ ${exitStatus} -eq 0 ] ; then
   case ${jobClass} in
      PEGASUS)
         cd ${jobScratchDirectory}
         exitStatus=$?
         if [ ${exitStatus} -eq 0 ] ; then
            if [ -f ${jobWorkingDirectory}/work/pegasusSetup.sh ] ; then
               . ${jobWorkingDirectory}/work/pegasusSetup.sh
            fi

            if [ -d work ] ; then
               propertiesFile=$(ls work/pegasus.[1-9]*.properties 2> /dev/null)
               if [ -n "${propertiesFile}" ] ; then
                  pegasusVersion=$(pegasus-version)
                  pegasus-analyzer --dir=work \
                                   --conf=${propertiesFile} > ${jobWorkingDirectory}/pegasus.analysis 2>&1

                  if [ "${pegasusVersion}" \> "4.0.0" ] ; then
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --file=txt \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.txt ] ; then
                        mv work/statistics/jobs.txt ${jobWorkingDirectory}/pegasusjobstats.txt
                     fi
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --file=csv \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.csv ] ; then
                        mv work/statistics/jobs.csv ${jobWorkingDirectory}/pegasusjobstats.csv
                     fi
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=summary \
                                        --file=csv \
                                        --quiet \
                                        work
                     if [ -f work/statistics/summary.csv ] ; then
                        mv work/statistics/summary.csv ${jobWorkingDirectory}/pegasussummary.csv
                     fi
                     if [ -f work/statistics/summary-time.csv ] ; then
                        mv work/statistics/summary-time.csv ${jobWorkingDirectory}/pegasussummary-time.csv
                     fi
                  else
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.csv ] ; then
                        mv work/statistics/jobs.csv ${jobWorkingDirectory}/pegasusjobstats.csv
                     fi
                     if [ -f work/statistics/jobs.txt ] ; then
                        mv work/statistics/jobs.txt ${jobWorkingDirectory}/pegasusjobstats.txt
                     fi
                  fi
               fi
            fi
            if [ ${jobScratchDirectory} != ${jobWorkingDirectory} ] ; then
               mkdir -p ${jobWorkingDirectory}/work
               cp -p work/jobstate.log ${jobWorkingDirectory}/work
               jobNames=$(grep JOB_TERMINATED work/jobstate.log | grep -v -E ' stage_| create_' | cut -d' ' -f 2)
               if [ -n "${jobNames}" ] ; then
                  for jobName in ${jobNames} ; do
                     cp -p work/${jobName}.out.[0-9]* ${jobWorkingDirectory}/work
                  done
               fi
            fi
         fi
         ;;
      *)
         echo "Invalid job class ${jobClass}"
         exitStatus=23
         ;;
   esac
fi

exit ${exitStatus}
