#!/usr/bin/env python
#
# @package      hubzero-submit-distributor
# @file         distributor.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2013 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
"""Send emil notification to HUB user
"""

import sys
import os
import smtplib
import traceback
from email.mime.text import MIMEText
from optparse import OptionParser,SUPPRESS_HELP


MAXSUBJECTLENGTH = 50
MAXTEXTLENGTH    = 140

class CommandParser:

   def __init__(self):
      self.commandOptions   = None
      self.commandArguments = []

      self.parser = OptionParser(prog="hubmail",add_help_option=False)
      self.parser.disable_interspersed_args()
      self.parser.add_option("-s","--subject",action="store",type="string",dest="subject", \
                                              help="Email subject")
      self.parser.add_option("-t","--text",action="store",type="string",dest="text", \
                                           help="Email message")
      self.parser.set_defaults(help=False)
      self.parser.add_option("-h","--help",action="store_true",dest="help", \
                                           help="Report command usage.")

      self.commandOptions,arguments = self.parser.parse_args(sys.argv[1:])


   def showUsage(self):
      self.parser.print_help()


   def getOption(self,
                 option):
      value = getattr(self.commandOptions,option)

      return(value)


if __name__ == '__main__':

   emailDestination = os.getenv("USER_EMAIL",None)
   emailSource      = os.getenv("HUB_EMAIL_FROM",None)

   commandParser = CommandParser()
   if commandParser.getOption('help'):
      commandParser.showUsage()
   else:
      sendMessage = True
      subject = commandParser.getOption('subject')
      text    = commandParser.getOption('text')
      if subject:
         if   len(subject) > MAXSUBJECTLENGTH:
            sys.stderr.write("Subject exceeds maximum length of %d characters\n" % (MAXSUBJECTLENGTH))
            sendMessage = False
         elif len(subject) < 1:
            sys.stderr.write("Subject is empty\n")
            sendMessage = False
      else:
         sys.stderr.write("Subject not specified\n")
         sendMessage = False

      if text:
         if   len(text) > MAXTEXTLENGTH:
            sys.stderr.write("Text exceeds maximum length of %d characters\n" % (MAXTEXTLENGTH))
            sendMessage = False
         elif len(text) < 1:
            sys.stderr.write("Text is empty\n")
            sendMessage = False
      else:
         sys.stderr.write("Text not specified\n")
         sendMessage = False

      if not emailDestination:
         sys.stderr.write("Message destination not specified\n")
         sendMessage = False
      if not emailSource:
         sys.stderr.write("Message source not specified\n")
         sendMessage = False

      if sendMessage:
         try:
            msg = MIMEText(text)
            msg['Subject'] = subject
            msg['From'] = emailSource
            msg['To'] = emailDestination

            smtp = smtplib.SMTP('localhost')
            try:
               result = smtp.sendmail(emailSource,[emailDestination],msg.as_string())
            except Exception:
               print traceback.format_exc()

            closed = smtp.quit()
         except Exception:
            print traceback.format_exc()

