# @package      hubzero-submit-distributor
# @file         EnvironmentWhitelistInfo.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import os.path
import re
import logging

from hubzero.submit.LogMessage import getLogJobIdMessage as getLogMessage

class EnvironmentWhitelistInfo:
   def __init__(self,
                whiteListPath):
      self.logger               = logging.getLogger(__name__)
      self.environmentWhiteList = []

      commentPattern = re.compile('\s*#.*')

      if os.path.exists(whiteListPath):
         try:
            fpWhiteList = open(whiteListPath,'r')
            try:
               eof = False
               while not eof:
                  record = fpWhiteList.readline()
                  if record != "":
                     record = commentPattern.sub("",record).strip()
                     if record != "":
                        self.environmentWhiteList.append(record)
                  else:
                     eof = True
            except (IOError,OSError):
               self.logger.log(logging.ERROR,getLogMessage("Environment white list file %s could not be read" % (whiteListPath)))
            finally:
               fpWhiteList.close()
         except (IOError,OSError):
            self.logger.log(logging.ERROR,getLogMessage("Environment white list file %s could not be opened" % (whiteListPath)))
      else:
         self.logger.log(logging.ERROR,getLogMessage("Environment white list file %s is missing" % (whiteListPath)))


   def isVariableInWhiteList(self,
                             variable):
      return(variable in self.environmentWhiteList)


