#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         distributor.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
echo Arguments are $0 $*
while :
do
  case $1 in
    -d)           echo Data "'$2'"; shift; shift;;
    -data)        echo Data "'$2'"; shift; shift;;
    -e)           echo Environment "'$2'"; shift; shift;;
    --env)        echo Environment "'$2'"; shift; shift;;
    -h)           echo Help ; shift;;
    --help)       echo Help ; shift;;
    -i)           echo Input file "'$2'"; shift; shift;;
    --inputfile)  echo Input file "'$2'"; shift; shift;;
    -j)           echo Jobid "'$2'"; shift; shift;;
    --jobid)      echo Jobid "'$2'"; shift; shift;;
    -l)           echo Local execution ; shift;;
    --local)      echo Local execution ; shift;;
    -M)           echo Metrics ; shift;;
    --metrics)    echo Metrics ; shift;;
    -m)           echo Manager "'$2'"; shift; shift;;
    --manager)    echo Manager "'$2'"; shift; shift;;
    -N)           echo CPUs/node "'$2'"; shift; shift;;
    --ppn)        echo CPUs/node "'$2'"; shift; shift;;
    -n)           echo Ncpus "'$2'"; shift; shift;;
    --nCpus)      echo Ncpus "'$2'"; shift; shift;;
    -o)           echo Output file "'$2'"; shift; shift;;
    --outputfile) echo Output file "'$2'"; shift; shift;;
    -p)           echo Parameters "'$2'"; shift; shift;;
    --parameters) echo Parameters "'$2'"; shift; shift;;
    -r)           echo Redundancy "'$2'"; shift; shift;;
    --redundancy) echo Redundancy "'$2'"; shift; shift;;
    -s)           echo Separator "'$2'"; shift; shift;;
    -separator)   echo Separator "'$2'"; shift; shift;;
    -v)           echo Venue "'$2'"; shift; shift;;
    --venue)      echo Venue "'$2'"; shift; shift;;
    -W)           echo Wait ; shift;;
    --wait)       echo Wait ; shift;;
    -w)           echo Walltime "'$2'"; shift; shift;;
    --walltime)   echo Walltime "'$2'"; shift; shift;;
    *) echo Command is "'$*'"; break;;
  esac
done

id

time $*
echo venue=submit status=5 cputime=3.3 realtime=6.6 1>&3

