#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis3/downloadJobOutputs.py
# @copyright    Copyright 2024-2025 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2024-2025 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import sys
import os
import time
import io
import shutil

from TapisAPI import TapisAPI
from TapisAPI import BaseTapyException

MAXDOWNLOADFAILURES = 1
MAXDOWNLOADRETRIES  = 1

def downloadFile(uri,
                 localPath,
                 reTry=False):
   success = False
   nFail = 0
   while not success and nFail < MAXDOWNLOADFAILURES:
      try:
         response = tapisAPI.download_uri(uri=uri,local_path=localPath)
         success = True
      except:
         if reTry:
            nFail += 1
            time.sleep(30)
         else:
            break

   return success


exitStatus = 0

tapisAPI = TapisAPI()

jobId              = sys.argv[1]
jobOutputDirectory = sys.argv[2]
jobOutputZipfile   = sys.argv[3]

#print(dir(tapisAPI.jobs.getJobOutputDownload))
#print(type(tapisAPI.jobs.getJobOutputDownload.path_name))
#print(tapisAPI.jobs.getJobOutputDownload.path_name)
#print(type(tapisAPI.jobs.getJobOutputDownload.path_parameters))
#print(tapisAPI.jobs.getJobOutputDownload.path_parameters)
try:
#  jobOutputs = tapisAPI.jobs.getJobOutputDownload(jobUuid=jobId,outputPath="/",compress=True,format='zip')
   readBuffer = io.BytesIO(tapisAPI.jobs.getJobOutputDownload(jobUuid=jobId,outputPath="/",compress=True,format='zip'))
   with open(os.path.join(jobOutputDirectory,jobOutputZipfile),'wb') as fpTar:
      shutil.copyfileobj(readBuffer,fpTar)
except BaseTapyException as err:
   exitStatus = 1
   sys.stderr.write(err.message)
   sys.stderr.write("\n")
else:
#  with open(os.path.join(jobOutputDirectory,jobOutputZipfile),'wb') as fpTar:
#     fpTar.write(jobOutputs)
   pass

if False:
   if not os.path.isdir(jobOutputDirectory):
      os.makedirs(jobOutputDirectory)

   filesToIgnore = []
   for jobOutput in jobOutputs:
      outputType = jobOutput['type']
      outputName = jobOutput['name']
      if outputType == 'file' and outputName == '.agave.archive':
         outputURI  = jobOutput['_links']['self']['href']
         success = downloadFile(outputURI,os.path.join(".",outputName))
         if success:
            fpFilesToIgnore = open(outputName,'r')
            filesToIgnore = fpFilesToIgnore.readlines()
            fpFilesToIgnore.close()
         else:
            exitStatus = 1
            sys.stderr.write("Download of %s failed.\n" % (outputName))

         try:
            os.remove(outputName)
         except:
            pass

         filesToIgnore = [ fileToIgnore.strip() for fileToIgnore in filesToIgnore ]
         break

#  print("Files To Ignore")
#  print(filesToIgnore)

   if exitStatus == 0:
      complete = False
      nRetries = 0
      while not complete and nRetries < MAXDOWNLOADRETRIES:
         if nRetries > 0:
            time.sleep(30)
         complete = True
         for jobOutput in jobOutputs:
            outputType = jobOutput['type']
            outputPath = jobOutput['path'].lstrip('/')
            outputURI  = jobOutput['_links']['self']['href']
            if not outputPath in filesToIgnore:
#              print(outputPath,outputType)
               if   outputType == 'file':
                  if not os.path.exists(os.path.join(jobOutputDirectory,outputPath)):
                     success = downloadFile(outputURI,os.path.join(jobOutputDirectory,outputPath))
                     if not success:
                        complete = False
                        sys.stderr.write("Download of %s failed.\n" % (outputPath))
                        try:
                           os.remove(os.path.join(jobOutputDirectory,outputPath))
                        except:
                           pass
               elif outputType == 'dir':
                  if not os.path.isdir(os.path.join(jobOutputDirectory,outputPath)):
                     os.makedirs(os.path.join(jobOutputDirectory,outputPath))
         nRetries += 1

      if not complete:
         exitStatus = 1

sys.exit(exitStatus)
