#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/boinc/transmitresults.sh
# @copyright    Copyright 2017-2018 The Regents of the University of California.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2017-2018 The Regents of the University of California
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 2 ] ; then
   echo usage: $0 jobWorkingDirectory stageOutTarfile
   exit 64
fi

jobWorkingDirectory=$1
stageOutTarfile=$2

binDirectory=$(readlink -f $(dirname $0))

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   localJobIdinstanceId=${stageOutTarfile%_*}
   localJobId=${localJobIdinstanceId%_*}
   instanceId=${localJobIdinstanceId#*_}
   if [ -f .__remote_jobid.${localJobId}_${instanceId} ] ; then
      BATCHID=$(cat .__remote_jobid.${localJobId}_${instanceId})
      resultBundle=result_${BATCHID}.zip
      ${binDirectory}/fetchBatchOutput.py ${BATCHID} ${resultBundle}
      exitStatus=$?

      if [ ${exitStatus} -eq 0 ] ; then
         resultFiles=$(unzip -Z1 ${resultBundle})
         for resultFile in ${resultFiles} ; do
            nice -n 18 unzip -q ${resultBundle} ${resultFile}
            tarZipFile=$(file ${resultFile} | cut -d'"' -f2).gz
            mv ${resultFile} ${tarZipFile}
            chmod 0600 ${tarZipFile}
         done
      else
         echo "resultBundle could not be retrieved"
      fi
   else
      echo "remote_jobid file is missing"
      exitStatus=1
   fi

   if [ ${exitStatus} -eq 0 ] ; then
      if [ ${instanceId} -eq 0 ] ; then
         date +"%s" > .__timestamp_finish.${localJobId}_0
         for outputTar in `ls ${localJobId}_[0-9]*_output.tar* 2> /dev/null` ; do
            localJobIdinstanceId=${outputTar%_*}
            instanceId=${localJobIdinstanceId#*_}
            mv ${outputTar} ${instanceId}
         done
      else
         if [ ! -e ${stageOutTarfile}.gz ] ; then
            if [ ! -e ${stageOutTarfile} ] ; then
               echo "stageOutTarfile is missing"
               exitStatus=1
            fi
         fi
      fi
   fi
   if [ -n "${resultBundle}" ] ; then
      rm -f ${resultBundle}
   fi
fi

exit ${exitStatus}
