#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis/transmitresults.sh
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 2 ] ; then
   echo usage: $0 jobWorkingDirectory stageOutTarfile
   exit 64
fi

jobWorkingDirectory=$1
stageOutTarfile=$2

binDirectory=$(dirname $(readlink -f $0))

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   localJobIdinstanceId=${stageOutTarfile%_*}
   localJobId=${localJobIdinstanceId%_*}
   instanceId=${localJobIdinstanceId#*_}
   if [ -f .__remote_jobid.${localJobId}_${instanceId} ] ; then
      JOBID=$(cat .__remote_jobid.${localJobId}_${instanceId})
      python3 ${binDirectory}/downloadJobOutputs.py ${JOBID} ${jobWorkingDirectory}
      exitStatus=$?
      if [ -f md5sums.start ] ; then
         md5sum --check md5sums.start 2> /dev/null | \
                grep ': OK' | sed -e "s/: OK//" | grep -v '.__' | \
                xargs --delimiter='\n' --max-lines=20 --no-run-if-empty /bin/rm -f
         find . -empty -type d -exec rmdir {} \; 2> /dev/null
         while [ $? -ne 0 ] ; do
            find . -empty -type d -exec rmdir {} \; 2> /dev/null
         done
      fi
   else
      exitStatus=1
   fi
fi

exit ${exitStatus}
