#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis/submitbatchjob.sh
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -lt 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobDescriptionFile
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobDescriptionFile=$3

binDirectory=$(dirname $(readlink -f $0))
export PATH=${binDirectory}:${PATH}

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   case ${jobDescriptionFile} in
      *.tapis)
         localJobIdinstanceId=$(basename ${jobDescriptionFile} .tapis)
         localJobId=${localJobIdinstanceId%%_*}
         instanceId=${localJobIdinstanceId#*_}

         tapisStatus=$(python3 ${binDirectory}/submitJob.py ${jobDescriptionFile})
         exitStatus=$?
         if [ ${exitStatus} -eq 0 ] ; then
            label=$(echo ${tapisStatus} | cut -d' ' -f 1)
            if [ ${label} = jobId: ] ; then
               JOBID=$(echo ${tapisStatus} | cut -d' ' -f 1-2)
            else
               JOBID="-1"
            fi
         else
            JOBID="-1"
         fi
         remoteJobIdFileName=.__remote_jobid.${localJobId}_${instanceId}
         echo ${JOBID} | cut -d" " -f 2 > ${remoteJobIdFileName}

         if [ $# -gt 3 ] ; then
            logRecord=`date`
            shift 3
            while [ $# -gt 0 ] ; do
               logRecord=${logRecord}'\t'$1
               shift 1
            done
            logRecord=${logRecord}'\t'${JOBID}
            echo -e ${logRecord} >> /var/gridman/HUBjobs/tapislog
         fi
         ;;
      *)
         echo "Invalid job class ${jobDescriptionFile}"
         exitStatus=23
         ;;
   esac
fi

if [ ${exitStatus} -eq 0 ] ; then
   echo "${JOBID}"
else
   echo "-1"
fi

exit ${exitStatus}
