#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         Scripts/boinc/retireBatch.py
# @copyright    Copyright (c) 2017-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2017-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  retireBatch.py
#
#  script which monitors the BOINC queue and reports changes in job status
#
import sys
import os

from submit_api import *

BOINCPROJECTURL    = ""
BOINCAUTHENTICATOR = ""


class RetireBoincBatch:
   def __init__(self,
                boincProjectURL,
                boincAuthenticator,
                batchId):
      self.boincProjectURL    = boincProjectURL
      self.boincAuthenticator = boincAuthenticator
      self.batchId            = int(batchId)


   def run(self):
      exitStatus = 0
      batchRequest = CREATE_BATCH_REQ()
      batchRequest.project       = self.boincProjectURL
      batchRequest.authenticator = self.boincAuthenticator
      batchRequest.batch_id      = self.batchId

      retireResponse = retire_batch(batchRequest)

      return(exitStatus)


if __name__ == '__main__':

   if len(sys.argv) == 2:
      batchId    = sys.argv[1]
   else:
      sys.exit(1)

   __retireBoincBatch__ = RetireBoincBatch(BOINCPROJECTURL,BOINCAUTHENTICATOR,
                                           batchId)

   __exitStatus__ = __retireBoincBatch__.run()

   sys.exit(__exitStatus__)


