#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/pbs/submitfromcondor.sh
# @copyright    Copyright 2014-2023 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2014-2023 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -lt 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobDescriptionFile transferredTimestampFile
   exit 64
fi
 
jobWorkingDirectory=$1
jobDescriptionFile=$2
transferredTimestampFile=$3

binPath=$(readlink -f $(dirname $0))
export PATH=${binPath}:${PATH}

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   pegasusTransferInputsFile=$(mktemp .pegasusTransferInputs_XXXXXXXX.tar.gz)
   cat - > ${pegasusTransferInputsFile}
   exitStatus=$?
   if [ ${exitStatus} -eq 0 ] ; then
      if [ -s ${pegasusTransferInputsFile} ] ; then
         tar xf ${pegasusTransferInputsFile}
         exitStatus=$?
         if [ ${exitStatus} -ne 0 ] ; then
            JOBID="tar xf ${pegasusTransferInputsFile} failed"
         fi
      else
         exitStatus=1
         JOBID="${pegasusTransferInputsFile} is empty"
      fi
   else
      JOBID="cat ${pegasusTransferInputsFile} failed"
   fi
   rm -f ${pegasusTransferInputsFile}

   if [ ${exitStatus} -eq 0 ] ; then
      case ${jobDescriptionFile} in
         *.pbs)
            JOBID=`qsub ${jobDescriptionFile} 2>&1`
            exitStatus=$?
            if [ ${exitStatus} -eq 0 ] ; then
               date +"%s" > ${transferredTimestampFile}
            fi
            if [ $# -gt 3 ] ; then
               logRecord=`date`
               shift 3
               while [ $# -gt 0 ] ; do
                  logRecord=${logRecord}'\t'$1
                  shift 1
               done
               logRecord=${logRecord}'\t'${JOBID}
               echo -e ${logRecord} >> ${binPath}/pbslog
            fi
            ;;
         *)
            echo "Invalid job class ${jobDescriptionFile}"
            exitStatus=23
            ;;
      esac
   fi
else
   JOBID="cd ${jobWorkingDirectory} failed"
fi

if [ ${exitStatus} -eq 0 ] ; then
   echo "${JOBID}"
else
   echo "-1"
   if [ -n "${JOBID}" ] ; then
      logRecord=`date`
      logRecord=${logRecord}'\t'${JOBID}
      echo -e ${logRecord} >> ${binPath}/pbslog
      echo "${JOBID}" >&2
   fi
fi

exit ${exitStatus}
