#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis3/listFiles.py
# @copyright    Copyright 2024-2025 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2024-2025 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import sys

from TapisAPI import TapisAPI
from TapisAPI import BaseTapyException

exitStatus = 0

tapisAPI = TapisAPI()

# directory is relative path from system "root" directory
systemId = sys.argv[1]
remoteDirectory = sys.argv[2]

filesList = []
try:
   offset = 0
   allDone = False
   while not allDone:
      partialFilesList = tapisAPI.files.listFiles(systemId=systemId,path=remoteDirectory,offset=offset,recurse=False)
      filesList += partialFilesList
      offset += len(partialFilesList)
      if len(partialFilesList) == 0:
         allDone = True
except BaseTapyException as err:
   exitStatus = 1
   sys.stderr.write(err.message)
   sys.stderr.write("\n")
else:
   if filesList:
      TapisAPI.printFileList(filesList,long_format=True)

sys.exit(exitStatus)
