#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorJobInitialize.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJobInitialize.py
#
#  script which initializes job monitoring statistics files
#
import sys
import os
import sqlite3
import traceback

MONITORROOT  = os.path.join(os.sep,'opt','submit')
DBFILENAME   = "monitorJob.db"
DBFILEPATH   = os.path.join(MONITORROOT,'DB',DBFILENAME)

 
if __name__ == '__main__':

   dbConnection = None
   try:
      dbConnection = sqlite3.connect(DBFILEPATH,isolation_level=None)
      cursor = dbConnection.cursor()
      cursor.executescript("""
                              CREATE TABLE activeJobs (
                                 localJobId     INT         NOT NULL,
                                 instanceId     INT         NOT NULL,
                                 distributorPid INT         NOT NULL,
                                 nCores         INT         DEFAULT 1,
                                 runName        VARCHAR(32) NOT NULL,
                                 messageSite    VARCHAR(32) NOT NULL,
                                 remoteJobId    VARCHAR(32) NOT NULL,
                                 jobStatus      VARCHAR(32) DEFAULT '?',
                                 jobStage       VARCHAR(32) DEFAULT '?',
                                 jobQueue       VARCHAR(32) DEFAULT '?',
                                 hubUserId      INT         DEFAULT NULL,
                                 destination    VARCHAR(32) DEFAULT '?',
                                 timeRecorded   DOUBLE      DEFAULT '0.'
                              );
                              CREATE UNIQUE INDEX globalJobId ON activeJobs (messageSite,remoteJobId);
                              CREATE UNIQUE INDEX localJobId  ON activeJobs (localJobId,instanceId);
                              CREATE        INDEX messageSite ON activeJobs (messageSite);
                              CREATE        INDEX siteQueue   ON activeJobs (messageSite,jobQueue);
                              CREATE        INDEX hubUserId   ON activeJobs (hubUserId);
                              CREATE        INDEX statusTime  ON activeJobs (jobStatus,timeRecorded);

                              CREATE TABLE activeJobSites (
                                 jobSite     VARCHAR(32) UNIQUE PRIMARY KEY,
                                 timeUpdated DOUBLE      DEFAULT '0.'
                              );

                              CREATE TABLE userActivityScores (
                                 hubUserId     INT    NOT NULL,
                                 activityScore DOUBLE DEFAULT '0.5',
                                 timeUpdated   DOUBLE DEFAULT '-1.'
                              );
                           """)
      dbConnection.commit()
   except sqlite3.Error,e:
      if dbConnection:
         dbConnection.rollback()
      print traceback.format_exc()
   finally:
      if dbConnection:
         dbConnection.close()

