#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorProbeR.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorProbeR.py
#
#  script which reports monitor status for all probed sites
#
import sys
import time
import logging

from hubzero.submit.RemoteProbeMonitor import RemoteProbeMonitor

PROBEMONITORHOST = ""
PROBEMONITORPORT = 5728

APPLICATIONLOGGER = logging.getLogger('') 

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.DEBUG)

   logHandler = logging.StreamHandler()

   emptyFilter = EmptyFilter()
   logHandler.addFilter(emptyFilter)

   logFormatter = logging.Formatter('%(asctime)s %(message)s','[%a %b %d %H:%M:%S %Y]')
   logHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logHandler)


def monitorProbeR():
   """Report active probes"""
   remoteProbeMonitor = RemoteProbeMonitor(PROBEMONITORHOST,PROBEMONITORPORT)

   reportSites = sys.argv[1:]

   report = remoteProbeMonitor.reportProbeSiteStatus()
   reportTime = int(time.time())

   if len(report) > 0:
      siteResponses = report.split(':')
#     Sort by FAIL/PASS, score, age of score
      siteResponses.sort(key=lambda x:(x.split(',')[2],int(x.split(',')[3]),int(x.split(',')[1])))

      for siteResponse in siteResponses:
         site,scoreTime,state,score = siteResponse.split(',')
         if (len(reportSites) == 0) or (site in reportSites):
            print("%-30s  %s  %3d  %9.1f" % (site,state,int(score),(reportTime-int(scoreTime))/60.))


if __name__ == '__main__':
   openLogger()
   monitorProbeR()


