#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorJobS.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJobS.py
#
#  script which notifies monitorJob.py of a new job submission
#
import os
import sys
import logging

from hubzero.submit.DaemonsInfo      import DaemonsInfo
from hubzero.submit.RemoteJobMonitor import RemoteJobMonitor

CONFIGURATIONDIRECTORY   = os.path.join(os.sep,'etc','submit')
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

APPLICATIONLOGGER = logging.getLogger('') 

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.DEBUG)

   logHandler = logging.StreamHandler()

   emptyFilter = EmptyFilter()
   logHandler.addFilter(emptyFilter)

   logFormatter = logging.Formatter('%(asctime)s %(message)s','[%a %b %d %H:%M:%S %Y]')
   logHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logHandler)


def monitorJobS(listenURI):
   """new job Submission"""
   siteName         = sys.argv[1]
   identityManagers = [sys.argv[2]]
   siteDesignator   = sys.argv[3]
   remoteJobId      = sys.argv[4]
   hubUserId        = sys.argv[5]
   jobWorkDirectory = sys.argv[6]
   enteredCommand   = sys.argv[7]
   localJobId       = sys.argv[8]
   instanceId       = sys.argv[9]
   destination      = sys.argv[10]
   runName          = sys.argv[11]
   nCores           = sys.argv[12]
   distributorPid   = sys.argv[13]

   remoteJobMonitor = RemoteJobMonitor(listenURI)

   tailFiles = []
   remoteJobMonitor.postJobSubmission(siteName,
                                      identityManagers,
                                      siteDesignator,
                                      remoteJobId,hubUserId,
                                      tailFiles,enteredCommand,
                                      jobWorkDirectory,
                                      localJobId,instanceId,destination,runName,nCores,distributorPid)


if __name__ == '__main__':
   openLogger()

   configFilePath = os.path.join(CONFIGURATIONDIRECTORY,DAEMONSCONFIGURATIONFILE)
   daemonsInfo    = DaemonsInfo(configFilePath)
   listenURI      = daemonsInfo.getDaemonListenURI('jobMonitor','tcp')

   monitorJobS(listenURI)


