#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         monitorJobInitialize.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJobInitialize.sh
#
#  script which controls initialization job monitoring statistics files
#
# Become root if not already.
#
if [ $(id -u) -ne 0 ] ; then
   sudo $0
   exit $?
fi

currentDirectory=${PWD}

DISTRIBUTION=$(lsb_release -is)
MAJORVERSION=$(lsb_release -rs | cut -d . -f 1)

if [ ${DISTRIBUTION} = Debian ] ; then
   /etc/init.d/jobmon stop
else
   if [ ${MAJORVERSION} -eq 6 ] ; then
      /etc/init.d/jobmon stop
   else
      systemctl stop jobmon.service
   fi
fi

mkdir -p /opt/submit/DB
chown gridman:root /opt/submit/DB

cd /opt/submit/DB

rm -f monitorJob.db
python ../monitorJobInitialize.py 
chown gridman:root monitorJob.db
chmod 0640 monitorJob.db

rm -f monitorJob.sql
touch monitorJob.sql
chown gridman:root monitorJob.sql
chmod 0640 monitorJob.sql

sleep 30

cd ${currentDirectory}

if [ ${DISTRIBUTION} = Debian ] ; then
   /etc/init.d/jobmon start
else
   if [ ${MAJORVERSION} -eq 6 ] ; then
      /etc/init.d/jobmon start
   else
      systemctl start jobmon.service
   fi
fi
