#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         personalize-saml-proxy.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2015-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
scriptPath=$(readlink -f $0)
scriptDir=$(dirname ${scriptPath})

if [ $# -lt 3 ] ; then
   echo usage: $0 user gridshibHome userProxyFile
   exit 64
fi

exitStatus=0

user=$1
gridshibHome=$2
userProxyFile=$3

if [ ! -d ${gridshibHome} ] ; then
   echo "${gridshibHome} is not a directory"
   exitStatus=1
else
   if [ ! -x ${gridshibHome}/bin/gridshib-saml-issuer ] ; then
      echo "gridshib-saml-issuer does not exist in ${gridshibHome}/bin"
      exitStatus=1
   fi
fi

if [ ${exitStatus} -eq 0 ] ; then
   export X509_CERT_DIR=/etc/grid-security/certificates

   export JAVA_HOME=/usr
   export GRIDSHIB_HOME=${gridshibHome}

   userProxyPath=/tmp/${userProxyFile}
   userProxyPathTmp=${userProxyPath}.$$

#From random.org
#3ZGVcTf2LU9aaFQwlPNC
#fa2mW4aXqIWeE2proSHp
#NA6HwxzyLo0W0L41hQP6
#5g69QIgxVGSbjboee3bP
#52nkf29Ie9lE5gJ0yJVt
#5IGuXJ4PWomQXa4dyADi
#yHQvL735O9IcDyzXZsoL
#vAniBVNO089W157sLU66
#wHASvJmAXf29QfAcz5eA
#Cj1v1GGZIZZp0O8jzv0s

# combine strings from above.
   token=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   id=$(id -u ${user})
   userId=$(echo ${token}:${id} | md5sum | cut -d' ' -f1)

   ${GRIDSHIB_HOME}/bin/gridshib-saml-issuer --debug \
                                             --config ${GRIDSHIB_HOME}/etc/tg-gateway-config.properties \
                                             --user ${userId} --sender-vouches \
                                             --authn --authnInstant "`date`" \
                                             --x509 --x509Lifetime 86400 --outfile ${userProxyPathTmp}
   exitStatus=$?
   if [ ${exitStatus} -eq 0 ] ; then
      export COMMUNITYSECRET="$(cat ${userProxyPathTmp})"
      rm -f ${userProxyPathTmp}
      sudo -u ${user} ${scriptDir}/writecommunitysecret.sh ${userProxyPath}
      exitStatus=$?
   fi
fi

exit ${exitStatus}
