#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         jobMetrics.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  jobMetrics.py
#
#  script which submits staged jobs
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.MeasureJobs          import MeasureJobs

JOBMETRICSLOGLEVEL = "INFO"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

JOBMETRICSLOGLOCATION = os.path.join(os.sep,'var','log','submit','monitors')
JOBMETRICSLOGFILENAME = "jobMetrics.log"

JOBMETRICSPIDFILE = os.path.join(os.sep,'var','run','submit','submit-jobmetrics.pid')

PREVIOUSSTATE = 'EXECUTED'
NEXTSTATE     = 'MEASURING'

if __name__ == '__main__':
   jobMetricsLogLevel       = os.getenv("JOBMETRICSLOGLEVEL",JOBMETRICSLOGLEVEL)
   jobMetricsLogLocation    = os.getenv("JOBMETRICSLOGLOCATION",JOBMETRICSLOGLOCATION)
   jobMetricsLogFilename    = os.getenv("JOBMETRICSLOGFILENAME",JOBMETRICSLOGFILENAME)
   jobMetriccsPidFile       = os.getenv("JOBMETRICSPIDFILE",JOBMETRICSPIDFILE)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory           = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile   = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(JOBMETRICSLOGLEVEL)
   applicationUtilities.openFileLogger(jobMetricsLogLocation,jobMetricsLogFilename,
                                       jobMetricsLogLevel)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(JOBMETRICSPIDFILE)

   measureJobs = MeasureJobs(daemonsDirectory,daemonsConfigurationFile,
                             infosDirectory,infosConfigurationFile,
                             PREVIOUSSTATE,NEXTSTATE)
   measureJobs.process()


