# @package      hubzero-submit-monitors
# @file         JobInfo.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import time
import logging
from UserDict import UserDict

class JobInfo(UserDict):
   def __init__(self,
                siteName='?',
                identityNames=[],
                aggregator='?',
                siteDesignator='?',
                remoteJobId='?',
                distributorPid=0,
                runName="",
                nCores=1,
                localJobId=0,
                instanceId=0,
                jobStatus='?',
                jobStage='?',
                jobQueue='?',
                hubUserId='?',
                destination='?',
                executionHost='?',
                timeRecorded=0.):
      self.logger = logging.getLogger(__name__)

      UserDict.__init__(self)

      self['siteName']        = siteName
      self['identityNames']   = identityNames
      self['aggregator']      = aggregator
      self['siteDesignator']  = siteDesignator
      self['remoteJobId']     = remoteJobId
      self['distributorPid']  = distributorPid
      self['runName']         = runName
      self['nCores']          = nCores
      self['localJobId']      = localJobId
      self['instanceId']      = instanceId
      self['jobStatus']       = jobStatus
      self['jobStage']        = jobStage
      self['jobQueue']        = jobQueue
      self['hubUserId']       = hubUserId
      self['destination']     = destination
      self['executionHost']   = executionHost
      if timeRecorded > 0.:
         self['timeRecorded'] = timeRecorded
      else:
         self['timeRecorded'] = time.time()


   def __missing__(self,
                   key):
      self[key] = '?'

      return('?')


