<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="glossary.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> </td>
</tr></table>
<hr>
</div>
<div class="appendix" title="Appendix A. Tutorial VM">
<div class="titlepage"><div><div><h2 class="title">
<a name="tutorial_vm"></a>Appendix A. Tutorial VM</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="tutorial_vm.php#idp26540688">A.1. Introduction</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#vm_virtualbox">A.2. VirtualBox</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#vm_amazon">A.3. Amazon EC2</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#vm_futuregrid">A.4. FutureGrid</a></span></dt>
</dl></div>
<div class="section" title="A.1. Introduction">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="idp26540688"></a>A.1. Introduction</h2></div></div></div>
<p>This appendix provides information on how to launch the Pegasus
    Tutorial VM. The VM is a quick way to get started using Pegasus. It comes
    pre-configured with Pegasus, DAGMan and Condor so that you can begin
    running workflows immediately.</p>
<p>In the following sections we will cover how to start, log into, and
    stop the tutorial VM locally, using the VirtualBox virtualization
    software, and remotely on Amazon EC2 and FutureGrid.</p>
</div>
<div class="section" title="A.2. VirtualBox">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="vm_virtualbox"></a>A.2. VirtualBox</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="tutorial_vm.php#idp7951072">A.2.1. Install VirtualBox</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#idp9329040">A.2.2. Download VM Image</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#idp18917904">A.2.3. Create Virtual Machine</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#idp12030064">A.2.4. Terminating the VM</a></span></dt>
</dl></div>
<p>VirtualBox is a free desktop virtual machine manager. You can use it
    to run the Pegasus Tutorial VM on your desktop or laptop.</p>
<div class="section" title="A.2.1. Install VirtualBox">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp7951072"></a>A.2.1. Install VirtualBox</h3></div></div></div>
<p>First, download and install the VirtualBox platform package from
      the VirtualBox website: <a class="ulink" href="https://www.virtualbox.org" target="_top">https://www.virtualbox.org</a></p>
</div>
<div class="section" title="A.2.2. Download VM Image">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp9329040"></a>A.2.2. Download VM Image</h3></div></div></div>
<p>Next, download the Pegasus Tutorial VM from the Pegasus download page: <a class="ulink" href="http://pegasus.isi.edu/downloads" target="_top">http://pegasus.isi.edu/downloads</a>
      </p>
<p>Unzip the downloaded file and move the <code class="literal">.vmdk</code>
      file it contains to somewhere that you can find it later.</p>
</div>
<div class="section" title="A.2.3. Create Virtual Machine">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp18917904"></a>A.2.3. Create Virtual Machine</h3></div></div></div>
<p>Start VirtualBox. You should get a screen that looks like
      this:</p>
<div class="figure">
<a name="idp18802624"></a><p class="title"><b>Figure A.1. VirtualBox Welcome Screen</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_01.png" height="360" alt="VirtualBox Welcome Screen"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Click on the "New" button. The "Create New Virtual Machine Wizard"
      will appear:</p>
<div class="figure">
<a name="idp23583760"></a><p class="title"><b>Figure A.2. Create New Virtual Machine Wizard</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_02.png" height="360" alt="Create New Virtual Machine Wizard"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Click "Continue" to get to the VM Name and OS Type step:</p>
<div class="figure">
<a name="idp12616832"></a><p class="title"><b>Figure A.3. VM Name and OS Type</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_03.png" height="360" alt="VM Name and OS Type"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>In the Name field type "Pegasus Tutorial". Set the Operating
      System to "Linux" and the Version to "Red Hat (64 bit)".</p>
<div class="warning" title="Warning" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Warning</h3>
<p>Make sure to select "Red Hat (64 bit)" as the Version. If this
        is incorrect the virtual machine may not be able to start.</p>
</div>
<p>Click "Continue" to get to the Memory step. You can leave this at
      the default of 512 MB.</p>
<div class="figure">
<a name="idp28115024"></a><p class="title"><b>Figure A.4. Memory</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_04.png" height="360" alt="Memory"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Click "Continue" again to get to the "Virtual Hard Disk"
      step:</p>
<div class="figure">
<a name="idp24857856"></a><p class="title"><b>Figure A.5. Virtual Hard Disk</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_05.png" height="360" alt="Virtual Hard Disk"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Leave "Start-up Disk" checked. Choose "Use existing hard disk".
      Click the folder icon and locate the .vmdk file that you downloaded
      earlier.</p>
<p>When you have selected the .vmdk file, choose "Open" and then
      click "Continue" to get to the Summary page:</p>
<div class="figure">
<a name="idp11812112"></a><p class="title"><b>Figure A.6. Summary</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_06.png" height="360" alt="Summary"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Click "Create". You will get back to the welcome screen showing
      the new virtual machine:</p>
<div class="figure">
<a name="idp8638144"></a><p class="title"><b>Figure A.7. Welcome Screen with new virtual machine</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_07.png" height="360" alt="Welcome Screen with new virtual machine"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Click on the name of the virual machine and then click "Start".
      After a few seconds you should get to the login screen:</p>
<div class="figure">
<a name="idp8018688"></a><p class="title"><b>Figure A.8. Login Screen</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_vb_08.png" height="360" alt="Login Screen"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Log in as user "<span class="bold"><strong>tutorial</strong></span>" with
      password "<span class="bold"><strong>pegasus</strong></span>".</p>
<p>After you log in you can return to the <a class="link" href="tutorial.php" title="Chapter 2. Tutorial">tutorial chapter</a> to complete the
      tutorial.</p>
</div>
<div class="section" title="A.2.4. Terminating the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp12030064"></a>A.2.4. Terminating the VM</h3></div></div></div>
<p>When you are done with the tutorial you can shut down the VM by
      typing:</p>
<pre class="programlisting">$ sudo /sbin/poweroff</pre>
<p>at the prompt and then enter the tutorial user's password.</p>
<p>Alternatively, you can just close the window and choose "Power off
      the machine".</p>
</div>
</div>
<div class="section" title="A.3. Amazon EC2">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="vm_amazon"></a>A.3. Amazon EC2</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="tutorial_vm.php#idp9940000">A.3.1. Launching the VM</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#idp30008400">A.3.2. Logging into the VM</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#idp12889360">A.3.3. Shutting down the VM</a></span></dt>
</dl></div>
<p>In order to launch the tutorial VM you need to sign up for an Amazon
    Web Services account here: <a class="ulink" href="http://aws.amazon.com" target="_top">http://aws.amazon.com</a></p>
<div class="section" title="A.3.1. Launching the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp9940000"></a>A.3.1. Launching the VM</h3></div></div></div>
<p>Once you have an account, sign into the AWS Management Console at
      this URL: <a class="ulink" href="http://console.aws.amazon.com" target="_top">http://console.aws.amazon.com</a>.
      You will get a page that looks like this:</p>
<div class="figure">
<a name="idp30869024"></a><p class="title"><b>Figure A.9. AWS Management Console</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_01.png" height="360" alt="AWS Management Console"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Choose the "EC2" icon under "Amazon Web Services". You will get
      this page:</p>
<div class="figure">
<a name="idp29410256"></a><p class="title"><b>Figure A.10. EC2 Management Console</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_02.png" height="360" alt="EC2 Management Console"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>First, make sure the “Region:” drop-down in the upper left-hand
      corner is set to “US West (Oregon)”.</p>
<p>Click on the “AMIs” link on the left side and set “Viewing:” to
      “All Images”, “All Platforms”, and type “Pegasus Tutorial VM” in the
      search box:</p>
<div class="figure">
<a name="idp8441936"></a><p class="title"><b>Figure A.11. Locating the Tutorial VM</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_03.png" height="360" alt="Locating the Tutorial VM"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>You will see several versions of the VM. If you don’t see any AMIs
      named “Pegasus Tutorial VM” you may need to click the Refresh button. We
      update the VM regularly, so your search results will not match the
      picture above.</p>
<p>Check the check box next to the latest Pegasus Tutorial VM and
      click the “Launch” button. The "Request Instances Wizard" will pop
      up:</p>
<div class="figure">
<a name="idp25388336"></a><p class="title"><b>Figure A.12. Request Instances Wizard: Step 1</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_04.png" height="360" alt="Request Instances Wizard: Step 1"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>In the first step of the Request Instances Wizard choose the
      “Large” instance type and click “Continue”:</p>
<div class="figure">
<a name="idp26842816"></a><p class="title"><b>Figure A.13. Request Instances Wizard: Step 2</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_05.png" height="360" alt="Request Instances Wizard: Step 2"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Don’t change anything on the “Advanced Instance Options” step and
      click “Continue”:</p>
<div class="figure">
<a name="idp13396784"></a><p class="title"><b>Figure A.14. Request Instances Wizard: Step 3</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_06.png" height="360" alt="Request Instances Wizard: Step 3"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>On the “Storage Device Configuration” step make sure “Delete on
      Termination” is set to "true", then click “Continue”:</p>
<div class="figure">
<a name="idp20575712"></a><p class="title"><b>Figure A.15. Request Instances Wizard: Step 4</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_07.png" height="360" alt="Request Instances Wizard: Step 4"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>On the next step type “Pegasus Tutorial” into the “Value” field
      and click “Continue”:</p>
<div class="figure">
<a name="idp9617984"></a><p class="title"><b>Figure A.16. Request Instances Wizard: Step 5</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_08.png" height="360" alt="Request Instances Wizard: Step 5"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>On the next page choose one of your existing key pairs and click
      “Continue”. If you don’t have an existing key pair you can also choose
      “Proceed without a Key Pair” (you will log in with a
      username/password).</p>
<div class="figure">
<a name="idp8756528"></a><p class="title"><b>Figure A.17. Request Instances Wizard: Step 6</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_09.png" height="360" alt="Request Instances Wizard: Step 6"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>On the next page choose “Create a new Security Group”. Name the
      security group “Pegasus Tutorial” and give it a description. Create an
      inbound TCP rule to allow connections on port 22 (SSH) from source
      0.0.0.0/0 and click "Add Rule". Then click “Continue”.</p>
<p>Note that you will only need to create this security group once.
      If you launch the Pegasus Tutorial VM again the security group should
      appear in the list of existing security groups.</p>
<div class="figure">
<a name="idp6924848"></a><p class="title"><b>Figure A.18. Request Instances Wizard: Step 7</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_10.png" height="360" alt="Request Instances Wizard: Step 7"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>On the last step of the wizard validate your selections and click
      “Launch”.</p>
<div class="figure">
<a name="idp8861552"></a><p class="title"><b>Figure A.19. Running Instances</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_11.png" width="540" alt="Running Instances"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Finally, navigate to the “Instances” section and check the
      checkbox next to the “Pegasus Tutorial” instance. Copy the DNS name to
      the clipboard. In this example the name is: <span class="bold"><strong>ec2-50-112-45-59.us-west-2.compute.amazonaws.com</strong></span>.
      Yours will almost surely be different.</p>
<p>At this point your VM will take a few minutes to boot. Wait until
      the “Status Checks” column reads: “2/2 checks passed” before continuing.
      You may need to click the Refresh button.</p>
</div>
<div class="section" title="A.3.2. Logging into the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp30008400"></a>A.3.2. Logging into the VM</h3></div></div></div>
<p>Log into the VM using SSH. The username is ‘<span class="bold"><strong>tutorial</strong></span>’ and the password is ‘<span class="bold"><strong>pegasus</strong></span>’.</p>
<p>On UNIX machines such as Linux or Mac OS X you can log in via SSH
      by opening a terminal and typing:</p>
<pre class="programlisting">$ <span class="bold"><strong>ssh tutorial@ec2-50-112-45-59.us-west-2.compute.amazonaws.com</strong></span>
The authenticity of host 'ec2-50-112-45-59.us-west-2.compute.amazonaws.com (50.112.45.59)' can't be established.
RSA key fingerprint is 56:b0:11:ba:8f:98:ba:dd:75:f6:3c:09:ef:b9:2a:ac.
Are you sure you want to continue connecting (yes/no)? <span class="bold"><strong>yes</strong></span>
tutorial's password: <span class="bold"><strong>pegasus</strong></span>
[tutorial@localhost ~]$ </pre>
<p>where “ec2-50-112-45-59.us-west-2.compute.amazonaws.com” is the
      DNS name of your VM that you copied from the AWS Management
      Console.</p>
<p>If you are on Windows you will need to install an SSH client. You
      can download the PuTTY SSH client and find documentation for how to
      configure it here: <a class="ulink" href="http://www.chiark.greenend.org.uk/~sgtatham/putty" target="_top">http://www.chiark.greenend.org.uk/~sgtatham/putty</a></p>
</div>
<div class="section" title="A.3.3. Shutting down the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp12889360"></a>A.3.3. Shutting down the VM</h3></div></div></div>
<p>When you are finished with the tutorial, make sure you terminate
      the VM. If you forget to do this you will be charged for all of the
      hours that the VM runs.</p>
<p>To terminate the VM click on “Instances” link on the left side of
      the AWS Management Console, check the box next to the “Pegasus Tutorial”
      VM, and click “Instance Actions”--&gt;“Terminate”:</p>
<div class="figure">
<a name="idp9700624"></a><p class="title"><b>Figure A.20. Terminate Instance</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_12.png" height="360" alt="Terminate Instance"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>Then click "Yes, terminate":</p>
<div class="figure">
<a name="idp8602016"></a><p class="title"><b>Figure A.21. Yes, Terminate Instance</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0" width="100%"><tr><td><img src="images/vm_ec2_13.png" height="360" alt="Yes, Terminate Instance"></td></tr></table></div></div>
</div>
<br class="figure-break">
</div>
</div>
<div class="section" title="A.4. FutureGrid">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="vm_futuregrid"></a>A.4. FutureGrid</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="tutorial_vm.php#fg_getting_started">A.4.1. Getting Started</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#fg_launching_vm">A.4.2. Launching the VM</a></span></dt>
<dt><span class="section"><a href="tutorial_vm.php#fg_terminating_vm">A.4.3. Terminating the VM</a></span></dt>
</dl></div>
<p>The FutureGrid Project (<a class="ulink" href="https://portal.futuregrid.org" target="_top">https://portal.futuregrid.org</a>)
    is a cloud computing testbed supported by the National Science Foundation.
    It consists of a collection of computational, networking, and storage
    resources located throughout the United States. The goal of the FutureGrid
    Project is to study the behavior and usefulness of cloud computing
    technologies. It provides a platform where researchers can experiment with
    different cloud technologies.</p>
<div class="section" title="A.4.1. Getting Started">
<div class="titlepage"><div><div><h3 class="title">
<a name="fg_getting_started"></a>A.4.1. Getting Started</h3></div></div></div>
<p>The Pegasus Tutorial VM has been deployed to the FutureGrid
      "India" site using OpenStack. In order to launch the VM, you will need
      to have a FutureGrid account. You can get one by going to <a class="ulink" href="https://portal.futuregrid.org" target="_top">https://portal.futuregrid.org</a>
      and either joining an existing project, or starting a new
      project.</p>
<p>If you are not familiar with using OpenStack on FutureGrid, we
      recommend that you review the "Using OpenStack on FutureGrid" tutorial
      found here: <a class="ulink" href="https://portal.futuregrid.org/tutorials/openstack" target="_top">https://portal.futuregrid.org/tutorials/openstack</a>.</p>
</div>
<div class="section" title="A.4.2. Launching the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="fg_launching_vm"></a>A.4.2. Launching the VM</h3></div></div></div>
<p>First, log into the India site using your FutureGrid username and
      password:</p>
<pre class="programlisting">$ <span class="bold"><strong>ssh USERNAME@india.futuregrid.org</strong></span></pre>
<p>If you have not already done so, source the
      <code class="filename">novarc</code> file that contains your OpenStack
      credentials:</p>
<pre class="programlisting">$ <span class="bold"><strong>source ~/.futuregrid/openstack/novarc</strong></span></pre>
<p>Also, load the euca2ools module to add them to your
      environment:</p>
<pre class="programlisting">$ <span class="bold"><strong>module load euca2ools</strong></span></pre>
<p>Next, query OpenStack to find the latest Pegasus Tutorial VM
      image:</p>
<pre class="programlisting">$ <span class="bold"><strong>euca-describe-images | grep PegasusTutorialVM</strong></span>
IMAGE ami-0000003e juve/PegasusTutorialVM-4.0.1.fg.manifest.xml available public x86_64 ...</pre>
<p>Find the image ID (ami-0000003e in the example above). If you get
      multiple results, use the latest version.</p>
<p>Launch the tutorial VM using the
      <code class="literal">euca-run-instances</code> command with the image ID you
      found in the previous step:</p>
<pre class="programlisting">$ <span class="bold"><strong>euca-run-instances ami-0000003e</strong></span>
RESERVATION    r-y9ue0rs7    461884eef90047fbb4eb9ec92f22a1e3   default
INSTANCE    <span class="bold"><strong>i-00000c38</strong></span>    ami-0000003e    server-3128    server-3128    pending    ...</pre>
<p>Note the instance ID (i-00000c38 in the example). Monitor the
      status of your VM by invoking the
      <code class="literal">euca-describe-instances</code> command periodically with the
      instance ID until the VM status changes from "pending" to
      "running":</p>
<pre class="programlisting">$ <span class="bold"><strong>euca-describe-instances i-00000c38</strong></span>
RESERVATION    r-y9ue0rs7    461884eef90047fbb4eb9ec92f22a1e3    default
INSTANCE    i-00000c38    ami-0000003e    server-3128    server-3128    <span class="bold"><strong>pending</strong></span>   ...
$ ...
$ <span class="bold"><strong>euca-describe-instances i-00000c38</strong></span>
RESERVATION     r-y9ue0rs7     461884eef90047fbb4eb9ec92f22a1e3     default
INSTANCE    i-00000c38    ami-0000003e    <span class="bold"><strong>149.165.158.123</strong></span>    server-3128    <span class="bold"><strong>running</strong></span>    ...</pre>
<p>Note down the IP address of the instance (149.165.158.123 in the
      example). Log into the VM as the tutorial user:</p>
<pre class="programlisting">$ <span class="bold"><strong>ssh tutorial@149.165.158.123</strong></span></pre>
<p>The password is "pegasus".</p>
<p>At this point you should return to the <a class="link" href="tutorial.php" title="Chapter 2. Tutorial">tutorial chapter</a> and complete the
      tutorial.</p>
</div>
<div class="section" title="A.4.3. Terminating the VM">
<div class="titlepage"><div><div><h3 class="title">
<a name="fg_terminating_vm"></a>A.4.3. Terminating the VM</h3></div></div></div>
<p>Log out of the VM by typing:</p>
<pre class="programlisting">$ <span class="bold"><strong>exit</strong></span></pre>
<p>Using the instance ID you found in the last section (NOT the image
      ID), terminate the VM by typing:</p>
<pre class="programlisting">$ <span class="bold"><strong>euca-terminate-instances i-00000c38</strong></span>
INSTANCE    i-00000c38</pre>
<p>When you invoke <code class="literal">euca-describe-instances</code> you
      should no longer see the VM running (you should not get any
      output):</p>
<pre class="programlisting">$ <span class="bold"><strong>euca-describe-instances i-00000c38</strong></span>
$ </pre>
</div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="glossary.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> </td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 13. Glossary </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> </td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
