<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-tc-client.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-transfer.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-tc-converter">
<a name="cli-pegasus-tc-converter"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-tc-converter — A client to convert transformation catalog from one format to another format.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-tc-converter_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-tc-converter</strong></span> [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>…] [<span class="strong"><strong>-v</strong></span>] [<span class="strong"><strong>-q</strong></span>] [<span class="strong"><strong>-V</strong></span>] [<span class="strong"><strong>-h</strong></span>]<br>
                     [<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>fmt</em></span>] [<span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>fmt</em></span>]<br>
                     [<span class="strong"><strong>-N</strong></span> <span class="emphasis"><em>dbusername</em></span>] [<span class="strong"><strong>-P</strong></span> <span class="emphasis"><em>dbpassword</em></span>] [<span class="strong"><strong>-U</strong></span> <span class="emphasis"><em>dburl</em></span>] [<span class="strong"><strong>-H</strong></span> <span class="emphasis"><em>dbhost</em></span>]<br>
                     <span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…] <span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>outfile</em></span></p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-tc-converter_description"></a><h2>Description</h2>
<p>The tc-convert program is used to convert the transformation catalog from one format to another.</p>
<p>Currently, the following formats of transformation catalog exist:</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>Text</strong></span>
</span></dt>
<dd>
<p class="simpara">
This is a easy to read  multi line textual format.
</p>
<p class="simpara">A sample entry in this format looks as follows:</p>
<pre class="screen">tr example::keg:1.0 {
        site isi {
        profile env "JAVA_HOME" "/bin/java.1.6"
        pfn "/path/to/keg"
        arch  "x86"
        os    "linux"
        osrelease "fc"
        osversion "4"
        type "installed"
    }
}</pre>
</dd>
<dt><span class="term">
<span class="strong"><strong>File</strong></span>
</span></dt>
<dd>
<p class="simpara">
This is a tuple based format which contains 6 columns.
</p>
<pre class="screen">RESOURCE  LFN  PFN  TYPE  SYSINFO  PROFILES</pre>
<p class="simpara">A sample entry in this format looks as follows</p>
<pre class="screen">isi  example::keg:1.0  /path/to/keg  INSTALLED  INTEL32::LINUX:fc_4:  env::JAVA_HOME="/bin/java.1.6"</pre>
</dd>
<dt><span class="term">
<span class="strong"><strong>Database</strong></span>
</span></dt>
<dd>
Only MySQL is supported for the time being.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-tc-converter_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
<p class="simpara">
The <span class="strong"><strong>-D</strong></span> option allows an experienced user to override certain properties
which influence the program execution, among them the default location of
the user’s properties file and the <span class="strong"><strong>PEGASUS_HOME</strong></span> location. One may set several
CLI properties by giving this option multiple times.
</p>
<p class="simpara">The <span class="strong"><strong>-D</strong></span> option(s) must be the first option on the command line. CLI properties
take precedence over the file-based properties of the same key.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>fmt</em></span>
, </span><span class="term">
<span class="strong"><strong>--iformat</strong></span> <span class="emphasis"><em>fmt</em></span>
</span>
</dt>
<dd>
The input format of the input files. Valid values for the input format
are: <span class="strong"><strong>File</strong></span>, <span class="strong"><strong>Text</strong></span>, and <span class="strong"><strong>Database</strong></span>.
</dd>
</dl></div>
<p><span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>fmt</em></span>
<span class="strong"><strong>--oformat</strong></span> <span class="emphasis"><em>fmt</em></span>
The output format of the output file. Valid values for the output format
are: <span class="strong"><strong>File</strong></span>, <span class="strong"><strong>Text</strong></span>, and <span class="strong"><strong>Database</strong></span>.</p>
<p><span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…]
<span class="strong"><strong>--input</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…]
The comma separated list of input files that need to be converted to a
file in the format specified by the <span class="strong"><strong>--oformat</strong></span> option.</p>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>outfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--output</strong></span> <span class="emphasis"><em>outfile</em></span>
</span>
</dt>
<dd>
The output file to which the output needs to be written out to.
</dd>
</dl></div>
<div class="refsect2" title="Other Options">
<a name="pegasus-tc-converter_other_options"></a><h3>Other Options</h3>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-N</strong></span> <span class="emphasis"><em>dbusername</em></span>
, </span><span class="term">
<span class="strong"><strong>--db-user-name</strong></span> <span class="emphasis"><em>dbusername</em></span>
</span>
</dt>
<dd>
The database user name.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-P</strong></span> <span class="emphasis"><em>dbpassword</em></span>
, </span><span class="term">
<span class="strong"><strong>--db-user-pwd</strong></span> <span class="emphasis"><em>dbpassword</em></span>
</span>
</dt>
<dd>
The database user password.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-U</strong></span> <span class="emphasis"><em>dburl</em></span>
, </span><span class="term">
<span class="strong"><strong>--db-url</strong></span> <span class="emphasis"><em>dburl</em></span>
</span>
</dt>
<dd>
The database url.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-H</strong></span> <span class="emphasis"><em>dbhost</em></span>
, </span><span class="term">
<span class="strong"><strong>--db-host</strong></span> <span class="emphasis"><em>dbhost</em></span>
</span>
</dt>
<dd>
The database host.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Increases the verbosity of messages about what is going on. By default,
all FATAL ERROR, ERROR , CONSOLE and WARNINGS messages are logged.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
Decreases the verbosity of messages about what is going on. By default,
all FATAL ERROR, ERROR , CONSOLE and WARNINGS messages are logged.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Displays the current version number of the Pegasus Workflow Planner
Software.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Displays all the options to the <span class="strong"><strong>pegasus-tc-converter</strong></span> command.
</dd>
</dl></div>
</div>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-tc-converter_example"></a><h2>Example</h2>
<div class="variablelist"><dl>
<dt><span class="term">
Text to file format conversion
</span></dt>
<dd></dd>
</dl></div>
<pre class="screen">pegasus-tc-converter -i tc.data -I File -o tc.txt  -O Text -v</pre>
<div class="variablelist"><dl>
<dt><span class="term">
File to Database(new) format conversion
</span></dt>
<dd></dd>
</dl></div>
<pre class="screen">pegasus-tc-converter -i tc.data -I File -N mysql_user -P mysql_pwd -U jdbc:mysql://localhost:3306/tc -H localhost -O Database -v</pre>
<div class="variablelist"><dl>
<dt><span class="term">
Database (username, password, host, url specified in properties file) to text format conversion
</span></dt>
<dd></dd>
</dl></div>
<pre class="screen">pegasus-tc-converter -I Database -o tc.txt -O Text -vvvvv</pre>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-tc-converter_authors"></a><h2>Authors</h2>
<p>Prasanth Thomas</p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-tc-client.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-transfer.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-tc-client </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-transfer</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
