<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="open_science_grid.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="condor_examples.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="chapter" title="Chapter 8. Example Workflows">
<div class="titlepage"><div><div><h2 class="title">
<a name="example_workflows"></a>Chapter 8. Example Workflows</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="example_workflows.php#grid_examples">8.1. Grid Examples</a></span></dt>
<dt><span class="section"><a href="condor_examples.php">8.2. Condor Examples</a></span></dt>
<dt><span class="section"><a href="local_shell_examples.php">8.3. Local Shell Examples</a></span></dt>
<dt><span class="section"><a href="notifications_example.php">8.4. Notifications Example</a></span></dt>
<dt><span class="section"><a href="workflow_of_workflows.php">8.5. Workflow of Workflows</a></span></dt>
</dl></div>
<p>These examples are included in the Pegasus distribution and can be
  found under <code class="filename">share/pegasus/examples</code> in your Pegasus
  install (<code class="filename">/usr/share/pegasus/examples</code> for native
  packages)</p>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>These examples are intended to be a starting point for when you want
    to create your own workflows and want to see how other workflows are set
    up. The example workflows will probably not work in your environment
    without modifications. Site and transformation catalogs contain site and
    user specifics such as paths to scratch directories and installed
    software, and at least minor modificiations are required to get the
    workflows to plan and run. </p>
</div>
<div class="section" title="8.1. Grid Examples">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="grid_examples"></a>8.1. Grid Examples</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="example_workflows.php#example_black_diamond">8.1.1. Black Diamond</a></span></dt>
<dt><span class="section"><a href="example_workflows.php#idp11562496">8.1.2. NASA/IPAC Montage</a></span></dt>
<dt><span class="section"><a href="example_workflows.php#idp6182400">8.1.3. Rosetta</a></span></dt>
</dl></div>
<p>These examples assumes you have access to a cluster with Globus
    installed. A pre-ws gatekeeper and gridftp server is required. You also
    need Globus and Pegasus installed, both on the machine you are submitting
    from, and the cluster.</p>
<div class="section" title="8.1.1. Black Diamond">
<div class="titlepage"><div><div><h3 class="title">
<a name="example_black_diamond"></a>8.1.1. Black Diamond</h3></div></div></div>
<p>Pegasus is shipped with 3 different Black Diamond examples for the
      grid. This is to highlight the available DAX APIs which are Java, Perl
      and Python. The examples can be found under:</p>
<pre class="programlisting">share/pegasus/examples/grid-blackdiamond-java/
share/pegasus/examples/grid-blackdiamond-perl/
share/pegasus/examples/grid-blackdiamond-python/</pre>
<p>The workflow has 4 nodes, layed out in a diamond shape, with files
      being passed between them (f.*):</p>
<div class="mediaobject" align="center"><table border="0" summary="manufactured viewport for HTML img" cellspacing="0" cellpadding="0"><tr><td align="center" valign="middle"><img src="images/examples-diamond.jpg" align="middle"></td></tr></table></div>
<p>The binary for the nodes is a simple "mock application" name
      <span class="command"><strong>keg</strong></span> ("canonical example for the grid") which reads
      input files designated by arguments, writes them back onto output files,
      and produces on STDOUT a summary of where and when it was run. Keg ships
      with Pegasus in the bin directory.</p>
<p>This example ships with a "submit" script which will build the
      replica catalog, the transformation catalog, and the site catalog. When
      you create your own workflows, such a submit script is not needed if you
      want to maintain those catalogs manually.</p>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The use of <code class="filename">./submit</code> scripts in these
        examples are just to make it more easy to run the examples out of the
        box. For a production site, the catalogs (transformation, replica,
        site) may or may not be static or generated by other tooling.</p>
</div>
<p>To test the examples, edit the <span class="command"><strong>submit</strong></span> script
      and change the cluster config to the setup and install locations for
      your cluster. Then run:</p>
<pre class="programlisting">$ <span class="bold"><strong>./submit</strong></span></pre>
<p>The workflow should now be submitted and in the output you should
      see a work dir location for the instance. With that directory you can
      monitor the workflow with:</p>
<pre class="programlisting">$ <span class="bold"><strong>pegasus-status [workdir]</strong></span></pre>
<p>Once the workflow is done, you can make sure it was sucessful
      with:</p>
<pre class="programlisting">$ <span class="bold"><strong>pegasus-analyzer -d [workdir]</strong></span></pre>
</div>
<div class="section" title="8.1.2. NASA/IPAC Montage">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp11562496"></a>8.1.2. NASA/IPAC Montage</h3></div></div></div>
<p>This example can be found under</p>
<pre class="programlisting"><code class="filename">share/pegasus/examples/grid-montage/</code></pre>
<p>The NASA IPAC Montage (<a class="ulink" href="http://montage.ipac.caltech.edu/" target="_top">http://montage.ipac.caltech.edu/</a>)
      workflow projects/montages a set of input images from telescopes like
      Hubble and end up with images like <a class="ulink" href="http://montage.ipac.caltech.edu/images/m104.jpg" target="_top">http://montage.ipac.caltech.edu/images/m104.jpg</a>
      . The test workflow is for a 1 by 1 degrees tile. It has about 45 input
      images which all have to be projected, background modeled and adjusted
      to come out as one seamless image.</p>
<p>Just like the <a class="xref" href="example_workflows.php#example_black_diamond" title="8.1.1. Black Diamond">Black Diamond</a> above, this example uses a <code class="filename">./submit</code>
      script.</p>
<p>The Montage DAX is generated with a tool called
      <code class="filename">mDAG</code> shipped with Montage which generates the
      workflow.</p>
</div>
<div class="section" title="8.1.3. Rosetta">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp6182400"></a>8.1.3. Rosetta</h3></div></div></div>
<p>This example can be found under</p>
<pre class="programlisting"><code class="filename">share/pegasus/examples/grid-rosetta/</code></pre>
<p>Rosetta (<a class="ulink" href="http://www.rosettacommons.org/" target="_top">http://www.rosettacommons.org/</a>)
      is a high resolution protein prediction and design software. Highlights
      in this example are:</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p>Using the Pegasus Java API to generate the DAX</p></li>
<li class="listitem"><p>The DAX generator loops over the input PDBs and creates a job
          for each input</p></li>
<li class="listitem"><p>The jobs all have a dependency on a flatfile database. For
          simplicity, each job depends on all the files in the database
          directory.</p></li>
<li class="listitem"><p>Job clustering is turned on to make each grid job run longer
          and better utilize the compute cluster</p></li>
</ul></div>
<p>Just like the <a class="xref" href="example_workflows.php#example_black_diamond" title="8.1.1. Black Diamond">Black Diamond</a> above, this example uses a <code class="filename">./submit</code>
      script.</p>
</div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="open_science_grid.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="condor_examples.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.10. Open Science Grid Using glideinWMS </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 8.2. Condor Examples</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
