<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="monitoring_debugging_stats.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="dashboard.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="plotting_statistics"></a>6.2. Plotting and Statistics</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="plotting_statistics.php#idp48681072">6.2.1. pegasus-statistics</a></span></dt>
<dt><span class="section"><a href="plotting_statistics.php#idp57868272">6.2.2. pegasus-plots</a></span></dt>
</dl></div>
<p>Pegasus plotting and statistics tools queries the Stampede database
    created by pegasus-monitord for generating the output.The stampede scheme
    can be found <a class="link" href="monitoring.php#stampede-schema">here</a>.</p>
<p>The statistics and plotting tools use the following terminology for
    defining tasks, jobs etc. Pegasus takes in a DAX which is composed of
    tasks. Pegasus plans it into a Condor DAG / Executable workflow that
    consists of Jobs. In case of Clustering, multiple tasks in the DAX can be
    captured into a single job in the Executable workflow. When DAGMan
    executes a job, a job instance is populated . Job instances capture
    information as seen by DAGMan. In case DAGMan retires a job on detecting a
    failure , a new job instance is populated. When DAGMan finds a job
    instance has finished , an invocation is associated with job instance. In
    case of clustered job, multiple invocations will be associated with a
    single job instance. If a Pre script or Post Script is associated with a
    job instance, then invocations are populated in the database for the
    corresponding job instance.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp48681072"></a>6.2.1. pegasus-statistics</h3></div></div></div>
<p>Pegasus statistics can compute statistics over one or more than
      one workflow run.</p>
<p>Command to generate statistics over a single run is as shown
      below.</p>
<pre class="programlisting">$ <span class="emphasis"><em><span class="bold"><strong>pegasus-statistics /scratch/grid-setup/run0001/ -s all</strong></span> </em></span>


#
# Pegasus Workflow Management System - http://pegasus.isi.edu
#
# Workflow summary:
#   Summary of the workflow execution. It shows total
#   tasks/jobs/sub workflows run, how many succeeded/failed etc.
#   In case of hierarchical workflow the calculation shows the
#   statistics across all the sub workflows.It shows the following
#   statistics about tasks, jobs and sub workflows.
#     * Succeeded - total count of succeeded tasks/jobs/sub workflows.
#     * Failed - total count of failed tasks/jobs/sub workflows.
#     * Incomplete - total count of tasks/jobs/sub workflows that are
#       not in succeeded or failed state. This includes all the jobs
#       that are not submitted, submitted but not completed etc. This
#       is calculated as  difference between 'total' count and sum of
#       'succeeded' and 'failed' count.
#     * Total - total count of tasks/jobs/sub workflows.
#     * Retries - total retry count of tasks/jobs/sub workflows.
#     * Total+Retries - total count of tasks/jobs/sub workflows executed
#       during workflow run. This is the cumulative of retries,
#       succeeded and failed count.
# Workflow wall time:
#   The wall time from the start of the workflow execution to the end as
#   reported by the DAGMAN.In case of rescue dag the value is the
#   cumulative of all retries.
# Workflow cumulative job wall time:
#   The sum of the wall time of all jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job wall time as seen from submit side:
#   The sum of the wall time of all jobs as reported by DAGMan.
#   This is similar to the regular cumulative job wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.
# Cumulative job wall time as seen from submit side:
#   The sum of the wall time of all jobs as reported by DAGMan.
#   This is similar to the regular cumulative job wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.
# Workflow cumulative job badput wall time:
#   The sum of the wall time of all failed jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job badput wall time as seen from submit side:
#   The sum of the wall time of all failed jobs as reported by DAGMan.
#   This is similar to the regular cumulative job badput wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.

------------------------------------------------------------------------------
Type           Succeeded Failed  Incomplete  Total     Retries   Total+Retries
Tasks          4         0       0           4         0         4
Jobs           17        0       0           17        0         17
Sub-Workflows  0         0       0           0         0         0
------------------------------------------------------------------------------

Workflow wall time                                       : 5 mins, 18 secs
Workflow cumulative job wall time                        : 4 mins, 2 secs
Cumulative job wall time as seen from submit side        : 4 mins, 10 secs
Workflow cumulative job badput wall time                 : 0
Cumulative job badput wall time as seen from submit side : 0

</pre>
<p>By default the output gets generated to a statistics folder inside
      the submit directory. The output that is generated by pegasus-statistics
      is based on the value set for command line option 's'(statistics_level).
      In the sample run the command line option 's' is set to 'all' to
      generate all the statistics information for the workflow run. Please
      consult the pegasus-statistics man page to find a detailed description
      of various command line options.</p>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>In case of hierarchal workflows, the metrics that are displayed
        on stdout take into account all the jobs/tasks/sub workflows that make
        up the workflow by recursively iterating through each sub
        workflow.</p>
</div>
<p></p>
<p>Command to generate statistics over all workflow runs populated in
      a single database is as shown below.</p>
<pre class="programlisting">$ <span class="emphasis"><em><span class="bold"><strong>pegasus-statistics -Dpegasus.monitord.output='mysql://s_user:s_user123@127.0.0.1:3306/stampede' -o /scratch/workflow_1_2/statistics -s all --multiple-wf</strong></span> </em></span>


#
# Pegasus Workflow Management System - http://pegasus.isi.edu
#
# Workflow summary:
#   Summary of the workflow execution. It shows total
#   tasks/jobs/sub workflows run, how many succeeded/failed etc.
#   In case of hierarchical workflow the calculation shows the
#   statistics across all the sub workflows.It shows the following
#   statistics about tasks, jobs and sub workflows.
#     * Succeeded - total count of succeeded tasks/jobs/sub workflows.
#     * Failed - total count of failed tasks/jobs/sub workflows.
#     * Incomplete - total count of tasks/jobs/sub workflows that are
#       not in succeeded or failed state. This includes all the jobs
#       that are not submitted, submitted but not completed etc. This
#       is calculated as  difference between 'total' count and sum of
#       'succeeded' and 'failed' count.
#     * Total - total count of tasks/jobs/sub workflows.
#     * Retries - total retry count of tasks/jobs/sub workflows.
#     * Total+Retries - total count of tasks/jobs/sub workflows executed
#       during workflow run. This is the cumulative of retries,
#       succeeded and failed count.
# Workflow wall time:
#   The wall time from the start of the workflow execution to the end as
#   reported by the DAGMAN.In case of rescue dag the value is the
#   cumulative of all retries.
# Workflow cumulative job wall time:
#   The sum of the wall time of all jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job wall time as seen from submit side:
#   The sum of the wall time of all jobs as reported by DAGMan.
#   This is similar to the regular cumulative job wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.
# Workflow cumulative job badput wall time:
#   The sum of the wall time of all failed jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job badput wall time as seen from submit side:
#   The sum of the wall time of all failed jobs as reported by DAGMan.
#   This is similar to the regular cumulative job badput wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.

------------------------------------------------------------------------------
Type           Succeeded Failed  Incomplete  Total     Retries   Total+Retries
Tasks          8         0       0           8         0         8
Jobs           34        0       0           34        0         34
Sub-Workflows  0         0       0           0         0         0
------------------------------------------------------------------------------

Workflow cumulative job wall time                        : 8 mins, 5 secs
Cumulative job wall time as seen from submit side        : 8 mins, 35 secs
Workflow cumulative job badput wall time                 : 0
Cumulative job badput wall time as seen from submit side : 0

</pre>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>When computing statistics over multiple workflows, please
          note,</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>All workflow run information should be populated in a
              single STAMPEDE database.</p></li>
<li class="listitem"><p>The --output argument must be specified.</p></li>
<li class="listitem"><p>Job statistics information is not computed.</p></li>
<li class="listitem"><p>Workflow wall time information is not computed.</p></li>
</ol></div>
</div>
<p>Pegasus statistics can also compute statistics over a few
      specified workflow runs, by specifying the either the submit
      directories, or the workflow UUIDs.</p>
<pre class="programlisting">pegasus-statistics -Dpegasus.monitord.output='&lt;DB_URL&gt;' -o &lt;OUTPUT_DIR&gt; &lt;SUBMIT_DIR_1&gt; &lt;SUBMIT_DIR_2&gt; .. &lt;SUBMIT_DIR_n&gt;

OR

pegasus-statistics -Dpegasus.monitord.output='&lt;DB_URL&gt;' -o &lt;OUTPUT_DIR&gt; <span class="bold"><strong>--isuuid</strong></span> &lt;UUID_1&gt; &lt;UUID_2&gt; .. &lt;UUID_n&gt;

</pre>
<p>pegasus-statistics summary which is printed on the stdout contains
      the following information.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<p><span class="bold"><strong>Workflow summary</strong></span> - Summary of
          the workflow execution. In case of hierarchical workflow the
          calculation shows the statistics across all the sub workflows.It
          shows the following statistics about tasks, jobs and sub
          workflows.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: circle; ">
<li class="listitem"><p><span class="bold"><strong>Succeeded</strong></span> - total count
              of succeeded tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Failed</strong></span> - total count of
              failed tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Incomplete</strong></span> - total count
              of tasks/jobs/sub workflows that are not in succeeded or failed
              state. This includes all the jobs that are not submitted,
              submitted but not completed etc. This is calculated as
              difference between 'total' count and sum of 'succeeded' and
              'failed' count.</p></li>
<li class="listitem"><p><span class="bold"><strong>Total</strong></span> - total count of
              tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Retries</strong></span> - total retry
              count of tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Total Run</strong></span> - total count
              of tasks/jobs/sub workflows executed during workflow run. This
              is the cumulative of total retries, succeeded and failed
              count.</p></li>
</ul></div>
</li>
<li class="listitem"><p><span class="bold"><strong>Workflow wall time</strong></span> - The wall
          time from the start of the workflow execution to the end as reported
          by the DAGMAN.In case of rescue dag the value is the cumulative of
          all retries.</p></li>
<li class="listitem"><p><span class="bold"><strong>Workflow cummulate job wall
          time</strong></span> - The sum of the wall time of all jobs as reported
          by kickstart. In case of job retries the value is the cumulative of
          all retries. For workflows having sub workflow jobs (i.e SUBDAG and
          SUBDAX jobs), the wall time value includes jobs from the sub
          workflows as well. This value is multiplied by the multiplier_factor
          in the job instance table.</p></li>
<li class="listitem"><p><span class="bold"><strong>Cumulative job wall time as seen from
          submit side</strong></span> - The sum of the wall time of all jobs as
          reported by DAGMan. This is similar to the regular cumulative job
          wall time, but includes job management overhead and delays. In case
          of job retries the value is the cumulative of all retries. For
          workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs), the
          wall time value includes jobs from the sub workflows. This value is
          multiplied by the multiplier_factor in the job instance
          table.</p></li>
</ul></div>
<p>pegasus-statistics generates the following statistics files based
      on the command line options set.</p>
<p><span class="bold"><strong>Workflow statistics file per workflow
      [workflow.txt]</strong></span></p>
<p>Workflow statistics file per workflow contains the following
      information about each workflow run. In case of hierarchal workflows,
      the file contains a table for each sub workflow. The file also contains
      a 'Total' table at the bottom which is the cumulative of all the
      individual statistics details.</p>
<p>A sample table is shown below. It shows the following statistics
      about tasks, jobs and sub workflows.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Workflow retries</strong></span> - number of
          times a workflow was retried.</p></li>
<li class="listitem"><p><span class="bold"><strong>Succeeded</strong></span> - total count of
          succeeded tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Failed</strong></span> - total count of
          failed tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Incomplete</strong></span> - total count of
          tasks/jobs/sub workflows that are not in succeeded or failed state.
          This includes all the jobs that are not submitted, submitted but not
          completed etc. This is calculated as difference between 'total'
          count and sum of 'succeeded' and 'failed' count.</p></li>
<li class="listitem"><p><span class="bold"><strong>Total</strong></span> - total count of
          tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Retries</strong></span> - total retry count
          of tasks/jobs/sub workflows.</p></li>
<li class="listitem"><p><span class="bold"><strong>Total Run</strong></span> - total count of
          tasks/jobs/sub workflows executed during workflow run. This is the
          cumulative of total retries, succeeded and failed count.</p></li>
</ul></div>
<div class="table">
<a name="idp50456288"></a><p class="title"><b>Table 6.1. Workflow Statistics</b></p>
<div class="table-contents"><table summary="Workflow Statistics" border="1">
<colgroup>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">#</th>
<th align="center">Type</th>
<th align="center">Succeeded</th>
<th align="center">Failed</th>
<th align="center">Incomplete</th>
<th align="center">Total</th>
<th align="center">Retries</th>
<th align="center">Total Run</th>
<th align="center">Workflow Retries</th>
</tr></thead>
<tbody>
<tr>
<td align="center">2a6df11b-9972-4ba0-b4ba-4fd39c357af4</td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center"> </td>
<td align="center">0</td>
</tr>
<tr>
<td align="center"> </td>
<td align="center">Tasks</td>
<td align="center">4</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">4</td>
<td align="center">0</td>
<td align="center">4</td>
<td align="center"> </td>
</tr>
<tr>
<td align="center"> </td>
<td align="center">Jobs</td>
<td align="center">13</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">13</td>
<td align="center">0</td>
<td align="center">13</td>
<td align="center"> </td>
</tr>
<tr>
<td align="center"> </td>
<td align="center">Sub Workflows</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center">0</td>
<td align="center"> </td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p><span class="bold"><strong>Job statistics file per workflow
      [jobs.txt]</strong></span></p>
<p>Job statistics file per workflow contains the following details
      about the job instances in each workflow. A sample file is shown
      below.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Job</strong></span> - the name of the job
          instance</p></li>
<li class="listitem"><p><span class="bold"><strong>Try</strong></span> - the number representing
          the job instance run count.</p></li>
<li class="listitem"><p><span class="bold"><strong>Site</strong></span> - the site where the job
          instance ran.</p></li>
<li class="listitem"><p><span class="bold"><strong>Kickstart(sec.)</strong></span> - the actual
          duration of the job instance in seconds on the remote compute
          node.</p></li>
<li class="listitem"><p><span class="bold"><strong>Mult</strong></span> - multiplier factor from
          the job instance table for the job.</p></li>
<li class="listitem"><p><span class="bold"><strong>Kickstart_Mult</strong></span> - value of the
          Kickstart column multiplied by Mult.</p></li>
<li class="listitem"><p><span class="bold"><strong>CPU-Time</strong></span> - remote CPU time
          computed as the stime + utime (when Kickstart is not used, this is
          empty).</p></li>
<li class="listitem"><p><span class="bold"><strong>Post(sec.)</strong></span> - the postscript
          time as reported by DAGMan.</p></li>
<li class="listitem"><p><span class="bold"><strong>CondorQTime(sec.)</strong></span> - the time
          between submission by DAGMan and the remote Grid submission. It is
          an estimate of the time spent in the condor q on the submit node
          .</p></li>
<li class="listitem"><p><span class="bold"><strong>Resource(sec.)</strong></span> - the time
          between the remote Grid submission and start of remote execution .
          It is an estimate of the time job instance spent in the remote queue
          .</p></li>
<li class="listitem"><p><span class="bold"><strong>Runtime(sec.)</strong></span> - the time
          spent on the resource as seen by Condor DAGMan . Is always
          &gt;=kickstart .</p></li>
<li class="listitem"><p><span class="bold"><strong>Seqexec(sec.)</strong></span> - the time
          taken for the completion of a clustered job instance .</p></li>
<li class="listitem"><p><span class="bold"><strong>Seqexec-Delay(sec.)</strong></span> - the
          time difference between the time for the completion of a clustered
          job instance and sum of all the individual tasks kickstart time
          .</p></li>
</ul></div>
<div class="table">
<a name="idp47530992"></a><p class="title"><b>Table 6.2. Job statistics</b></p>
<div class="table-contents"><table summary="Job statistics" border="1">
<colgroup>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Job</th>
<th align="center">Try</th>
<th align="center">Site</th>
<th align="center">Kickstart</th>
<th align="center">Mult</th>
<th align="center">Kickstart_Mult</th>
<th align="center">CPU-Time</th>
<th align="center">Post</th>
<th align="center">CondorQTime</th>
<th align="center">Resource</th>
<th align="center">Runtime</th>
<th align="center">Seqexec</th>
<th align="center">Seqexec-Delay</th>
</tr></thead>
<tbody>
<tr>
<td align="center">analyze_ID0000004</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">60.002</td>
<td align="center">1</td>
<td align="center">60.002</td>
<td align="center">59.843</td>
<td align="center">5.0</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">62.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">create_dir_diamond_0_local</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.027</td>
<td align="center">1</td>
<td align="center">0.027</td>
<td align="center">0.003</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">findrange_ID0000002</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">60.001</td>
<td align="center">10</td>
<td align="center">600.01</td>
<td align="center">59.921</td>
<td align="center">5.0</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">60.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">findrange_ID0000003</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">60.002</td>
<td align="center">10</td>
<td align="center">600.02</td>
<td align="center">59.912</td>
<td align="center">5.0</td>
<td align="center">10.0</td>
<td align="center">-</td>
<td align="center">61.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">preprocess_ID0000001</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">60.002</td>
<td align="center">1</td>
<td align="center">60.002</td>
<td align="center">59.898</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">60.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">register_local_1_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.459</td>
<td align="center">1</td>
<td align="center">0.459</td>
<td align="center">0.432</td>
<td align="center">6.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">register_local_1_1</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.338</td>
<td align="center">1</td>
<td align="center">0.338</td>
<td align="center">0.331</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">register_local_2_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.348</td>
<td align="center">1</td>
<td align="center">0.348</td>
<td align="center">0.342</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">stage_in_local_local_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.39</td>
<td align="center">1</td>
<td align="center">0.39</td>
<td align="center">0.032</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">stage_out_local_local_0_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.165</td>
<td align="center">1</td>
<td align="center">0.165</td>
<td align="center">0.108</td>
<td align="center">5.0</td>
<td align="center">10.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">stage_out_local_local_1_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.147</td>
<td align="center">1</td>
<td align="center">0.147</td>
<td align="center">0.098</td>
<td align="center">7.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">stage_out_local_local_1_1</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.139</td>
<td align="center">1</td>
<td align="center">0.139</td>
<td align="center">0.089</td>
<td align="center">5.0</td>
<td align="center">6.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
<tr>
<td align="center">stage_out_local_local_2_0</td>
<td align="center">1</td>
<td align="center">local</td>
<td align="center">0.145</td>
<td align="center">1</td>
<td align="center">0.145</td>
<td align="center">0.101</td>
<td align="center">5.0</td>
<td align="center">5.0</td>
<td align="center">-</td>
<td align="center">0.0</td>
<td align="center">-</td>
<td align="center">-</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p><span class="bold"><strong>Transformation statistics file per workflow
      [breakdown.txt]</strong></span></p>
<p>Transformation statistics file per workflow contains information
      about the invocations in each workflow grouped by transformation name. A
      sample file is shown below.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Transformation</strong></span> - name of the
          transformation.</p></li>
<li class="listitem"><p><span class="bold"><strong>Count</strong></span> - the number of times
          invocations with a given transformation name was executed.</p></li>
<li class="listitem"><p><span class="bold"><strong>Succeeded</strong></span> - the count of
          succeeded invocations with a given logical transformation name
          .</p></li>
<li class="listitem"><p><span class="bold"><strong>Failed</strong></span> - the count of failed
          invocations with a given logical transformation name .</p></li>
<li class="listitem"><p><span class="bold"><strong>Min (sec.)</strong></span> - the minimum
          runtime value of invocations with a given logical transformation
          name times the multipler_factor.</p></li>
<li class="listitem"><p><span class="bold"><strong>Max (sec.)</strong></span> - the minimum
          runtime value of invocations with a given logical transformation
          name times the multiplier_factor.</p></li>
<li class="listitem"><p><span class="bold"><strong>Mean (sec.)</strong></span> - the mean of the
          invocation runtimes with a given logical transformation name times
          the multiplier_factor.</p></li>
<li class="listitem"><p><span class="bold"><strong>Total (sec.)</strong></span> - the cumulative
          of runtime value of invocations with a given logical transformation
          name times the multiplier_factor.</p></li>
</ul></div>
<div class="table">
<a name="idp58606992"></a><p class="title"><b>Table 6.3. Transformation Statistics</b></p>
<div class="table-contents"><table summary="Transformation Statistics" border="1">
<colgroup>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Transformation</th>
<th align="center">Count</th>
<th align="center">Succeeded</th>
<th align="center">Failed</th>
<th align="center">Min</th>
<th align="center">Max</th>
<th align="center">Mean</th>
<th align="center">Total</th>
</tr></thead>
<tbody>
<tr>
<td align="center">dagman::post</td>
<td align="center">13</td>
<td align="center">13</td>
<td align="center">0</td>
<td align="center">5.0</td>
<td align="center">7.0</td>
<td align="center">5.231</td>
<td align="center">68.0</td>
</tr>
<tr>
<td align="center">diamond::analyze</td>
<td align="center">1</td>
<td align="center">1</td>
<td align="center">0</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
</tr>
<tr>
<td align="center">diamond::findrange</td>
<td align="center">2</td>
<td align="center">2</td>
<td align="center">0</td>
<td align="center">600.01</td>
<td align="center">600.02</td>
<td align="center">600.02</td>
<td align="center">1200.03</td>
</tr>
<tr>
<td align="center">diamond::preprocess</td>
<td align="center">1</td>
<td align="center">1</td>
<td align="center">0</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
<td align="center">60.002</td>
</tr>
<tr>
<td align="center">pegasus::dirmanager</td>
<td align="center">1</td>
<td align="center">1</td>
<td align="center">0</td>
<td align="center">0.027</td>
<td align="center">0.027</td>
<td align="center">0.027</td>
<td align="center">0.027</td>
</tr>
<tr>
<td align="center">pegasus::pegasus-transfer</td>
<td align="center">5</td>
<td align="center">5</td>
<td align="center">0</td>
<td align="center">0.139</td>
<td align="center">0.39</td>
<td align="center">0.197</td>
<td align="center">0.986</td>
</tr>
<tr>
<td align="center">pegasus::rc-client</td>
<td align="center">3</td>
<td align="center">3</td>
<td align="center">0</td>
<td align="center">0.338</td>
<td align="center">0.459</td>
<td align="center">0.382</td>
<td align="center">1.145</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p><span class="bold"><strong>Time statistics file
      [time.txt]</strong></span></p>
<p>Time statistics file contains job instance and invocation
      statistics information grouped by time and host. The time grouping can
      be on day/hour. The file contains the following tables Job instance
      statistics per day/hour, Invocation statistics per day/hour, Job
      instance statistics by host per day/hour and Invocation by host per
      day/hour. A sample Invocation statistics by host per day table is shown
      below.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Job instance statistics per
          day/hour</strong></span> - the number of job instances run, total runtime
          sorted by day/hour.</p></li>
<li class="listitem"><p><span class="bold"><strong>Invocation statistics per
          day/hour</strong></span> - the number of invocations , total runtime
          sorted by day/hour.</p></li>
<li class="listitem"><p><span class="bold"><strong>Job instance statistics by host per
          day/hour</strong></span> - the number of job instances run, total runtime
          on each host sorted by day/hour.</p></li>
<li class="listitem"><p><span class="bold"><strong>Invocation statistics by host per
          day/hour</strong></span> - the number of invocations , total runtime on
          each host sorted by day/hour.</p></li>
</ul></div>
<div class="table">
<a name="idp56670432"></a><p class="title"><b>Table 6.4. Invocation statistics by host per day</b></p>
<div class="table-contents"><table summary="Invocation statistics by host per day" border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Date [YYYY-MM-DD]</th>
<th align="center">Host</th>
<th align="center">Count</th>
<th align="center">Runtime (Sec.)</th>
</tr></thead>
<tbody><tr>
<td align="center">2011-07-15</td>
<td align="center">butterfly.isi.edu</td>
<td align="center">54</td>
<td align="center">625.094</td>
</tr></tbody>
</table></div>
</div>
<br class="table-break">
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp57868272"></a>6.2.2. pegasus-plots</h3></div></div></div>
<p>Pegasus-plots generates graphs and charts to visualize workflow
      execution. To generate graphs and charts run the command as shown
      below.</p>
<pre class="programlisting">$ <span class="emphasis"><em>pegasus-plots  -p all  /scratch/grid-setup/run0001/</em></span>


...

******************************************** SUMMARY ********************************************

Graphs and charts generated by pegasus-plots can be viewed by opening the generated html file in the web browser  :
/scratch/grid-setup/run0001/plots/index.html

**************************************************************************************************</pre>
<p>By default the output gets generated to plots folder inside the
      submit directory. The output that is generated by pegasus-plots is based
      on the value set for command line option 'p'(plotting_level).In the
      sample run the command line option 'p' is set to 'all' to generate all
      the charts and graphs for the workflow run. Please consult the
      pegasus-plots man page to find a detailed description of various command
      line options.pegasus-plots generates an index.html file which provides
      links to all the generated charts and plots. A sample index.html page is
      show below.</p>
<div class="figure">
<a name="idp57872112"></a><p class="title"><b>Figure 6.1. pegasus-plot index page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/pegasus_plots_index.png" width="100%" alt="pegasus-plot index page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>pegasus-plots generates the following plots and charts.</p>
<p><span class="bold"><strong>Dax Graph</strong></span></p>
<p>Graph representation of the DAX file. A sample page is shown
      below.</p>
<div class="figure">
<a name="idp51158896"></a><p class="title"><b>Figure 6.2. DAX Graph</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dax_page.png" width="100%" alt="DAX Graph"></td></tr></table></div></div>
</div>
<br class="figure-break"><p><span class="bold"><strong>Dag Graph</strong></span></p>
<p>Graph representation of the DAG file. A sample page is shown
      below.</p>
<div class="figure">
<a name="idp51163056"></a><p class="title"><b>Figure 6.3. DAG Graph</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dag_page.png" width="100%" alt="DAG Graph"></td></tr></table></div></div>
</div>
<br class="figure-break"><p><span class="bold"><strong>Gantt workflow execution
      chart</strong></span></p>
<p>Gantt chart of the workflow execution run. A sample page is shown
      below.</p>
<div class="figure">
<a name="idp51167232"></a><p class="title"><b>Figure 6.4. Gantt Chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/gantt_chart_page.png" width="100%" alt="Gantt Chart"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The toolbar at the top provides zoom in/out , pan
      left/right/top/bottom and show/hide job name functionality.The toolbar
      at the bottom can be used to show/hide job states. Failed job instances
      are shown in red border in the chart. Clicking on a sub workflow job
      instance will take you to the corresponding sub workflow chart.</p>
<p><span class="bold"><strong>Host over time chart</strong></span></p>
<p>Host over time chart of the workflow execution run. A sample page
      is shown below.</p>
<div class="figure">
<a name="idp51172192"></a><p class="title"><b>Figure 6.5. Host over time chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/host_chart_page.png" width="100%" alt="Host over time chart"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The toolbar at the top provides zoom in/out , pan
      left/right/top/bottom and show/hide host name functionality.The toolbar
      at the bottom can be used to show/hide job states. Failed job instances
      are shown in red border in the chart. Clicking on a sub workflow job
      instance will take you to the corresponding sub workflow chart.</p>
<p><span class="bold"><strong>Time chart</strong></span></p>
<p>Time chart shows job instance/invocation count and runtime of the
      workflow run over time. A sample page is shown below.</p>
<div class="figure">
<a name="idp57527072"></a><p class="title"><b>Figure 6.6. Time chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/time_chart_page.png" width="100%" alt="Time chart"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The toolbar at the top provides zoom in/out and pan
      left/right/top/bottom functionality. The toolbar at the bottom can be
      used to switch between job instances/ invocations and day/hour
      filtering.</p>
<p><span class="bold"><strong>Breakdown chart</strong></span></p>
<p>Breakdown chart shows invocation count and runtime of the workflow
      run grouped by transformation name. A sample page is shown below.</p>
<div class="figure">
<a name="idp57532048"></a><p class="title"><b>Figure 6.7. Breakdown chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/breakdown_chart_page.png" width="100%" alt="Breakdown chart"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The toolbar at the bottom can be used to switch between invocation
      count and runtime filtering. Legends can be clicked to get more
      details.</p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="monitoring_debugging_stats.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="monitoring_debugging_stats.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="dashboard.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 6. Monitoring, Debugging and Statistics </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 6.3. Dashboard</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
