<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="ch11s03.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="configuration.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="idp52211856"></a>11.4. Ensemble Manager</h2></div></div></div>
<p>The ensemble manager is a service that manages collections of
    workflows called ensembles. The ensemble manager is useful when you have a
    set of workflows you need to run over a long period of time. It can
    throttle the number of concurrent planning and running workflows, and plan
    and run workflows in priority order. A typical use-case is a user with 100
    workflows to run, who needs no more than one to be planned at a time, and
    needs no more than two to be running concurrently.</p>
<p>The ensemble manager also allows workflows to be submitted and
    monitored programmatically through its RESTful interface, which makes it
    an ideal platform for integrating workflows into larger applications such
    as science gateways and portals.</p>
<p>To start the ensemble manager server, run:</p>
<pre class="literallayout">$ pegasus-em server</pre>
<p>Once the ensemble manager is running, you can create an ensemble
    with:</p>
<pre class="literallayout">$ pegasus-em create myruns</pre>
<p>where "myruns" is the name of the ensemble.</p>
<p>Then you can submit a workflow to the ensemble by running:</p>
<pre class="literallayout">$ pegasus-em submit myruns.run1 ./plan.sh run1.dax</pre>
<p>Where the name of the ensemble is "myruns", the name of the workflow
    is "run1", and "./plan.sh run1.dax" is the command for planning the
    workflow from the current working directory. The planning command should
    either be a direct invocation of pegasus-plan, or a shell script that
    calls pegasus-plan. If a shell script is used, then it should not redirect
    the output of pegasus-plan, because the ensemble manager reads the output
    to determine whether pegasus-plan succeeded and what is the submit
    directory of the workflow.</p>
<p>To check the status of your ensembles run:</p>
<pre class="literallayout">$ pegasus-em ensembles</pre>
<p>To check the status of your workflows run:</p>
<pre class="literallayout">$ pegasus-em workflows myruns</pre>
<p>To check the status of a specific workflow, run:</p>
<pre class="literallayout">$ pegasus-em status myruns.run1</pre>
<p>To help with debugging, the ensemble manager has an analyze command
    that emits diagnostic information about a workflow, including the output
    of pegasus-analyzer, if possible. To analyze a workflow, run:</p>
<pre class="literallayout">$ pegasus-em analyze myruns.run1</pre>
<p>Ensembles can be paused to prevent workflows from being planned and
    executed. Workflows in a paused ensemble will continue to run, but no new
    workflows will be planned or executed. To pause an ensemble, run:</p>
<pre class="literallayout">$ pegasus-em pause myruns</pre>
<p>Paused ensembles can be reactivated by running:</p>
<pre class="literallayout">$ pegasus-em activate myruns</pre>
<p>A workflow might fail during planning. In that case, run the analyze
    command to examine the planner output, make the necessary corrections to
    the workflow configuration, and replan the workflow by running:</p>
<pre class="literallayout">$ pegasus-em replan myruns.run1</pre>
<p>A workflow might also fail during execution. In that case, run the
    analyze command to identify the issue, correct the problem, and rerun the
    workflow by running:</p>
<pre class="literallayout">$ pegasus-em rerun myruns.run1</pre>
<p>Workflows in an ensemble can have different priorities. These
    priorities are used to determine the order in which workflows in the
    ensemble will be planned and executed. Priorities are specified using the
    '-p' option of the submit command. They can also be modified after a
    workflow has been submitted by running:</p>
<pre class="literallayout">$ pegasus-em priority myruns.run1 -p 10</pre>
<p>where 10 is the desired priority. Higher values have higher
    priority, the default is 0, and negative values are allowed.</p>
<p>Each ensemble has a pair of throttles that limit the number of
    workflows that are concurrently planning and executing. These throttles
    are called max_planning and max_running. Max planning limits the number of
    workflows in the ensemble that can be planned concurrently. Max running
    limits the number of workflows in the ensemble that can be running
    concurrently. These throttles are useful to limit the impact of planning
    on the memory usage of the submit host, and the load on the submit host
    and remote site caused by concurrently running workflows. The throttles
    can be specified with the '-R' and '-P' options of the create command.
    They can also be updated using the config command:</p>
<pre class="literallayout">$ pegasus-em config myruns.run1 -P 1 -R 5</pre>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="ch11s03.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="service.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="configuration.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">11.3. Running Pegasus Service under Apache HTTPD </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 12. Configuration</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
