<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="campus_cluster.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="open_science_grid.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="xsede"></a>7.9. XSEDE</h2></div></div></div>
<p>The <a class="ulink" href="https://www.xsede.org/" target="_top">Extreme Science and
    Engineering Discovery Environment (XSEDE)</a> provides a set of High
    Performance Computing (HPC) and High Throughput Computing (HTC)
    resources.</p>
<p>For the HPC resources, it is recommended to run using <a class="link" href="globus_gram.php" title="7.4. Remote Cluster using Globus GRAM">Globus GRAM</a> or <a class="link" href="condor_pool.php#glideins" title="7.2.1. Glideins">glideins</a>. Most of these resources have fast
    parallel file systesm, so running with <a class="link" href="data_staging_configuration.php" title="5.3. Data Staging Configuration">sharedfs data staging</a> is
    recommended. Below is example site catalog and pegasusrc to run on <a class="ulink" href="http://www.sdsc.edu/us/resources/trestles/" target="_top">SDSC
    Trestles</a>:</p>
<pre class="programlisting">
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;
      
    &lt;site  handle="local" arch="x86_64" os="LINUX"&gt;
        &lt;directory type="shared-scratch" path="/tmp/wf/work"&gt;
            &lt;file-server operation="all" url="file:///tmp/wf/work"/&gt;
        &lt;/directory&gt;
        &lt;directory type="local-storage" path="/tmp/wf/storage"&gt;
            &lt;file-server operation="all" url="file:///tmp/wf/storage"/&gt;
        &lt;/directory&gt;
    &lt;/site&gt;

    &lt;site handle="Trestles" arch="x86_64" os="LINUX"&gt;
       &lt;grid type="gt5" contact="trestles.sdsc.edu:2119/jobmanager-fork" scheduler="PBS" jobtype="auxillary"/&gt;
       &lt;grid type="gt5" contact="trestles.sdsc.edu:2119/jobmanager-pbs" scheduler="PBS" jobtype="compute"/&gt;
       &lt;directory type="shared-scratch" path="/phase1/USERNAME"&gt;
           &lt;file-server operation="all" url="gsiftp://trestles-dm1.sdsc.edu/phase1/USERNAME"/&gt;
       &lt;/directory&gt;
    &lt;/site&gt;

&lt;/sitecatalog&gt;
</pre>
<p>pegasusrc:</p>
<pre class="programlisting">pegasus.catalog.replica=SimpleFile
pegasus.catalog.replica.file=rc

pegasus.catalog.site.file=sites.xml

pegasus.catalog.transformation=Text
pegasus.catalog.transformation.file=tc

pegasus.data.configuration = sharedfs

# Pegasus might not be installed, or be of a different version
# so stage the worker package
pegasus.transfer.worker.package = true
</pre>
<p>The HTC resources available on XSEDE are all HTCondor based, so
    standard <a class="link" href="condor_pool.php" title="7.2. Condor Pool">HTCondor Pool</a> setup will work
    fine.</p>
<p>If you need to run high throughput workloads on the HPC machines
    (for example, post processing after a large parallel job), <a class="link" href="condor_pool.php#glideins" title="7.2.1. Glideins">glideins</a> can be useful as it is a more efficient
    method for small jobs on these systems.</p>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="campus_cluster.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="open_science_grid.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.8. Campus Cluster </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.10. Open Science Grid Using glideinWMS</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
