<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="local_shell_examples.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="workflow_of_workflows.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="notifications_example"></a>8.4. Notifications Example</h2></div></div></div>
<p>A new feature in Pegasus 3.1. is notifications. While the workflow
    is running, a monitoring tool is running side by side to the workflow, and
    issues user defined notifications when certain events takes place, such as
    job completion or failure. See <a class="link" href="notifications.php" title="6.4. Notifications">notifications
    section</a> for detailed information. A workflow example with
    notifications can be found under examples/notifications. This workflow is
    based on the Black Diamond, with the changes being notifications added to
    the DAX generator. For example, notifications are added at the workflow
    level:</p>
<pre class="programlisting"># Create a abstract dag
diamond = ADAG("diamond")
# dax level notifications
diamond.invoke('all', os.getcwd() + "/my-notify.sh")</pre>
<p>The DAX generator also contains job level notifications:</p>
<pre class="programlisting"># job level notifications - in this case for at_end events
frr.invoke('at_end', os.getcwd() + "/my-notify.sh")</pre>
<p>These invoke lines specify that the <span class="command"><strong>my-notify.sh</strong></span>
    script will be invoked for events generated (<span class="bold"><strong>all</strong></span> in the first case, <span class="bold"><strong>at_end</strong></span> in the second). The
    <span class="command"><strong>my-notify.sh</strong></span> script contains callouts sample
    notification tools shipped with Pegasus, one for email and for
    Jabber/GTalk (commented out by default):</p>
<pre class="programlisting">#!/bin/bash

# Pegasus ships with a couple of basic notification tools. Below
# we show how to notify via email and gtalk.

# all notifications will be sent to email
# change $USER to your full email addess
$PEGASUS_HOME/libexec/notification/email -t $USER

# this sends notifications about failed jobs to gtalk.
# note that you can also set which events to trigger on in your DAX.
# set jabberid to your gmail address, and put in yout
# password
# uncomment to enable
if [ "x$PEGASUS_STATUS" != "x" -a "$PEGASUS_STATUS" != "0" ]; then
    $PEGASUS_HOME/libexec/notification/jabber --jabberid FIXME@gmail.com \
                                              --password FIXME \
                                              --host talk.google.com
fi
</pre>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="local_shell_examples.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="example_workflows.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="workflow_of_workflows.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">8.3. Local Shell Examples </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 8.5. Workflow of Workflows</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
