<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-em.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-graphviz.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-exitcode">
<a name="cli-pegasus-exitcode"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-exitcode — Checks the stdout/stderr files of a workflow job for any indication that an error occurred in the job. This script is intended to be invoked automatically by DAGMan as the POST script of a job.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-exitcode_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-exitcode</strong></span> [<span class="strong"><strong>-h</strong></span>][<span class="strong"><strong>-r</strong></span> <span class="emphasis"><em>rv</em></span>][<span class="strong"><strong>-n</strong></span>][<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>msg</em></span>][<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>msg</em></span>] <span class="emphasis"><em>job.out</em></span></p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-exitcode_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-exitcode</strong></span> is a utility that examines the STDOUT of a job to
determine if the job failed, and renames the STDOUT and STDERR files
of a job to preserve them in case the job is retried.</p>
<p>Pegasus uses <span class="strong"><strong>pegasus-exitcode</strong></span> as the DAGMan postscript for jobs
submitted via Globus GRAM. This tool exists as a workaround to a
known problem with Globus and Condor-G where the exitcodes of GRAM
jobs are not returned. This is a problem because Pegasus uses the
exitcode of a job to determine if the job failed or not.</p>
<p>In order to get around the exitcode problem, Pegasus can wrap
GRAM jobs with Kickstart, which records the exitcode of the job
in an XML invocation record, which it writes to the job’s STDOUT.
The STDOUT is transferred from the execution host back to the submit
host when the job terminates. After the job terminates, DAGMan runs
the job’s postscript, which Pegasus sets to be <span class="strong"><strong>pegasus-exitcode</strong></span>.
<span class="strong"><strong>pegasus-exitcode</strong></span> looks at the invocation record generated by
kickstart to see if the job succeeded or failed. If the invocation
record indicates a failure, then <span class="strong"><strong>pegasus-exitcode</strong></span> returns a non-zero
result, which indicates to DAGMan that the job has failed. If the
invocation record indicates that the job succeeded, then <span class="strong"><strong>pegasus-exitcode</strong></span>
returns 0, which tells DAGMan that the job succeeded.</p>
<p>In addition, clustered jobs executed with <span class="strong"><strong>pegasus-cluster</strong></span> or
<span class="strong"><strong>pegasus-mpi-cluster</strong></span> will have a <code class="literal">[cluster-summary]</code> record in their
STDOUT. <span class="strong"><strong>pegasus-exitcode</strong></span> can examine these records to determine if
any of the tasks in the clustered job failed.</p>
<p><span class="strong"><strong>pegasus-exitcode</strong></span> performs several checks (some optional) to determine
whether a job failed or not. These checks include:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
Is the Condor exitcode non-zero? If so, then the job failed.
</li>
<li class="listitem">
Is STDOUT empty? If it is empty, then the job failed.
</li>
<li class="listitem">
Are there any failure messages in the STDOUT or STDERR? If so, the job
failed.
</li>
<li class="listitem">
Are all of the success messages in the STDOUT or STDERR? If not, then
the job failed.
</li>
<li class="listitem">
Does the <code class="literal">[cluster-summary]</code> record indicate that the job was successful.
If not, then the job failed.
</li>
<li class="listitem">
Are there any <code class="literal">&lt;status&gt;</code> tags with a non-zero value? If there are,
then the job failed. Note that, if this is a clustered job, there could
be multiple <code class="literal">&lt;status&gt;</code> tags, one for each task. If any of them are
non-zero, then the job failed.
</li>
<li class="listitem">
Is there at least one <code class="literal">&lt;status&gt;</code> tag with a zero value? There must
be at least one successful invocation or the job has failed.
</li>
</ol></div>
<p>In addition, <span class="strong"><strong>pegasus-exitcode</strong></span> allows the caller to specify the exitcode
returned by Condor using the <span class="strong"><strong>--return</strong></span> argument. This can be passed to
<span class="strong"><strong>pegasus-exitcode</strong></span> in a DAGMan post script by using the <code class="literal">$RETURN</code> variable.
If this value is non-zero, then <span class="strong"><strong>pegasus-exitcode</strong></span> returns a non-zero result
before performing any other checks. For GRAM jobs, the value of <code class="literal">$RETURN</code> will
always be 0 regardless of whether the job failed or not.</p>
<p>In addition to checking the success/failure of a job, <span class="strong"><strong>pegasus-exitcode</strong></span>
also renames the STDOUT and STDERR files of the job so that if the job is
retried, the STDOUT and STDERR of the previous run are not lost. It does
this by appending a sequence number to the end of the files. For example,
if the STDOUT file is called "job.out", then the first time the job is run
<span class="strong"><strong>pegasus-exitcode</strong></span> will rename the file "job.out.000". If the job is run again,
then <span class="strong"><strong>pegasus-exitcode</strong></span> sees that "job.out.000" already exists and renames
the file "job.out.001". It will continue to rename the file by incrementing
the sequence number every time the job is executed.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-exitcode_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span> <span class="emphasis"><em>rv</em></span>
, </span><span class="term">
<span class="strong"><strong>--return</strong></span> <span class="emphasis"><em>rv</em></span>
</span>
</dt>
<dd>
Return value reported by DAGMan. This can be specified in the DAG
using the $RETURN variable. If this is non-zero, then <span class="strong"><strong>pegasus-exitcode</strong></span>
immediately fails with a non-zero return value itself. If it is
zero, then just rotate the file and don’t check for proper kickstart
output. This option can be used in cases where kickstart cannot be used
(such as pegasus-create-dir) to enable file rotation.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-n</strong></span>
, </span><span class="term">
<span class="strong"><strong>--no-rename</strong></span>
</span>
</dt>
<dd>
Don’t rename <span class="emphasis"><em>job.out</em></span> and <span class="emphasis"><em>job.err</em></span> to <span class="emphasis"><em>.out.XXX</em></span> and <span class="emphasis"><em>.err.XXX</em></span>.
This option is used primarily for testing.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>msg</em></span>
, </span><span class="term">
<span class="strong"><strong>--failure-message</strong></span> <span class="emphasis"><em>msg</em></span>
</span>
</dt>
<dd>
Failure message to find in job stdout/stderr. If this message exists in
the stdout/stderr of the job, then the job will be considered a failure
no matter what other output exists. If multiple failure messages are
provided, then none of them can exist in the output or the job is
considered a failure.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>msg</em></span>
, </span><span class="term">
<span class="strong"><strong>--success-message</strong></span> <span class="emphasis"><em>msg</em></span>
</span>
</dt>
<dd>
Success message to find in job stdout/stderr. If this message does not exist
in the stdout/stderr of the job, then the job will be considered a failure
no matter what other output exists. If multiple success messages are
provided, then they must all exist in the output or the job is considered
a failure.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-exitcode_authors"></a><h2>Authors</h2>
<p>Gideon Juve <code class="literal">&lt;juve@usc.edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-em.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-graphviz.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-em </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-graphviz</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
