<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-dagman.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-db-admin.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-dax-validator">
<a name="cli-pegasus-dax-validator"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-dax-validator — determines if a given DAX file is valid.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-dax-validator_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-dax-validator</strong></span> <span class="emphasis"><em>daxfile</em></span> [<span class="emphasis"><em>verbose</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-dax-validator_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-dax-validator</strong></span> is a simple application that determines, if
a given DAX file is valid XML. For this, it parses the file with as many
XML validity checks that the Apache Xerces XML parser framework supports.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-dax-validator_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="emphasis"><em>daxfile</em></span>
</span></dt>
<dd>
The location of the file containing the DAX.
</dd>
<dt><span class="term">
<span class="emphasis"><em>verbose</em></span>
</span></dt>
<dd>
If any kind of second argument was specified, not limited to the string
<span class="emphasis"><em>verbose</em></span>, the verbose output mode is switched on.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Return Value">
<a name="pegasus-dax-validator_return_value"></a><h2>Return Value</h2>
<p>If the DAX was parsed successfully, or only <span class="emphasis"><em>warning’s were issued, the
exit code is 0. Any 'error</em></span> or <span class="emphasis"><em>fatal error</em></span> will result in an exit code
of 1.</p>
<p>Additionally, a summary statistics with counts of warnings, errors, and
fatal errors will be displayed.</p>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-dax-validator_example"></a><h2>Example</h2>
<p>The following shows the parsing of a DAX file that uses the wrong kind
of value for certain enumerations. The output shows the errors with the
respective line number and column number of the input DAX file, so that
one can find and fix them more easily. (The lines in the example were
broken to fit the manpage format.)</p>
<pre class="screen">$ pegasus-dax-validator bd.dax
ERROR in line 14, col 110: cvc-enumeration-valid: Value 'i386' is not
 facet-valid with respect to enumeration '[x86, x86_64, ppc, ppc_64,
 ia64, sparcv7, sparcv9, amd64]'. It must be a value from the
 enumeration.
ERROR in line 14, col 110: cvc-attribute.3: The value 'i386' of
 attribute 'arch' on element 'executable' is not valid with respect to
 its type, 'ArchitectureType'.
ERROR in line 14, col 110: cvc-enumeration-valid: Value 'darwin' is
 not facet-valid with respect to enumeration '[aix, sunos, linux, macosx,
 windows]'. It must be a value from the enumeration.
ERROR in line 14, col 110: cvc-attribute.3: The value 'darwin' of
 attribute 'os' on element 'executable' is not valid with respect to
 its type, 'OSType'.

0 warnings, 4 errors, and 0 fatal errors detected.</pre>
</div>
<div class="refsect1" title="See Also">
<a name="pegasus-dax-validator_see_also"></a><h2>See Also</h2>
<p>Apache Xerces-J <a class="ulink" href="http://xerces.apache.org/xerces2-j/" target="_top">http://xerces.apache.org/xerces2-j/</a></p>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-dax-validator_authors"></a><h2>Authors</h2>
<p>Jens-S. Vöckler <code class="literal">&lt;voeckler at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-dagman.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-db-admin.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-dagman </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-db-admin</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
