<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-plots.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-remove.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-rc-client">
<a name="cli-pegasus-rc-client"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-rc-client — shell client for replica implementations</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-rc-client_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-rc-client</strong></span> [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>[…]] [<span class="strong"><strong>-V</strong></span>]<br>
                  [<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>fn</em></span>] [<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>k=v</em></span>]<br>
                  [[<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>fn</em></span>]|[<span class="strong"><strong>-i</strong></span>|<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>fn</em></span>]|[<span class="emphasis"><em>cmd</em></span> [<span class="emphasis"><em>args</em></span>]]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-rc-client_description"></a><h2>Description</h2>
<p>The shell interface to replica catalog implementations is a prototype.
It determines from various property setting which class implements the
replica manager interface, and loads that driver at run-time. Some
commands depend on the implementation.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-rc-client_options"></a><h2>Options</h2>
<p>Any option will be displayed with its long options synonym(s).</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
The <span class="strong"><strong>-D</strong></span> option allows an experienced user to override certain properties
which influence the program execution, among them the default location of
the user’s properties file and the PEGASUS home location. One may set
several CLI properties by giving this option multiple times. The <span class="strong"><strong>-D</strong></span>
option(s) must be the first option on the command line. A CLI property
take precedence over the properties file property of the same key.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>fn</em></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>fn</em></span>
</span>
</dt>
<dd>
Path to the property file
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>fn</em></span>
, </span><span class="term">
<span class="strong"><strong>--file</strong></span> <span class="emphasis"><em>fn</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The optional input file argument permits to enter non-interactive bulk
mode. If this option is not present, replica manager specific commands
should be issued on the command-line. The special filename hyphen (-)
can be used to read from pipes.
</p>
<p class="simpara">Default is to use an interactive interface reading from <span class="emphasis"><em>stdin</em></span>.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>fn</em></span>
, </span><span class="term">
<span class="strong"><strong>--insert</strong></span> <span class="emphasis"><em>fn</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The optional input file argument permits insertion of entries from the
Replica Catalog in a bulk mode, wherever supported by the underlying
implementation.
</p>
<p class="simpara">Each line in the file denotes one mapping of the format
<span class="strong"><strong>&lt;lfn&gt; &lt;pfn&gt; [k=v [..]]</strong></span></p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>fn</em></span>
, </span><span class="term">
<span class="strong"><strong>--delete</strong></span> <span class="emphasis"><em>fn</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The optional input file argument permits deletion of entries from the
Replica Catalog in a bulk mode, wherever supported by the underlying
implementation.
</p>
<p class="simpara">Each line in the file denotes one mapping of the format:
<span class="strong"><strong>&lt;lfn&gt; &lt;pfn&gt; [k=v [..]]</strong></span></p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>k=v</em></span>
, </span><span class="term">
<span class="strong"><strong>--pref</strong></span> <span class="emphasis"><em>k=v</em></span>
</span>
</dt>
<dd>
<p class="simpara">
This option may be specified multiple times. Each specification
populates instance preferences. Preferences control the extend of log
information, or the output format string to use in listings.
</p>
<p class="simpara">The keys <span class="strong"><strong>format</strong></span> and <span class="strong"><strong>level</strong></span> are recognized as of this writing.</p>
<p class="simpara">There are no defaults.</p>
</dd>
<dt><span class="term">
<span class="emphasis"><em>cmd [args]</em></span>
</span></dt>
<dd>
<p class="simpara">
If not in file-driven mode, a single command can be specified with its
arguments.
</p>
<p class="simpara">Default is to use interactive mode.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
displays the version of Pegasus you are using.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Return Value">
<a name="pegasus-rc-client_return_value"></a><h2>Return Value</h2>
<p>Regular and planned program terminations will result in an exit code of 0.
Abnormal termination will result in a non-zero exit code.</p>
</div>
<div class="refsect1" title="Files">
<a name="pegasus-rc-client_files"></a><h2>Files</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/properties</strong></span>
</span></dt>
<dd>
contains the basic properties with all configurable options.
</dd>
<dt><span class="term">
<span class="strong"><strong>$HOME/.pegasusrc</strong></span>
</span></dt>
<dd>
contains the basic properties with all configurable options.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.jar</strong></span>
</span></dt>
<dd>
contains all compiled Java bytecode to run the replica manager.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Environment Variables">
<a name="pegasus-rc-client_environment_variables"></a><h2>Environment Variables</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>PEGASUS_HOME</strong></span>
</span></dt>
<dd>
is the suggested base directory of your the execution environment.
</dd>
<dt><span class="term">
<span class="strong"><strong>JAVA_HOME</strong></span>
</span></dt>
<dd>
should be set and point to a valid location to start the intended Java
virtual machine as <span class="emphasis"><em>$JAVA_HOME/bin/java</em></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>CLASSPATH</strong></span>
</span></dt>
<dd>
should be set to contain all necessary files for the execution
environment. Please make sure that your <span class="emphasis"><em>CLASSPATH</em></span> includes pointer
to the replica implementation required jar files.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Properties">
<a name="pegasus-rc-client_properties"></a><h2>Properties</h2>
<p>The complete branch of properties <span class="emphasis"><em>pegasus.catalog.replica</em></span>
including itself are interpreted by the prototype. While the
<span class="emphasis"><em>pegasus.catalog.replica</em></span> property itself steers the backend to
connect to, any meaning of branched keys is dependent on the backend.
The same key may have different meanings for different backends.</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica</strong></span>
</span></dt>
<dd>
determines the name of the implementing class to load at run-time. If
the class resides in <span class="emphasis"><em>org.griphyn.common.catalog.replica</em></span> no prefix is
required. Otherwise, the fully qualified class name must be specified.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.file</strong></span>
</span></dt>
<dd>
is used by the SimpleFile implementation. It specifies the path to the
file to use as the backend for the catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.db.driver</strong></span>
</span></dt>
<dd>
is used by a simple rDBMs implementation. The string is the
fully-qualified class name of the JDBC driver used by the RDBMS
implementer.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.db.url</strong></span>
</span></dt>
<dd>
is the JDBC URL to use to connect to the database.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.db.user</strong></span>
</span></dt>
<dd>
is used by a simple rDBMS implementation. It constitutes the database
user account that contains the <span class="emphasis"><em>RC_LFN</em></span> and <span class="emphasis"><em>RC_ATTR</em></span> tables.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.db.password</strong></span>
</span></dt>
<dd>
is used by a simple RDBMS implementation. It constitutes the database
user account that contains the <span class="emphasis"><em>RC_LFN</em></span> and <span class="emphasis"><em>RC_ATTR</em></span> tables.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.chunk.size</strong></span>
</span></dt>
<dd>
is used by <span class="strong"><strong>the pegasus-rc-client</strong></span> for the bulk insert and delete
operations. The value determines the number of lines that are read in
at a time, and worked upon at together.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Commands">
<a name="pegasus-rc-client_commands"></a><h2>Commands</h2>
<p>The command line tool provides a simplified shell-wrappable interface to
manage a replica catalog backend. The commands can either be specified
in a file in bulk mode, in a pipe, or as additional arguments to the
invocation.</p>
<p>Note that you must escape special characters from the shell.</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>help</strong></span>
</span></dt>
<dd>
displays a small resume of the commands.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>exit</strong></span>
, </span><span class="term">
<span class="strong"><strong>quit</strong></span>
</span>
</dt>
<dd>
should only be used in interactive mode to exit the interactive mode.
</dd>
<dt><span class="term">
<span class="strong"><strong>clear</strong></span>
</span></dt>
<dd>
drops all contents from the backend. Use with special care!
</dd>
<dt><span class="term">
<span class="strong"><strong>insert &lt;lfn&gt; &lt;pfn&gt; [k=v […]]</strong></span>
</span></dt>
<dd>
inserts a given <span class="strong"><strong>lfn</strong></span> and <span class="strong"><strong>pfn</strong></span>, and an optional  <span class="strong"><strong>site</strong></span> string into
the backend. If the site is not specified, a <span class="emphasis"><em>null</em></span> value is inserted
for the <span class="strong"><strong>site</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>delete &lt;lfn&gt; &lt;pfn&gt; [k=v […]]</strong></span>
</span></dt>
<dd>
removes a triple of <span class="strong"><strong>lfn</strong></span>, <span class="strong"><strong>pfn</strong></span> and, optionally, <span class="strong"><strong>site</strong></span> from the replica
backend. If the site was not specified, all matches of the <span class="strong"><strong>lfn</strong></span> <span class="strong"><strong>pfn</strong></span>
pairs will be removed, regardless of the <span class="strong"><strong>site</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>lookup &lt;lfn&gt; [&lt;lfn&gt; […]]</strong></span>
</span></dt>
<dd>
retrieves one or more mappings for a given <span class="strong"><strong>lfn</strong></span> from the replica backend.
</dd>
<dt><span class="term">
<span class="strong"><strong>remove &lt;lfn&gt; [&lt;lfn&gt; […]]</strong></span>
</span></dt>
<dd>
removes all mappings for each <span class="strong"><strong>lfn</strong></span> from the replica backend.
</dd>
<dt><span class="term">
<span class="strong"><strong>list [lfn &lt;pat&gt;] [pfn &lt;pat&gt;] [&lt;name&gt; &lt;pat&gt;]</strong></span>
</span></dt>
<dd>
obtains all matches from the replica backend. If no arguments were
specified, all contents of the replica backend are matched. You must use
the word <span class="strong"><strong>lfn</strong></span>, <span class="strong"><strong>pfn</strong></span> or <span class="strong"><strong>&lt;name&gt;</strong></span> before specifying a pattern. The pattern
is meaningful only to the implementation. Thus, a SQL implementation may
chose to permit SQL wild-card characters. A memory-resident service may
chose to interpret the pattern as regular expression.
</dd>
<dt><span class="term">
<span class="strong"><strong>set [var [value]]</strong></span>
</span></dt>
<dd>
sets an internal variable that controls the behavior of the front-end.
With no arguments, all possible behaviors are displayed. With one
argument, just the matching behavior is listed. With two arguments, the
matching behavior is set to the value.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Database Schema">
<a name="pegasus-rc-client_database_schema"></a><h2>Database Schema</h2>
<p>The tables are set up as part of the PEGASUS database setup. The files
concerned with the database have a suffix <span class="emphasis"><em>-rc.sql</em></span>.</p>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-rc-client_authors"></a><h2>Authors</h2>
<p>Karan Vahi <code class="literal">&lt;vahi at isi dot edu&gt;</code></p>
<p>Gaurang Mehta <code class="literal">&lt;gmetha at isi dot edu&gt;</code></p>
<p>Jens-S. Vöckler <code class="literal">&lt;voeckler at isi dot dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-plots.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-remove.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-plots </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-remove</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
