<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-dax-validator.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-em.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry">
<a name="cli-pegasus-db-admin"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-db-admin — Manage Pegasus databases.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-db-admin_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-db-admin</strong></span> <span class="emphasis"><em>COMMAND</em></span> [options] [DATABASE_URL]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-db-admin</strong></span> is used to manage Pegasus databases. The tool can operate
directly over a database URL, or can read configuration parameters from the
properties file or a submit directory. In the later case, a database type
should be provided to indicate which properties should be used to connect to
the database. For example, the tool will seek for pegasus.catalog.replica.db.*
properties to connect to the JDBCRC database; or seek for pegasus.catalog.master.url
(or pegasus.dashboard.output, which is deprecated) property to connect to the
MASTER database; or seek for the pegasus.catalog.workflow.url (or pegasus.monitord.output,
which is deprecated) property to connect to the WORKFLOW database. If none of
these properties are found, the tool will connect to the default database</p>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_commands"></a><h2>Commands</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>create</strong></span>
</span></dt>
<dd>
    Creates Pegasus databases from new or empty databases, or updates current
    database to the latest version. If a database already exists, it will
    create a backup (SQLite only) of the current database in the database folder
    as a 3-digit integer (e.g., workflow.db.000). Pegasus databases can be
    created by 1) passing a database URL, 2) from the properties file, and 3) from
    the submit directory. Note that if the properties file or the submit
    directory is used, a database type (JDBCRC, MASTER, or WORKFLOW) should be
    provided.
</dd>
<dt><span class="term">
<span class="strong"><strong>update</strong></span>
</span></dt>
<dd>
    Updates the database to the latest or a given Pegasus version provided with
    the <span class="strong"><strong>-V</strong></span> or <span class="strong"><strong>--version</strong></span> option. If a database already exists, it will
    create a backup (SQLite only) of the current database in the database folder
    as a 3-digit integer (e.g., workflow.db.000).
</dd>
<dt><span class="term">
<span class="strong"><strong>check</strong></span>
</span></dt>
<dd>
    Verifies if the database is updated to the latest or a given Pegasus version
    provided with the <span class="strong"><strong>-V</strong></span> or <span class="strong"><strong>--version</strong></span> option.
</dd>
<dt><span class="term">
<span class="strong"><strong>version</strong></span>
</span></dt>
<dd>
    Prints the current version of the database.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_global_options"></a><h2>Global Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span>
</span>
</dt>
<dd>
Specifies the properties file. This overrides all other property files. Should
be used with <span class="emphasis"><em>-t</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span>
, </span><span class="term">
<span class="strong"><strong>--submitdir</strong></span>
</span>
</dt>
<dd>
Specifies the submit directory. Should be used with <span class="emphasis"><em>-t</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span>
, </span><span class="term">
<span class="strong"><strong>--type</strong></span>
</span>
</dt>
<dd>
Type of the database (JDBCRC, MASTER, or WORKFLOW). Should be used with <span class="emphasis"><em>-c</em></span>
or <span class="emphasis"><em>-s</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span>
</span>
</dt>
<dd>
Enables debugging.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_examples"></a><h2>Examples</h2>
<pre class="screen"># Create a database by passing a database URL.
$ pegasus-db-admin create sqlite:///${HOME}/.pegasus/workflow.db
$ pegasus-db-admin create mysql://localhost:3306/pegasus

# Create a database from the properties file. Note that a database
# type should be provided.
$ pegasus-db-admin create -c pegasus.properties -t MASTER
$ pegasus-db-admin create -c pegasus.properties -t JDBCRC
$ pegasus-db-admin create -c pegasus.properties -t WORKFLOW

# Create a database from the submit directory. Note that a database
# type should be provided.
$ pegasus-db-admin update -s /path/to/submitdir -t WORKFLOW
$ pegasus-db-admin update -s /path/to/submitdir -t MASTER
$ pegasus-db-admin update -s /path/to/submitdir -t JDBCRC

# Update the database schema by passing a database URL.
$ pegasus-db-admin update sqlite:///${HOME}/.pegasus/workflow.db
$ pegasus-db-admin update mysql://localhost:3306/pegasus

# Update the database schema from the properties file. Note that a
# database type should be provided.
$ pegasus-db-admin update -c pegasus.properties -t MASTER
$ pegasus-db-admin update -c pegasus.properties -t JDBCRC
$ pegasus-db-admin update -c pegasus.properties -t WORKFLOW

# Update the database schema from the submit directory. Note that a
# database type should be provided.
$ pegasus-db-admin update -s /path/to/submitdir -t WORKFLOW
$ pegasus-db-admin update -s /path/to/submitdir -t MASTER
$ pegasus-db-admin update -s /path/to/submitdir -t JDBCRC</pre>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_authors"></a><h2>Authors</h2>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-dax-validator.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-em.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-dax-validator </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-em</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
