#!/bin/sh

# This file is compatible with Pegasus 4.4.0 or later.
# this file goes to the bin directory in the directory
# pointed to by
# condor_config_val GLITE_LOCATION
#
# e.g
#  [vahi@ccg-testing2 run0007]$ condor_config_val  GLITE_LOCATION
#  /usr/libexec/condor/glite
#
#  [vahi@ccg-testing2 run0007]$ ls -lh /usr/libexec/condor/glite/
#
# [vahi@ccg-testing2 run0007]$ ls -lh /usr/libexec/condor/glite/bin/pbs_local_submit_attributes.sh
# -rwxr-xr-x 1 root root 112 Feb  7 17:24 /usr/libexec/condor/glite/bin/pbs_local_submit_attributes.sh
# [vahi@ccg-testing2 run0007]$
#
#

strip_quotes() {
    # purpose: strip quotes from a variable value
    # paramtr: $str: the variable that needs to be stripped of quotes
    #         
    #         
    # returns: stripped out value
    local str=$1
    value=`echo "$str" | sed 's/"//g'`
    echo $value
}



pbs_nodes=""

if [ "X${NODES}" != "X" ]; then
    pbs_nodes="#PBS -l nodes=${NODES}"
fi

if [ "X${PROCS}" != "X" ]; then
    pbs_nodes="${pbs_nodes}:ppn=${PROCS}"
fi

# strip any quotes . e.g 16:IB condor expects it to be quoted
# however pbs does not like it
pbs_nodes=`echo $pbs_nodes | sed 's/"//g'`
echo $pbs_nodes

if [ "X${WALLTIME}" != "X" ]; then
    # strip any quotes . e.g 16:IB condor expects it to be quoted
    # however pbs does not like it
    walltime=`strip_quotes $WALLTIME`
    echo "#PBS -l walltime=${walltime}"
fi

if [ "X${PER_PROCESS_MEMORY}" != "X" ]; then
    # strip any quotes . e.g 1gb condor expects it to be quoted
    # however pbs does not like it
    value=`strip_quotes $PER_PROCESS_MEMORY`
    echo "#PBS -l pmem=${value}"
fi

if [ "X${$TOTAL_MEMORY}" != "X" ]; then
    # strip any quotes . e.g 1gb condor expects it to be quoted
    # however pbs does not like it
    value=`strip_quotes $TOTAL_MEMORY`
    echo "#PBS -l mem=${value}"
fi

if [ "X${PROJECT}" != "X" ]; then
    echo "#PBS -A ${PROJECT}"
fi

if [ "X${JOBNAME}" != "X" ]; then
    echo "#PBS -N ${JOBNAME}"
fi

if [ "X${PASSENV}" != "X" ]  && [ $PASSENV == 1 ]; then
    echo "#PBS -V"
fi

# +remote_cerequirements = .. MYENV=="A=\"XY Z\",B=LMN"
# The temp ce-req-file generated by condor writes it as -> MYENV='"A=XY Z,B=LMN"'
# NEWENV value strips out the first and last double-quote so the value written in the generated PBS file is
if [ "X${MYENV}" != "X" ] ; then
    eval "NEWENV=$MYENV"
    echo "#PBS -v ${NEWENV}"
fi

# echo "# DEBUG $EXTRA_ARGUMENTS"
# if a user passed any extra arguments set them in the end                                                                                                                                                                                   
# for example "-N testjob -l walltime=01:23:45 -l nodes=2"
if [  "X${EXTRA_ARGUMENTS}" != "X"  ] ; then
    value=`strip_quotes "$EXTRA_ARGUMENTS"`
    echo "#PBS ${value}"
fi

# additional things added to use the reservation for the tutorial
# qsub -I -l advres=PegasusWorkshop.897 -A workshop -l 'nodes=1:ppn=8' -l 'walltime=hh:mm:ss'
#echo "#PBS -l advres=TestPegasusWorkshop.898"
#echo "#PBS -l advres=PegasusWorkshop.899"
#echo "#PBS -A workshop"

