<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cred_staging.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="data_cleanup.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="ref_output_mapper"></a>9.4. Output Mappers</h2></div></div></div>
<p>Starting 4.3 release, Pegasus has support for output mappers, that
    allow users fine grained control over how the output files on the output
    site are laid out. By default, Pegasus stages output products to the
    storage directory specified in the site catalog for the output site.
    Output mappers allow users finer grained control over where the output
    files are placed on the output site. </p>
<p>To configure the output mapper, you need to specify the following
    property</p>
<pre class="programlisting">pegasus.dir.storage.mapper  &lt;name of the mapper to use&gt;</pre>
<p>The following mappers are supported currently</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>Flat</strong></span> : By default, Pegasus will
        place the output files in the storage directory specified in the site
        catalog for the output site.</p></li>
<li class="listitem">
<p><span class="bold"><strong>Fixed</strong></span> : This mapper allows
        users to specify an externally accesible url to the storage directory
        in their properties file. To use this mapper, the following property
        needs to be set.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p>pegasus.dir.storage.mapper.fixed.url an externally
            accessible URL to the storage directory on the output site e.g.
            gsiftp://outputs.isi.edu/shared/outputs</p></li></ul></div>
<p>Note: For hierarchal workflows, the above property needs to be
        set separately for each dax job, if you want the sub workflow outputs
        to goto a different directory.</p>
</li>
<li class="listitem"><p><span class="bold"><strong>Hashed</strong></span> : This mapper results in
        the creation of a deep directory structure on the output site, while
        populating the results. The base directory on the remote end is
        determined from the site catalog. Depending on the number of files
        being staged to the remote site a Hashed File Structure is created
        that ensures that only 256 files reside in one directory. To create
        this directory structure on the storage site, Pegasus relies on the
        directory creation feature of the underlying file servers such as
        theGrid FTP server, which appeared in globus 4.0.x</p></li>
<li class="listitem">
<p><span class="bold"><strong>Replica:</strong></span> This mapper determines
        the path for an output file on the output site by querying an output
        replica catalog. The output site is one that is passed on the command
        line. The output replica catalog can be configured by specifying the
        following properties. </p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>pegasus.dir.storage.mapper.replica Regex|File</p></li>
<li class="listitem"><p>pegasus.dir.storage.mapper.replica.file the RC file at the
            backend to use</p></li>
</ul></div>
<p>Please note that the output replica catalog ( even though the
        formats are the same) is logically different from the input replica
        catalog, where you specify the locations for the input files. You
        cannot specify the locations for the output files to be used by the
        mapper in the DAX. The format for the File based replica catalog is
        described <a class="link" href="replica.php#rc-FILE" title="4.2.1. File">here</a>, while for the Regex it
        is <a class="link" href="replica.php#rc-regex" title="4.2.2. Regex">here</a>.</p>
</li>
</ol></div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cred_staging.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="data_management.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="data_cleanup.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">9.3. Credentials Management </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 9.5. Data Cleanup</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
