#!/bin/sh

# This file is compatible with Pegasus 4.5.0 or later.
# this file goes to the bin directory in the directory
# pointed to by
# condor_config_val GLITE_LOCATION
#
# e.g
#  [vahi@ccg-testing2 run0007]$ condor_config_val  GLITE_LOCATION
#  /usr/libexec/condor/glite
#
#  [vahi@ccg-testing2 run0007]$ ls -lh /usr/libexec/condor/glite/
#
# [vahi@ccg-testing2 run0007]$ ls -lh /usr/libexec/condor/glite/bin/sge_local_submit_attributes.sh
#
#

strip_quotes() {
    # purpose: strip quotes from a variable value
    # paramtr: $str: the variable that needs to be stripped of quotes
    #         
    #         
    # returns: stripped out value
    local str=$1
    value=`echo "$str" | sed 's/"//g'`
    echo $value
}

echo "#"
echo "# Start of segment generated by sge_local_submit_attributes.sh"
echo "#"

# Define parallel environment (ompi) and the number of CPUs, for example 4 
#$ -pe ompi 4
# users may need to change parallel environment while
# configuring condor for SGE
sge_pe=" #$ -pe ompi"

#if [ "X${NODES}" != "X" ]; then
#    sge_pe="#PBS -l nodes=${NODES}"
#fi

#echo "#PROCS ARE ${PROCS}"
#echo "#WALLTIME IS ${WALLTIME}" 

if [ "X${CORES}" != "X" ]; then
    cores=`strip_quotes ${CORES}`
    sge_pe="${sge_pe} ${cores}"
    echo $sge_pe
fi

if [ "X${JOBNAME}" != "X" ];then
    ### set the name
    jobname=`strip_quotes ${JOBNAME}`
    echo "#$ -N $jobname"
fi


if [ "X${WALLTIME}" != "X" ]; then
    # strip any quotes . e.g  hh:mm:ss condor expects it to be quoted
    # however SGE does not like it
    walltime=`strip_quotes $WALLTIME`
    echo "#$ -l h_rt=${walltime}"
fi

if [ "X${PER_PROCESS_MEMORY}" != "X" ]; then
    # strip any quotes . e.g 1gb condor expects it to be quoted
    # however SGE does not like it
    # l h_vmem=size --- specify the amount of memory required (e.g. 3G or 3500M) 
    # (NOTE: This is memory per processor slot. So if you ask for 2 processors total memory will be 2 X hvmem_value)
    #  hard limit of the maximum amount of virtual memory available on every host assigned to the job.
    value=`strip_quotes $PER_PROCESS_MEMORY`
    echo "#$ -l h_vmem=${value}"
fi

#if [ "X${$TOTAL_MEMORY}" != "X" ]; then
#    # strip any quotes . e.g 1gb condor expects it to be quoted
#    # however pbs does not like it
#    value=`strip_quotes $TOTAL_MEMORY`
#    echo "#PBS -l mem=${value}"
#fi



# echo "# DEBUG $EXTRA_ARGUMENTS"
# if a user passed any extra arguments set them in the end                                                                                                                                                                                   
# for example " -l walltime=01:23:45 -l nodes=2"
if [  "X${EXTRA_ARGUMENTS}" != "X"  ] ; then
    value=`strip_quotes "$EXTRA_ARGUMENTS"`
    echo "#$ ${value}"
fi

echo "#"
echo "# End of segment generated by sge_local_submit_attributes.sh"
echo "#"
