<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-metadata");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-metadata</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-metadata"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-metadata — Query metadata collected for Pegasus workflows</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-metadata_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-metadata</strong></span> <span class="emphasis"><em>COMMAND</em></span> [options] &lt;SUBMIT_DIR&gt;</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-metadata</strong></span> is a tool to query metadata collected for a
workflow. The tools can query workflow, task, and file metadata.</p>
</div>
<div class="refsect1">
<a name="pegasus-metadata_commands"></a><h2>Commands</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>workflow</strong></span>
</span></dt>
<dd>
    Query metadata for a workflow
</dd>
<dt><span class="term">
<span class="strong"><strong>task</strong></span>
</span></dt>
<dd>
    Query metadata for a workflow task
</dd>
<dt><span class="term">
<span class="strong"><strong>file</strong></span>
</span></dt>
<dd>
    Query metadata for files
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_global_options"></a><h2>Global Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Increase logging verbosity
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_workflow_options"></a><h2>Workflow Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span>
, </span><span class="term">
<span class="strong"><strong>--recursive</strong></span>
</span>
</dt>
<dd>
    Query workflow metadata for the entire workflow; including sub-workflows
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_task_options"></a><h2>Task Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>ABS_TASK_ID</em></span>
, </span><span class="term">
<span class="strong"><strong>--task-id</strong></span> <span class="emphasis"><em>ABS_TASK_ID</em></span>
</span>
</dt>
<dd>
    Specifies the absolute task id whose metadata should be queried.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_file_options"></a><h2>File Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-l</strong></span>
, </span><span class="term">
<span class="strong"><strong>--list</strong></span>
</span>
</dt>
<dd>
    Queries metadata for all files
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-n</strong></span> <span class="emphasis"><em>FILE_NAME</em></span>
, </span><span class="term">
<span class="strong"><strong>--file-name</strong></span> <span class="emphasis"><em>FILE_NAME</em></span>
</span>
</dt>
<dd>
    Specifies name of the file whose metadata should be queried.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span>
, </span><span class="term">
<span class="strong"><strong>--trace</strong></span>
</span>
</dt>
<dd>
    Queries metadata for  the file, the task that generated the file, the workflow which contains the task, and the
    root workflow which contains the task.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-metadata_examples"></a><h2>Examples</h2>
<pre class="screen"># Query metadata for a workflow
$ pegasus-metadata workflow /path/to/submit-dir

# Query metadata for all workflows i.e. including sub-workflows
$ pegasus-metadata workflow --recursive /path/to/submit-dir

# Query task metadata for a given task
$ pegasus-metadata task --task-id ID0000001 /path/to/submit-dir

# Query metadata for all files
$ pegasus-metadata file --list /path/to/submit-dir

# Query metadata for a given file
$ pegasus-metadata file --file-name f.a /path/to/submit-dir

# Trace entire metadata for a given file
$ pegasus-metadata file --file-name f.a --trace /path/to/submit-dir</pre>
</div>
<div class="refsect1">
<a name="pegasus-metadata_authors"></a><h2>Authors</h2>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-kickstart.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-monitord.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-kickstart </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-monitord</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
