<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("9.3. Container Examples");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="example_workflows.php">Example Workflows</a></span> &gt; <span class="breadcrumb-node">Container Examples</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="container_examples"></a>9.3. Container Examples</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="container_examples.php#example_containers_montage">9.3.1. Montage Using Containers</a></span></dt></dl></div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="example_containers_montage"></a>9.3.1. Montage Using Containers</h3></div></div></div>
<p>This section contains an example of a real workflow running inside
    Singularity containers. The application is
    <a class="ulink" href="http://montage.ipac.caltech.edu/" target="_top">Montage</a>
    using the
    <a class="ulink" href="https://github.com/pegasus-isi/montage-workflow-v2" target="_top">montage-v2 workflow</a>.
    Be aware that this workflow can be fairly data intensive, and when running with
    containers in <span class="emphasis"><em>condorio</em></span> or <span class="emphasis"><em>nonsharedfs</em></span>
    data management modes, the data staging of the application data and the container
    image to each job can result in a non-trivial amount of network traffic. 
    </p>
<p>
    The software dependencies consists of the <span class="emphasis"><em>Montage</em></span>
    software stack, and <span class="emphasis"><em>AstroPy</em></span>. These are installed into the
    image (see the <span class="emphasis"><em>Singularity</em></span> file in the GitHub repository).
    The image has been made available in
    <a class="ulink" href="https://singularity-hub.org/" target="_top">Singularity Hub</a>.
    </p>
<p>Now that we have an image, the next step is to check out the
    workflow from GitHub, and use it to create an abstract workflow description,
    a transformation catalog and a replica catalog. The 
    <span class="emphasis"><em>montage-workflow.py</em></span> command create all this for us, but
    the command itself requires Montage to look up input data for the specified
    location in the sky. The provide the environment, run this command inside the
    same Singularity image. For example:
    </p>
<pre class="programlisting">
singularity exec \
            --bind $PWD:/srv --workdir /srv \
            shub://pegasus-isi/montage-workflow-v2 \
            /srv/montage-workflow.py \
                --tc-target container \
                --center "56.7 24.00" \
                --degrees 2.0 \
                --band dss:DSS2B:blue \
                --band dss:DSS2R:green \
                --band dss:DSS2IR:red
    </pre>
<p>The command executes a data find for the 3 specified bands, 2.0 degrees around
    the location 56.7 24.00, and generates a workflow to combine the images into a single
    image. One extra flag is provided to let the command know we want to execute the workflow
    inside containers: <span class="emphasis"><em>--tc-target container</em></span>. The result is a 
    transformation catalog in <span class="emphasis"><em>data/tc.txt</em></span></p>, with starts with:
    
    <pre class="programlisting">
cont montage {
   type "singularity"
   image "shub://pegasus-isi/montage-workflow-v2"
   profile env "MONTAGE_HOME" "/opt/Montage"
}

tr mDiffFit {
  site condor_pool {
    type "INSTALLED"
    container "montage"
    pfn "file:///opt/Montage/bin/mDiffFit"
    profile pegasus "clusters.size" "5"
  }
}
... 
    </pre>
<p>The first entry describes the container, where the image can be found
    (Singularity Hub in this example), and
    a special environment variable we want to be set for the jobs.</p>
<p>The second entry, of which there are many more similar ones in the file,
    describes the application. Note how it refers back to the
    <span class="emphasis"><em>"montage"</em></span> container, specifying that we want the job
    to be wrapped in the container.</p>
<p>In the <span class="emphasis"><em>data/</em></span> directory. we can also find the
    abstract workflow (<span class="emphasis"><em>montage.dax</em></span>), and replica catalog
    (<span class="emphasis"><em>rc.dax</em></span>). Note that this are the same as if the
    workflow was running in a non-container environment. To plan the workflow:
    </p>
<pre class="programlisting">
pegasus-plan \
        --dir work \
        --relative-dir `date +'%s'` \
        --dax data/montage.dax \
        --sites condor_pool \
        --output-site local \
        --cluster horizontal 
    </pre>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="condor_examples.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="example_workflows.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="local_shell_examples.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">9.2. Condor Examples </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 9.4. Local Shell Examples</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
