<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("7.8. SDSC Comet with BOSCO glideins");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="execution_environments.php">Execution Environments</a></span> &gt; <span class="breadcrumb-node">SDSC Comet with BOSCO glideins</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="bosco_sdsc"></a>7.8. SDSC Comet with BOSCO glideins</h2></div></div></div>
<p>BOSCO documentation: <a class="ulink" href="https://twiki.opensciencegrid.org/bin/view/CampusGrids/BoSCO" target="_top">https://twiki.opensciencegrid.org/bin/view/CampusGrids/BoSCO</a></p>
<p>BOSCO is part of the HTCondor system which allows you to set up a
    personal pool of resources brought in from a remote cluster. In this
    section, we describe how to use BOSCO to run glideins (pilot jobs)
    dynamically on the SDSC Comet cluster. The glideins are submitted based on
    the demand of the user jobs in the pool.</p>
<p>As your regular user, on the host you want to use as a workflow
    submit host, download the latest version of HTCondor from the <a class="ulink" href="https://research.cs.wisc.edu/htcondor/downloads/&gt;" target="_top">HTCondor
    Download page</a>. At this point the latest version was 8.5.2 and we
    downloaded condor-8.5.2-x86_64_RedHat6-stripped.tar.gz. Untar, and run the
    installer:</p>
<pre class="programlisting">
$ tar xzf condor-8.5.2-x86_64_RedHat6-stripped.tar.gz
$ cd condor-8.5.2-x86_64_RedHat6-stripped
$ ./bosco_install
...
Created a script you can source to setup your Condor environment
variables. This command must be run each time you log in or may
be placed in your login scripts:
   source /home/$USER/bosco/bosco_setenv
    </pre>
<p>Source the setup file as instructed, run
    <span class="emphasis"><em>bosco_start</em></span>, and then test that
    <span class="emphasis"><em>condor_q</em></span> and <span class="emphasis"><em>condor_status</em></span>
    works.</p>
<pre class="programlisting">
$ source /home/$USER/bosco/bosco_setenv
$ condor_q

-- Schedd: workflow.iu.xsede.org : 127.0.0.1:11000?...
 ID      OWNER            SUBMITTED     RUN_TIME ST PRI SIZE CMD

0 jobs; 0 completed, 0 removed, 0 idle, 0 running, 0 held, 0 suspended
$ condor_status
    </pre>
<p>Let's tell BOSCO about our SDSC Comet account:</p>
<pre class="programlisting">
$ bosco_cluster -a YOUR_SDSC_USERNAME@comet-ln2.sdsc.edu pbs
    </pre>
<p>BOSCO needs a little bit more information to be able to submit the
    glideins to Comet. Log in to your Comet account via ssh (important - this
    step has to take place on Comet) and create the
    <span class="emphasis"><em>~/bosco/glite/bin/pbs_local_submit_attributes.sh</em></span> file
    with the following content. You can find your allocation by running
    <span class="emphasis"><em>show_accounts</em></span> and looking at the project
    column.</p>
<pre class="programlisting">
echo "#PBS -q compute"
echo "#PBS -l nodes=1:ppn=24"
echo "#PBS -l walltime=24:00:00"
echo "#PBS -A [YOUR_COMET_ALLOCATION]"
    </pre>
<p>Also chmod the file:</p>
<pre class="programlisting">
$ chmod 755 ~/bosco/glite/bin/pbs_local_submit_attributes.sh
    </pre>
<p>Log out of Comet, and get back into the host and user BOSCO was
    installed into. We also need to edit a few files on that host.
    <span class="emphasis"><em>~/bosco/libexec/campus_factory/share/glidein_jobs/glidein_wrapper.sh</em></span>
    has a bug in some versions of HTCondor. Open up the file and make sure the
    eval line in the beginning is below the unset/export HOME section. If that
    is not the case, edit the file to look like:</p>
<pre class="programlisting">
#!/bin/sh 

starting_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &amp;&amp; pwd )"

# BLAHP does weird things with home directory
unset HOME
export HOME

eval campus_factory_dir=$_campusfactory_CAMPUSFACTORY_LOCATION
    </pre>
<p>If the order of the HOME and eval statements are reversed in your
    file, change them to look like the above. At the end of
    <span class="emphasis"><em>~/bosco/libexec/campus_factory/share/glidein_jobs/glidein_condor_config</em></span>
    add:</p>
<pre class="programlisting">
# dynamic slots
SLOT_TYPE_1 = cpus=100%,disk=100%,swap=100%
SLOT_TYPE_1_PARTITIONABLE = TRUE
NUM_SLOTS = 1
NUM_SLOTS_TYPE_1 = 1
    </pre>
<p>In the file
    <span class="emphasis"><em>~/bosco/libexec/campus_factory/share/glidein_jobs/job.submit.template</em></span>
    find the line reading:</p>
<pre class="programlisting">
         _condor_NUM_CPUS=1; \
    </pre>
<p>You should now have a functioning BOSCO setup. Submit a Pegasus
    workflow.</p>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="glite.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="bosco.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.7. Local PBS Cluster Using Glite </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.9. Remote PBS Cluster using BOSCO and SSH</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
