<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-analyzer");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-analyzer</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-analyzer"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-analyzer — debugs a workflow.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-analyzer_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-analyzer</strong></span> [<span class="strong"><strong>--help</strong></span>|<span class="strong"><strong>-h</strong></span>] [<span class="strong"><strong>--quiet</strong></span>|<span class="strong"><strong>-q</strong></span>] [<span class="strong"><strong>--strict</strong></span>|<span class="strong"><strong>-s</strong></span>]<br>
                 [<span class="strong"><strong>--monitord</strong></span>|<span class="strong"><strong>-m</strong></span>|<span class="strong"><strong>-t</strong></span>] [<span class="strong"><strong>--verbose</strong></span>|<span class="strong"><strong>-v</strong></span>]<br>
                 [<span class="strong"><strong>--output-dir</strong></span>|<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>output_dir</em></span>]<br>
                 [<span class="strong"><strong>--dag</strong></span> <span class="emphasis"><em>dag_filename</em></span>] [<span class="strong"><strong>--dir</strong></span>|<span class="strong"><strong>-d</strong></span>|<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>input_dir</em></span>]<br>
                 [<span class="strong"><strong>--print</strong></span>|<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>print_options</em></span>] [<span class="strong"><strong>--type</strong></span> <span class="emphasis"><em>workflow_type</em></span>]<br>
                 [<span class="strong"><strong>--debug-job</strong></span> <span class="emphasis"><em>job</em></span>][<span class="strong"><strong>--debug-dir</strong></span> <span class="emphasis"><em>debug_dir</em></span>]<br>
                 [<span class="strong"><strong>--local-executable</strong></span> <span class="emphasis"><em>local user executable</em></span>]<br>
                 [<span class="strong"><strong>--conf</strong></span>|<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>property_file</em></span>] [<span class="strong"><strong>--files</strong></span>]<br>
                 [<span class="strong"><strong>--top-dir</strong></span> <span class="emphasis"><em>dir_name</em></span>] [<span class="strong"><strong>--recurse</strong></span>|<span class="strong"><strong>-r</strong></span>]<br>
                 [<span class="emphasis"><em>workflow_directory</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-analyzer</strong></span> is a command-line utility for parsing the
<span class="emphasis"><em>jobstate.log</em></span> file and reporting successful and failed jobs. When
executed without any options, it will query the <span class="strong"><strong>SQLite</strong></span> or <span class="strong"><strong>MySQL</strong></span>
database and retrieve failed job information for the particular
workflow. When invoked with the <span class="strong"><strong>--files</strong></span> option, it will retrieve
information from several log files, isolating jobs that did not
complete successfully, and printing their <span class="emphasis"><em>stdout</em></span> and <span class="emphasis"><em>stderr</em></span> so
that users can get detailed information about their workflow runs.</p>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_options"></a><h2>Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
Only print the the output and error filenames instead of their contents.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span>
, </span><span class="term">
<span class="strong"><strong>--strict</strong></span>
</span>
</dt>
<dd>
Get jobs' output and error filenames from the job’s submit file.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span>
, </span><span class="term">
<span class="strong"><strong>-t</strong></span>
, </span><span class="term">
<span class="strong"><strong>--monitord</strong></span>
</span>
</dt>
<dd>
Invoke <span class="strong"><strong>pegasus-monitord</strong></span> before analyzing the <span class="emphasis"><em>jobstate.log</em></span> file. Although
<span class="strong"><strong>pegasus-analyzer</strong></span> can be executed during the workflow execution as well as
after the workflow has already completed execution, <span class="strong"><strong>pegasus-monitord"</strong></span>
is always invoked with the <span class="strong"><strong>--replay</strong></span> option. Since multiple instances of
<span class="strong"><strong>pegasus-monitord"</strong></span> should not be executed simultaneously in the same
workflow directory, the user should ensure that no other instances of
<span class="strong"><strong>pegasus-monitord</strong></span> are running. If the <span class="emphasis"><em>run_directory</em></span> is writable,
<span class="strong"><strong>pegasus-analyzer</strong></span> will create a <span class="emphasis"><em>jobstate.log</em></span> file there, rotating an
older log, if it is found. If the <span class="emphasis"><em>run_directory</em></span> is not writable (e.g.
when the user debugging the workflow is not the same user that ran the
workflow), <span class="strong"><strong>pegasus-analyzer</strong></span> will exit and ask the user to provide the
<span class="strong"><strong>--output-dir</strong></span> option, in order to provide an alternative location for
<span class="strong"><strong>pegasus-monitord</strong></span> log files.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Sets the log level for <span class="strong"><strong>pegasus-analyzer</strong></span>. If omitted, the default
<span class="emphasis"><em>level</em></span> will be set to <span class="emphasis"><em>WARNING</em></span>. When this option is given, the log
level is changed to <span class="emphasis"><em>INFO</em></span>. If this option is repeated, the log level
will be changed to <span class="emphasis"><em>DEBUG</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>output_dir</em></span>
, </span><span class="term">
<span class="strong"><strong>--output-dir</strong></span> <span class="emphasis"><em>output_dir</em></span>
</span>
</dt>
<dd>
This option provides an alternative location for all monitoring log files
for a particular workflow. It is mainly used when an user does not have
write privileges to a workflow directory and needs to generate the log
files needed by <span class="strong"><strong>pegasus-analyzer</strong></span>. If this option is used in conjunction
with the <span class="strong"><strong>--monitord</strong></span> option, it will invoke <span class="strong"><strong>pegasus-monitord</strong></span> using
<span class="emphasis"><em>output_dir</em></span> to store all output files. Because workflows can have
sub-workflows, <span class="strong"><strong>pegasus-monitord</strong></span> will create its files prepending the
workflow <span class="emphasis"><em>wf_uuid</em></span> to each filename. This way, multiple workflow files
can be stored in the same directory. <span class="strong"><strong>pegasus-analyzer</strong></span> has built-in
logic to find the specific <span class="emphasis"><em>jobstate.log</em></span> file by looking at the workflow
<span class="emphasis"><em>braindump.txt</em></span> file first and figuring out the corresponding <span class="emphasis"><em>wf_uuid.</em></span>
If <span class="emphasis"><em>output_dir</em></span> does not exist, it will be created.
</dd>
<dt><span class="term">
<span class="strong"><strong>--dag</strong></span> 'dag_filename
</span></dt>
<dd>
In this option, <span class="emphasis"><em>dag_filename</em></span> specifies the path to the <span class="emphasis"><em>DAG</em></span> file to use.
<span class="strong"><strong>pegasus-analyzer</strong></span> will get the directory information from the <span class="emphasis"><em>dag_filename</em></span>.
This option overrides the <span class="strong"><strong>--dir</strong></span> option below.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>input_dir</em></span>
, </span><span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>input_dir</em></span>
, </span><span class="term">
<span class="strong"><strong>--dir</strong></span> <span class="emphasis"><em>input_dir</em></span>
</span>
</dt>
<dd>
Makes <span class="strong"><strong>pegasus-analyzer</strong></span> look for the <span class="emphasis"><em>jobstate.log</em></span> file in the <span class="emphasis"><em>input_dir</em></span>
directory. If this option is omitted, <span class="strong"><strong>pegasus-analyzer</strong></span> will look in the
current directory.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>print_options</em></span>
, </span><span class="term">
<span class="strong"><strong>--print</strong></span> <span class="emphasis"><em>print_options</em></span>
</span>
</dt>
<dd>
Tells <span class="strong"><strong>pegasus-analyzer</strong></span> what extra information it should print for failed
jobs. <span class="emphasis"><em>print_options</em></span> is a comma-delimited list of options, that include
<span class="emphasis"><em>pre</em></span>, <span class="emphasis"><em>invocation</em></span>, and/or <span class="emphasis"><em>all</em></span>, which activates all printing options.
With the <span class="emphasis"><em>pre</em></span> option, <span class="strong"><strong>pegasus-analyzer</strong></span> will print the <span class="emphasis"><em>pre-script</em></span>
information for failed jobs. For the <span class="emphasis"><em>invocation</em></span> option, <span class="strong"><strong>pegasus-analyzer</strong></span>
will print the <span class="emphasis"><em>invocation</em></span> command, so users can manually run the failed job.
</dd>
<dt><span class="term">
<span class="strong"><strong>--debug-job</strong></span> <span class="emphasis"><em>job</em></span>
</span></dt>
<dd>
When given this option, <span class="strong"><strong>pegasus-analyzer</strong></span> turns on its <span class="emphasis"><em>debug_mode</em></span>, when it
can be used to debug a particular Pegasus Lite job. In this mode,
<span class="strong"><strong>pegasus-analyzer</strong></span> will create a shell script in the <span class="emphasis"><em>debug_dir</em></span> (see
below, for specifying it) and  copy all necessary files to this local
directory and then execute the job locally.
</dd>
<dt><span class="term">
<span class="strong"><strong>--debug-dir</strong></span> <span class="emphasis"><em>debug_dir</em></span>
</span></dt>
<dd>
When in <span class="emphasis"><em>debug_mode</em></span>, <span class="strong"><strong>pegasus-analyzer</strong></span> will create a temporary debug
directory. Users can give this option in order to specify a particular
<span class="emphasis"><em>debug_dir</em></span> directory to be used instead.
</dd>
<dt><span class="term">
<span class="strong"><strong>--local-executable</strong></span> <span class="emphasis"><em>local user executable</em></span>
</span></dt>
<dd>
When in debug job mode for Pegasus Lite jobs, pegasus-analyzer creates
a shell script to execute the Pegasus Lite job locally in a debug
directory. The Pegasus Lite script refers to remote user executable
path. This option can be used to pass the local path to the user
executable on the submit host. If the path to the user executable in
the Pegasus Lite job is same as the local installation.
</dd>
<dt><span class="term">
<span class="strong"><strong>--type</strong></span> <span class="emphasis"><em>workflow_type</em></span>
</span></dt>
<dd>
In this options, users specify what <span class="emphasis"><em>workflow_type</em></span> they want to debug. At
this moment, the only <span class="emphasis"><em>workflow_type</em></span> available is <span class="strong"><strong>condor</strong></span> and it is the
default value if this option is not specified.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>property_file</em></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>property_file</em></span>
</span>
</dt>
<dd>
This option is used to specify an alternative property file, which may
contain the path to the database to be used by <span class="strong"><strong>pegasus-analyzer</strong></span>. If this
option is not specified, the config file specified in the <span class="strong"><strong>braindump.txt</strong></span>
file will take precedence.
</dd>
<dt><span class="term">
<span class="strong"><strong>--files</strong></span>
</span></dt>
<dd>
This option allows users to run <span class="strong"><strong>pegasus-analyzer</strong></span> using the files in the
workflow directory instead of the database as the source of information.
<span class="strong"><strong>pegasus-analyzer</strong></span> will output the same information, this option only
changes where the data comes from.
</dd>
<dt><span class="term">
<span class="strong"><strong>--top-dir</strong></span> <span class="emphasis"><em>dir_name</em></span>
</span></dt>
<dd>
This option enables <span class="strong"><strong>pegasus-analyzer</strong></span> to show information about
sub-workflows when using the database mode. When debugging a top-level
workflow with failures in sub-workflows, the analyzer will automatically
print the command users should use to debug a failed sub-workflow. This
allows the analyzer to find the database it needs to access.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span>
, </span><span class="term">
<span class="strong"><strong>--recurse</strong></span>
</span>
</dt>
<dd>
This option sets <span class="strong"><strong>pegasus-analyzer</strong></span> to automatically recurse
into sub workflows in case of failure. By default, if a workflow has a
sub workflow in it, and that sub workflow fails , <span class="strong"><strong>pegasus-analyzer</strong></span>
reports that the sub workflow node failed, and lists a command
invocation that the user must execute to determine what jobs in the
sub workflow failed. If this option is set, then the analyzer
automatically issues the command invocation and in addition displays
the failed jobs in the sub workflow.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_environment_variables"></a><h2>Environment Variables</h2>
<p><span class="strong"><strong>pegasus-analyzer</strong></span> does not require that any environmental variables be set.
It locates its required Python modules based on its own location, and
therefore should not be moved outside of Pegasus' bin directory.</p>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_example"></a><h2>Example</h2>
<p>The simplest way to use <span class="strong"><strong>pegasus-analyzer</strong></span> is to go to the <span class="emphasis"><em>run_directory</em></span>
and invoke the analyzer:</p>
<pre class="screen">$ pegasus-analyzer .</pre>
<p>which will cause <span class="strong"><strong>pegasus-analyzer</strong></span> to print information about the workflow
in the current directory.</p>
<p><span class="strong"><strong>pegasus-analyzer</strong></span> output contains a summary, followed by detailed information
about each job that either failed, or is in an unknown state. Here is the summary
section of the output:</p>
<pre class="screen">**************************Summary***************************

 Total jobs         :     75 (100.00%)
 # jobs succeeded   :     41 (54.67%)
 # jobs failed      :      0 (0.00%)
 # jobs held        :      1 (1.33%)
 # jobs unsubmitted :     33 (44.00%)
 # jobs unknown     :      1 (1.33%)</pre>
<p><span class="emphasis"><em>jobs_succeeded</em></span> are jobs that have completed successfully. <span class="emphasis"><em>jobs_failed</em></span>
are jobs that have finished, but that did not complete successfully.
<span class="emphasis"><em>jobs_unsubmitted</em></span> are jobs that are listed in the <span class="emphasis"><em>dag_file</em></span>, but no
information about them was found in the <span class="emphasis"><em>jobstate.log</em></span>
file. <span class="emphasis"><em>jobs_held</em></span> are jobs that were in HTCondor HELD state on the
last retry of the job. With default, pegasus added periodic_remove
expression with the jobs, a held job can eventually fail. In that
case, held job appears as a failed job also. Finally,
<span class="emphasis"><em>jobs_unknown</em></span> are jobs that have started, but have not reached completion.</p>
<p>After the summary section, <span class="strong"><strong>pegasus-analyzer</strong></span> will display information about
each job in the <span class="emphasis"><em>job_failed</em></span> and <span class="emphasis"><em>job_unknown</em></span> categories.</p>
<pre class="screen">*******************************Held jobs' details*******************************

====================================sleep_j2====================================

        submit file            : sleep_j2.sub
        last_job_instance_id   : 7
        reason                 :  Error from slot1@corbusier.isi.edu:
                                  STARTER at 128.9.64.188 failed to
                                  send file(s) to
                                  &lt;128.9.64.188:62639&gt;: error reading from
                                  /opt/condor/8.4.8/local.corbusier/execute/dir_76205/f.out:
                                  (errno 2) No such file or directory;
                                 SHADOW failed to receive file(s) from &lt;128.9.64.188:62653&gt;</pre>
<p>In the above example, the <span class="emphasis"><em>sleep_j2</em></span> job was held, and the analyzer
displays the reason why it was held, as determined from the
dagman.out file for the workflow. The last_job_instance_id is the
database id for the job in the job instance table of the monitoring
database.</p>
<pre class="screen">******************Failed jobs' details**********************

=======================findrange_j3=========================

  last state: POST_SCRIPT_FAILURE
        site: local
 submit file: /home/user/diamond-submit/findrange_j3.sub
 output file: /home/user/diamond-submit/findrange_j3.out.000
  error file: /home/user/diamond-submit/findrange_j3.err.000

--------------------Task #1 - Summary-----------------------

 site        : local
 hostname    : server-machine.domain.com
 executable  : (null)
 arguments   : -a findrange -T 60 -i f.b2 -o f.c2
 error       : 2
 working dir :</pre>
<p>In the example above, the <span class="emphasis"><em>findrange_j3</em></span> job has failed, and the analyzer
displays information about the job, showing that the job finished with a
<span class="emphasis"><em>POST_SCRIPT_FAILURE</em></span>, and lists the <span class="emphasis"><em>submit</em></span>, <span class="emphasis"><em>output</em></span> and <span class="emphasis"><em>error</em></span>
files for this job. Whenever <span class="strong"><strong>pegasus-analyzer</strong></span> detects that the output
file contains a kickstart record, it will display the breakdown containing
each task in the job (in this case we only have one task). Because
<span class="strong"><strong>pegasus-analyzer</strong></span> was not invoked with the <span class="strong"><strong>--quiet</strong></span> flag, it will also
display the contents of the <span class="emphasis"><em>output</em></span> and <span class="emphasis"><em>error</em></span> files (or the stdout and
stderr sections of the kickstart record), which in this case are both empty.</p>
<p>In the case of <span class="emphasis"><em>SUBDAG</em></span> and <span class="emphasis"><em>subdax</em></span> jobs, <span class="strong"><strong>pegasus-analyzer</strong></span> will indicate
it, and show the command needed for the user to debug that sub-workflow. For
example:</p>
<pre class="screen">=================subdax_black_ID000009=====================

  last state: JOB_FAILURE
        site: local
 submit file: /home/user/run1/subdax_black_ID000009.sub
 output file: /home/user/run1/subdax_black_ID000009.out
  error file: /home/user/run1/subdax_black_ID000009.err
  This job contains sub workflows!
  Please run the command below for more information:
  pegasus-analyzer -d /home/user/run1/blackdiamond_ID000009.000

-----------------subdax_black_ID000009.out-----------------

Executing condor dagman ...

-----------------subdax_black_ID000009.err-----------------</pre>
<p>tells the user the <span class="emphasis"><em>subdax_black_ID000009</em></span> sub-workflow failed, and that
it can be debugged by using the indicated <span class="strong"><strong>pegasus-analyzer</strong></span> command.</p>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_see_also"></a><h2>See Also</h2>
<p>pegasus-status(1), pegasus-monitord(1), pegasus-statistics(1).</p>
</div>
<div class="refsect1">
<a name="pegasus-analyzer_authors"></a><h2>Authors</h2>
<p>Fabio Silva <code class="literal">&lt;fabio at isi dot edu&gt;</code></p>
<p>Karan Vahi <code class="literal">&lt;vahi at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-cluster.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 17. Command Line Tools </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-cluster</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
