<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-kickstart");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-kickstart</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-kickstart"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-kickstart — remote job wrapper</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-kickstart_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-kickstart</strong></span> [<span class="strong"><strong>-n</strong></span> <span class="emphasis"><em>tr</em></span>] [<span class="strong"><strong>-N</strong></span> <span class="emphasis"><em>dv</em></span>] [<span class="strong"><strong>-H</strong></span>] [<span class="strong"><strong>-R</strong></span> <span class="emphasis"><em>site</em></span>] [<span class="strong"><strong>-W</strong></span> | <span class="strong"><strong>-w</strong></span> <span class="emphasis"><em>dir</em></span>]<br>
                  [<span class="strong"><strong>-L</strong></span> <span class="emphasis"><em>lbl</em></span> <span class="strong"><strong>-T</strong></span> <span class="emphasis"><em>iso</em></span>] [<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em><span class="'l'=">p</span></em></span> | <span class="emphasis"><em>@fn</em></span>] [<span class="strong"><strong>-S</strong></span> <span class="emphasis"><em><span class="'l'=">p</span></em></span> | <span class="emphasis"><em>@fn</em></span>] [<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>fn</em></span>]<br>
                  [<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>fn</em></span>] [<span class="strong"><strong>-e</strong></span> <span class="emphasis"><em>fn</em></span>] [<span class="strong"><strong>-X</strong></span>] [<span class="strong"><strong>-l</strong></span> <span class="emphasis"><em>fn</em></span> <span class="emphasis"><em>sz</em></span>] [<span class="strong"><strong>-F</strong></span>] (<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>fn</em></span> | <span class="emphasis"><em>app</em></span> [<span class="emphasis"><em>appflags</em></span>])<br>
<span class="strong"><strong>pegasus-kickstart</strong></span> <span class="strong"><strong>-V</strong></span></p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-kickstart</strong></span> is a wrapper program which manages and monitors the
execution of jobs on remote resources.</p>
<p>Sitting in between the remote scheduler and the application process, it is
possible for <span class="strong"><strong>pegasus-kickstart</strong></span> to gather additional information about
the process' run-time behavior and resource usage, including the exit
status of jobs. This information is important for Pegasus invocation
tracking as well as detecting Globus GRAM job failures.</p>
<p><span class="strong"><strong>pegasus-kickstart</strong></span> allows the optional execution of jobs before and after
the main application job that run in chained execution with the main application
job. See section <a class="link" href="cli-pegasus-kickstart.php#SUBJOBS" title="Subjobs"><span class="strong"><strong>SUBJOBS</strong></span></a> for details about this feature.</p>
<p>It also allows stdin, stdout, and stderr to be redirected from/to specific
files.</p>
<p>All jobs with relative path specifications to the application are part
of search relative to the current working directory (yes, this is unsafe),
and by prepending each component from the <span class="emphasis"><em>PATH</em></span> environment variable.
The first match is used. Jobs that use absolute pathnames, starting in a
slash, are exempt. Using an absolute path to your executable is the safe
and recommended option.</p>
<p><span class="strong"><strong>pegasus-kickstart</strong></span> rewrites the command line of any job (pre, post and
main) with variable substitutions from Unix environment variables. See
section <a class="link" href="cli-pegasus-kickstart.php#VARIABLE_REWRITING" title="Variable Rewriting"><span class="strong"><strong>VARIABLE REWRITING</strong></span></a> below for details on
this feature.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_options"></a><h2>Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-n</strong></span> <span class="emphasis"><em>tr</em></span>
</span></dt>
<dd>
<p class="simpara">
In order to associate the minimal performance information of the job
with the invocation records, the jobs needs to carry which
<span class="emphasis"><em>transformation</em></span> was responsible for producing it. The format
is the textual notation for fully-qualified definition names, like
namespace::name:version, with only the name portion being mandatory.
</p>
<p class="simpara">There is no default. If no value is given, "null" will be reported.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-N</strong></span> <span class="emphasis"><em>dv</em></span>
</span></dt>
<dd>
<p class="simpara">
The jobs may carry which instantiation of a transformation was
responsible for producing it. The format is the textual notation for
fully-qualified definition names, like namespace::name:version, with
only the name portion being mandatory.
</p>
<p class="simpara">There is no default. If no value is given, "null" will be reported.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-H</strong></span>
</span></dt>
<dd>
<p class="simpara">
This option avoids pegasus-kickstart writing the XML preamble (entity), if you
need to combine multiple pegasus-kickstart records into one document.
</p>
<p class="simpara">Additionally, if specified, the environment and the resource usage
segments will not be written, assuming that a in a concatenated
record version, the initial run will have captured those settings.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-R</strong></span> <span class="emphasis"><em>site</em></span>
</span></dt>
<dd>
<p class="simpara">
In order to provide the greater picture, pegasus-kickstart can reflect the
site handle (resource identifier) into its output.
</p>
<p class="simpara">There is no default. If no value is given, the attribute will not be
generated.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-L</strong></span> <span class="emphasis"><em>lbl</em></span>
, </span><span class="term">
<span class="strong"><strong>-T</strong></span> <span class="emphasis"><em>iso</em></span>
</span>
</dt>
<dd>
These optional arguments denote the workflow label (from DAX) and the
workflow’s last modification time (from DAX). The label <span class="emphasis"><em>lbl</em></span>
can be any sensible string of up to 32 characters, but should use C
identifier characters. The timestamp <span class="emphasis"><em>iso</em></span> must be an ISO 8601 compliant
time-stamp.
</dd>
<dt><span class="term">
<span class="strong"><strong>-S</strong></span> <span class="emphasis"><em>l=p</em></span>
</span></dt>
<dd>
<p class="simpara">
If stat information on any file is required <span class="emphasis"><em>before</em></span> any jobs were started,
logical to physical file mappings to stat can be passed using the <span class="strong"><strong>-S</strong></span>
option. The LFN and PFN are concatenated by an equals (=) sign. The
LFN is optional: If no equals sign is found, the argument is taken as
sole PFN specification without LFN.
</p>
<p class="simpara">This option may be specified multiple times. To reduce and overcome
command line length limits, if the argument is prefixed with an at (@)
sign, the argument is taken to be a textual file of LFN to PFN mappings.
The optionality mentioned above applies. Each line inside the file
argument is the name of a file to stat. Comments (#) and empty lines
are permitted.</p>
<p class="simpara">Each PFN will incur a <span class="emphasis"><em>statcall</em></span> record (element) with attribute <span class="emphasis"><em>id</em></span>
set to value <span class="emphasis"><em>initial</em></span>. The optional <span class="emphasis"><em>lfn</em></span> attribute is set to the
LFN stat’ed. The filename is part of the <span class="emphasis"><em>statinfo</em></span> record inside.</p>
<p class="simpara">There is no default.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>fn</em></span>
</span></dt>
<dd>
<p class="simpara">
If stat information on any file is required <span class="emphasis"><em>after</em></span> all jobs have finished,
logical to physical file mappings to stat can be passed using the <span class="strong"><strong>-s</strong></span>
option. The LFN and PFN are concatenated by an equals (=) sign. The
LFN is optional: If no equals sign is found, the argument is taken as
sole PFN specification without LFN.
</p>
<p class="simpara">This option may be specified multiple times. To reduce and overcome
commandline length limits, if the argument is prefixed with an at (@)
sign, the argument is taken to be a textual file of LFN to PFN mappings.
The optionality mentioned above applies. Each line inside the file
argument is the name of a file to stat. Comments (#) and empty lines
are permitted.</p>
<p class="simpara">Each PFN will incur a <span class="emphasis"><em>statcall</em></span> record (element) with attribute <span class="emphasis"><em>id</em></span>
set to value <span class="emphasis"><em>final</em></span>. The optional <span class="emphasis"><em>lfn</em></span> attribute is set to the LFN
stat’ed. The filename is part of the <span class="emphasis"><em>statinfo</em></span> record inside.</p>
<p class="simpara">There is no default.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>fn</em></span>
</span></dt>
<dd>
<p class="simpara">
This option allows <span class="strong"><strong>pegasus-kickstart</strong></span> to re-connect the stdin of the
application that it starts. Use a single hyphen to share <span class="emphasis"><em>stdin</em></span>
with the one provided to <span class="strong"><strong>pegasus-kickstart</strong></span>.
</p>
<p class="simpara">The default is to connect <span class="emphasis"><em>stdin</em></span> to <span class="emphasis"><em>/dev/null</em></span>.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>fn</em></span>
</span></dt>
<dd>
<p class="simpara">
This option allows <span class="strong"><strong>pegasus-kickstart</strong></span> to re-connect the <span class="emphasis"><em>stdout</em></span>
of the application that it starts. The mode is used whenever an application
produces meaningful results on its <span class="emphasis"><em>stdout</em></span> that need to be tracked by
Pegasus. The real <span class="emphasis"><em>stdout</em></span> of Globus jobs is staged via GASS (GT2) or
RFT (GT4). The real <span class="emphasis"><em>stdout</em></span> is used to propagate the invocation record
back to the submit site. Use the single hyphen to share the application’s
<span class="emphasis"><em>stdout</em></span> with the one that is provided to <span class="strong"><strong>pegasus-kickstart</strong></span>. In that
case, the output from <span class="strong"><strong>pegasus-kickstart</strong></span> will interleave with application
output. For this reason, such a mode is not recommended.
</p>
<p class="simpara">In order to provide an un-captured <span class="emphasis"><em>stdout</em></span> as part of the results, it is
the default to connect the <span class="emphasis"><em>stdout</em></span> of the application to a temporary file.
The content of this temporary file will be transferred as payload data in
the <span class="strong"><strong>pegasus-kickstart</strong></span> results. The content size is subject to payload
limits, see the <span class="strong"><strong>-B</strong></span> option. If the content grows large, only the last
portion will become part of the payload. If the temporary file grows too
large, it may flood the worker node’s temporary space. The temporary file
will be deleted after <span class="strong"><strong>pegasus-kickstart</strong></span> finishes.</p>
<p class="simpara">If the filename is prefixed with an exclamation point, the file will
be opened in append mode instead of overwrite mode. Note that you may
need to escape the exclamation point from the shell.</p>
<p class="simpara">The default is to connect <span class="emphasis"><em>stdout</em></span> to a temporary file.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-e</strong></span> <span class="emphasis"><em>fn</em></span>
</span></dt>
<dd>
<p class="simpara">
This option allows <span class="strong"><strong>pegasus-kickstart</strong></span> to re-connect the <span class="emphasis"><em>stderr</em></span>
of the application that it starts. This option is used whenever an
application produces meaningful results on <span class="emphasis"><em>stderr</em></span> that needs tracking
by Pegasus. The real <span class="emphasis"><em>stderr</em></span> of Globus jobs is staged via GASS (GT2)
or RFT (GT4). It is used to propagate abnormal behavior from both,
<span class="strong"><strong>pegasus-kickstart</strong></span> and the application that it starts, though its
main use is to propagate application dependent data and heartbeats.
Use a single hyphen to share <span class="emphasis"><em>stderr</em></span> with the <span class="emphasis"><em>stderr</em></span> that is
provided to <span class="strong"><strong>pegasus-kickstart</strong></span>. This is the backward compatible
behavior.
</p>
<p class="simpara">In order to provide an un-captured <span class="emphasis"><em>stderr</em></span> as part of the results, by
default the <span class="emphasis"><em>stderr</em></span> of the application will be connected to a temporary
file. Its content is transferred as payload data in the <span class="strong"><strong>pegasus-kickstart</strong></span>
results. If too large, only the last portion will become part of
the payload. If the temporary file grows too large, it may flood the
worker node’s temporary space. The temporary file will be deleted after
<span class="strong"><strong>pegasus-kickstart</strong></span> finishes.</p>
<p class="simpara">If the filename is prefixed with an exclamation point, the file will
be opened in append mode instead of overwrite mode. Note that you may
need to escape the exclamation point from the shell.</p>
<p class="simpara">The default is to connect <span class="emphasis"><em>stderr</em></span> to a temporary file.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-l</strong></span> <span class="emphasis"><em>logfn</em></span>
</span></dt>
<dd>
<p class="simpara">
allows to append the performance data to the specified file. Thus,
multiple XML documents may end up in the same file, including their XML
preamble. <span class="emphasis"><em>stdout</em></span> is normally used to stream back the results. Usually,
this is a GASS-staged stream. Use a single hyphen to generate the output
on the <span class="emphasis"><em>stdout</em></span> that was provided to <span class="strong"><strong>pegasus-kickstart</strong></span>, the default
behavior.
</p>
<p class="simpara">Default is to append the invocation record onto the provided <span class="emphasis"><em>stdout</em></span>.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-w</strong></span> <span class="emphasis"><em>dir</em></span>
</span></dt>
<dd>
<p class="simpara">
permits the explicit setting of a new working directory once pegasus-kickstart
is started. This is useful in a remote scheduling environment, when the
chosen working directory is not visible on the job submitting host. If
the directory does not exist, <span class="strong"><strong>pegasus-kickstart</strong></span> will fail. This option is
mutually exclusive with the <span class="strong"><strong>-W</strong></span> <span class="emphasis"><em>dir</em></span> option.
</p>
<p class="simpara">Default is to use the working directory that the application was started
in. This is usually set up by a remote scheduling environment.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-W</strong></span> <span class="emphasis"><em>dir</em></span>
</span></dt>
<dd>
<p class="simpara">
permits the explicit creation and setting of a new working directory
once pegasus-kickstart is started. This is useful in a remote scheduling
environment, when the chosen working directory is not visible on the job
submitting host. If the directory does not exist, <span class="strong"><strong>pegasus-kickstart</strong></span>
will attempt to create it, and then change into it. Both, creation and
directory change may still fail. This option is mutually exclusive with
the <span class="strong"><strong>-w</strong></span> <span class="emphasis"><em>dir</em></span> option.
</p>
<p class="simpara">Default is to use the working directory that the application was started
in. This is usually set up by a remote scheduling environment.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-X</strong></span>
</span></dt>
<dd>
<p class="simpara">
make an application executable, no matter what. It is a work-around code
for a weakness of <span class="strong"><strong>globus-url-copy</strong></span> which does not copy the permissions
of the source to the destination. Thus, if an executable is staged-in
using GridFTP, it will have the wrong permissions. Specifying the <span class="strong"><strong>-X</strong></span>
flag will attempt to change the mode to include the necessary x (and r)
bits to make the application executable.
</p>
<p class="simpara">Default is not to change the mode of the application. Note that this
feature can be misused by hackers, as it is attempted to call chmod
on whatever path is specified.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-B</strong></span> <span class="emphasis"><em>sz</em></span>
</span></dt>
<dd>
Changes the amount of stdout and stderr data to include in the output.
The last <span class="emphasis"><em>sz</em></span> bytes of the stdout and stderr of the process will be copied
into kickstart’s output. All other data will be discarded. The special
value <span class="emphasis"><em>all</em></span> can be used to capture all the stdout/stderr of the process.
The default is 256KB.
</dd>
<dt><span class="term">
<span class="strong"><strong>-F</strong></span>
</span></dt>
<dd>
<p class="simpara">
This flag will issue an explicit <span class="strong"><strong>fsync()</strong></span> call on kickstart’s own <span class="emphasis"><em>stdout</em></span>
file. Typically you won’t need this flag. Albeit, certain shared file
system situations may improve when adding a flush after the written
invocation record.
</p>
<p class="simpara">The default is to just use kickstart’s NFS alleviation strategy by
locking and unlocking <span class="emphasis"><em>stdout</em></span>.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>fn</em></span>
</span></dt>
<dd>
<p class="simpara">
In this mode, the application name and any arguments to the application
are specified inside of file <span class="emphasis"><em>fn</em></span>. The file contains one argument per line.
Escaping from Globus, Condor and shell meta characters is not required. This
mode permits to use the maximum possible command line length of the
underlying operating system, e.g. 128k for Linux. Using the <span class="strong"><strong>-I</strong></span> mode stops
any further command line processing of <span class="strong"><strong>pegasus-kickstart</strong></span> command lines.
</p>
<p class="simpara">Default is to use the <span class="emphasis"><em>app flags</em></span> mode, where the application is specified
explicitly on the command-line.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>-f</strong></span>
</span></dt>
<dd>
This flag causes kickstart to output full information, including the
environment and resource limits under which the job ran, and any useful
auxilliary statcalls. If the job fails, then <span class="strong"><strong>-f</strong></span> is implied.
</dd>
<dt><span class="term">
<span class="strong"><strong>-k</strong></span> <span class="emphasis"><em>S</em></span>
</span></dt>
<dd>
This flag causes kickstart to send the job a SIGTERM if it is still running
after S seconds.  The default value is 0, which disables the timeout.
</dd>
<dt><span class="term">
<span class="strong"><strong>-K</strong></span> <span class="emphasis"><em>S</em></span>
</span></dt>
<dd>
This flag causes kickstart to send the job a SIGKILL if it is still running S
seconds after recieving a SIGTERM sent as a result of the <span class="strong"><strong>-k</strong></span> flag. The default
value is 5. If <span class="strong"><strong>-k</strong></span> is not set, or is set to 0, then this flag is ignored.
</dd>
<dt><span class="term">
<span class="strong"><strong>-t</strong></span>
</span></dt>
<dd>
This flag causes kickstart to use ptrace() to collect resource usage info
for the process by intercepting the process start and stop events. This flag
only exists when kickstart is compiled for Linux.
</dd>
<dt><span class="term">
<span class="strong"><strong>-z</strong></span>
</span></dt>
<dd>
This flag causes kickstart to use ptrace() to intercept system calls and report
a list of files accessed and I/O performed. This flag only exists when
kickstart is compiled for Linux.
</dd>
<dt><span class="term">
<span class="strong"><strong>-Z</strong></span>
</span></dt>
<dd>
This flag causes kickstart to use LD_PRELOAD to intercept library calls and
report a list of files accessed and I/O performed. This flag only exists when
kickstart is compiled for Linux. There are several environment variables
documented below that control what file accesses are traced.
</dd>
<dt><span class="term">
<span class="strong"><strong>-q</strong></span>
</span></dt>
<dd>
This flag causes kickstart to omit the &lt;data&gt; part of the &lt;statcall&gt; records
when the job exits successfully. This is designed to reduce the size of the
output logs for large workflows.
</dd>
<dt><span class="term">
<span class="strong"><strong>-c</strong></span>
</span></dt>
<dd>
This flag causes kickstart to output &lt;data&gt; from stdout and stderr as a CDATA
section instead of quoting it.
</dd>
<dt><span class="term">
<span class="emphasis"><em>app</em></span>
</span></dt>
<dd>
The path to the application has to be completely specified. The application
is a mandatory option.
</dd>
<dt><span class="term">
<span class="emphasis"><em>appflags</em></span>
</span></dt>
<dd>
Application may or may not have additional flags.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_return_value"></a><h2>Return Value</h2>
<p><span class="strong"><strong>pegasus-kickstart</strong></span> will return the return value of the main job. In
addition, the error code 127 signals that the call to exec failed, and
126 that reconnecting the stdio failed. A job failing with the same
exit codes is indistinguishable from <span class="strong"><strong>pegasus-kickstart</strong></span> failures.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_see_also"></a><h2>See Also</h2>
<p>pegasus-plan(1), condor_submit_dag(1), condor_submit(1), getrusage(3c).</p>
</div>
<div class="refsect1">
<a name="SUBJOBS"></a><h2>Subjobs</h2>
<p>Subjobs are a new feature and may have a few wrinkles left.</p>
<p>In order to allow specific setups and assertion checks for compute nodes,
<span class="strong"><strong>pegasus-kickstart</strong></span> allows the optional execution of a <span class="emphasis"><em>prejob</em></span>. This
<span class="emphasis"><em>prejob</em></span> is anything that the remote compute node is capable of executing.
For modern Unix systems, this includes #! scripts interpreter invocations,
as long as the x bits on the executed file are set. The main job is run
if and only if the prejob returned regularly with an exit code of zero.</p>
<p>With similar restrictions, the optional execution of a <span class="emphasis"><em>postjob</em></span> is
chained to the success of the main job. The postjob will be run, if the
main job terminated normally with an exit code of zero.</p>
<p>In addition, a user may specify a <span class="emphasis"><em>setup</em></span> and a <span class="emphasis"><em>cleanup</em></span> job. The <span class="emphasis"><em>setup</em></span>
job sets up the remote execution environment. The <span class="emphasis"><em>cleanup</em></span> job may tear
down and clean-up after any job ran. Failure to run the setup job has no
impact on subsequent jobs. The cleanup is a job that will even be attempted
to run for all failed jobs. No job information is passed. If you need to
invoke multiple setup or clean-up jobs, bundle them into a script, and
invoke the clean-up script. Failure of the clean-up job is not meant to
affect the progress of the remote workflow (DAGMan). This may change in
the future.</p>
<p>The setup-, pre-, and post- and cleanup-job run on the same compute node
as the main job to execute. However, since they run in separate
processes as children of <span class="strong"><strong>pegasus-kickstart</strong></span>, they are unable to influence
each others nor the main jobs environment settings.</p>
<p>All jobs and their arguments are subject to variable substitutions as
explained in the next section.</p>
<p>To specify the prejob, insert the the application invocation and any
optional commandline argument into the environment variable
<span class="emphasis"><em>KICKSTART_PREJOB</em></span>. If you are invoking from a shell, you might want to
use single quotes to protect against the shell. If you are invoking from
Globus, you can append the RSL string feature. From Condor, you can use
Condor’s notion of environment settings. In Pegasus use the <span class="emphasis"><em>profile</em></span>
command to set generic scripts that will work on multiple sites,
or the transformation catalog to set environment variables in a pool-specific
fashion. Please remember that the execution of the main job is chained
to the success of the prejob.</p>
<p>To set up the postjob, use the environment variable <span class="emphasis"><em>KICKSTART_POSTJOB</em></span>
to point to an application with potential arguments to execute. The same
restrictions as for the prejob apply. Please note that the execution of
the post job is chained to the main job.</p>
<p>To provide the independent setup job, use the environment variable
<span class="emphasis"><em>KICKSTART_SETUP</em></span>. The exit code of the setup job has no influence on the
remaining chain of jobs. To provide an independent cleanup job, use the
environment variable <span class="emphasis"><em>KICKSTART_CLEANUP</em></span> to point to an application with
possible arguments to execute. The same restrictions as for prejob and
postjob apply. The cleanup is run regardless of the exit status of any
other jobs.</p>
</div>
<div class="refsect1">
<a name="VARIABLE_REWRITING"></a><h2>Variable Rewriting</h2>
<p>Variable substitution is a new feature and may have a few wrinkles left.</p>
<p>The variable substitution employs simple rules from the Bourne shell
syntax. Simple quoting rules for backslashed characters, double quotes
and single quotes are obeyed. Thus, in order to pass a dollar sign to
as argument to your job, it must be escaped with a backslash from the
variable rewriting.</p>
<p>For pre- and postjobs, double quotes allow the preservation of whitespace
and the insertion of special characters like \a (alarm), \b (backspace),
\n (newline), \r (carriage return), \t (horizontal tab), and \v
(vertical tab). Octal modes are <span class="emphasis"><em>not</em></span> allowed. Variables are still
substituted in double quotes. Single quotes inside double quotes have no
special meaning.</p>
<p>Inside single quotes, no variables are expanded. The backslash only
escapes a single quote or backslash.</p>
<p>Backticks are not supported.</p>
<p>Variables are only substituted once. You cannot have variables in
variables. If you need this feature, please request it.</p>
<p>Outside quotes, arguments from the pre- and postjob are split on linear
whitespace. The backslash makes the next character verbatim.</p>
<p>Variables that are rewritten must start with a dollar sign either
outside quotes or inside double quotes. The dollar may be followed by a
valid identifier. A valid identifier starts with a letter or the
underscore. A valid identifier may contain further letters, digits or
underscores. The identifier is case sensitive.</p>
<p>The alternative use is to enclose the identifier inside curly braces. In
this case, almost any character is allowed for the identifier, including
whitespace. This is the <span class="emphasis"><em>only</em></span> curly brace expansion. No other Bourne magic
involving curly braces is supported.</p>
<p>One of the advantages of variable substitution is, for example, the
ability to specify the application as <span class="emphasis"><em>$HOME/bin/app1</em></span>
in the transformation catalog, and thus to gridstart. As long as your
home directory on any compute node has a <span class="emphasis"><em>bin</em></span>
directory that contains the application, the transformation catalog does
not need to care about the true location of the application path on each
pool. Even better, an administrator may decide to move your home
directory to a different place. As long as the compute node is set up
correctly, you don’t have to adjust any Pegasus data.</p>
<p>Mind that variable substitution is an expert feature, as some degree of
tricky quoting is required to protect substitutable variables and quotes
from Globus, Condor and Pegasus in that order. Note that Condor uses the
dollar sign for its own variables.</p>
<p>The variable substitution assumptions for the main job differ
slightly from the prejob and postjob for technical reasons. The pre-
and postjob command lines are passed as one string. However, the main
jobs command line is already split into pieces by the time it reaches
<span class="strong"><strong>pegasus-kickstart</strong></span>.
Thus, any whitespace on the main job’s command line must be preserved,
and further argument splitting avoided.</p>
<p>It is highly recommended to experiment on the Unix command line with the
<span class="emphasis"><em>echo</em></span> and <span class="emphasis"><em>env</em></span> applications to obtain a feeling for the different
quoting mechanisms needed to achieve variable substitution.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_example"></a><h2>Example</h2>
<p>You can run the <span class="strong"><strong>pegasus-kickstart</strong></span> executable locally to verify that
it is functioning well. In the initial phase, the format of the
performance data may be slightly adjusted.</p>
<pre class="screen">$ env KICKSTART_PREJOB='/bin/usleep 250000' \\
  KICKSTART_POSTJOB='/bin/date -u' \\
  pegasus-kickstart -l xx \\$PEGASUS_HOME/bin/keg -T1 -o-
$ cat xx
&lt;?xml version="1.0" encoding="ISO-8859-1"?&gt;
  ...
  &lt;/statcall&gt;
&lt;/invocation&gt;</pre>
<p>Please take note a few things in the above example:</p>
<p>The output from the postjob is appended to the output of the main job on
<span class="emphasis"><em>stdout</em></span>. The output could potentially be separated into different data
sections through different temporary files. If you truly need the separation,
request that feature.</p>
<p>The log file is reported with a size of zero, because the log file did
indeed barely exist at the time the data structure was (re-)
initialized. With regular GASS output, it will report the status of the
socket file descriptor, though.</p>
<p>The file descriptors reported for the temporary files are from the
perspective of <span class="strong"><strong>pegasus-kickstart</strong></span>. Since the temporary files have the
close-on-exec flag set, <span class="strong"><strong>pegasus-kickstart</strong></span><span class="emphasis"><em>s file descriptors are invisible
to the job processes. Still, the 'stdio</em></span> of the job processes are connected
to the temporary files.</p>
<p>Even this output already appears large. The output may already be too
large to guarantee that the append operation on networked pipes (GASS,
NFS) are atomically written.</p>
<p>The current format of the performance data is as follows:</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_timeouts"></a><h2>Timeouts</h2>
<p>Kickstart sets timeouts for the job based on the <span class="strong"><strong>-k</strong></span> and <span class="strong"><strong>-K</strong></span> flags. The <span class="strong"><strong>-k</strong></span>
flag sets the time kickstart will wait before it sends the job a SIGTERM, and
the <span class="strong"><strong>-K</strong></span> flag sets the time kickstart will wait after delivering a SIGTERM until
it delivers a SIGKILL. The <span class="strong"><strong>-K</strong></span> timeout is designed to give the job some time
to write a checkpoint, which it can trigger by handling the SIGTERM. If the job
runs for longer than the timeout specified using <span class="strong"><strong>-k</strong></span>, then then the job exits
with a non-zero exit status.</p>
<p>If the job has KICKSTART_SETUP, KICKSTART_PREJOB, or KICKSTART_POSTJOB, then
their runtimes are included in the timeout and they will be sent SIGTERM/SIGKILL
in the same manner as the main job. If KICKSTART_CLEANUP is set, then it will run
regardless of whether processes from the other stages were signalled. If
KICKSTART_SETUP is specified, and it runs longer than the timeout, then it
will be signalled, and the other stages will be skipped.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_output_format"></a><h2>Output Format</h2>
<p>Refer to <a class="ulink" href="http://pegasus.isi.edu/wms/docs/schemas/iv-2.2/iv-2.2.html" target="_top">http://pegasus.isi.edu/wms/docs/schemas/iv-2.2/iv-2.2.html</a>
for an up-to-date description of elements and their attributes. Check with
<a class="ulink" href="http://pegasus.isi.edu/documentation" target="_top">http://pegasus.isi.edu/documentation</a> for invocation schemas with a higher
version number.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_restrictions"></a><h2>Restrictions</h2>
<p>There is no version for the Condor <span class="emphasis"><em>standard</em></span> universe. It is simply not
possible within the constraints of Condor.</p>
<p>Due to its very nature, <span class="strong"><strong>pegasus-kickstart</strong></span> will also prove difficult
to port outside the Unix environment.</p>
<p>Any of the pre-, main-, cleanup and postjob are unable to influence one
another’s visible environment.</p>
<p>Do not use a Pegasus transformation with just the name <span class="emphasis"><em>null</em></span>
and no namespace nor version.</p>
<p>First Condor, and then Unix, place a limit on the length of the command line.
The additional space required for the gridstart invocation may silently
overflow the maximum space, and cause applications to fail. If you suspect
to work with many argument, try an argument-file based approach.</p>
<p>A job failing with exit code 126 or 127 is indistinguishable from
<span class="strong"><strong>pegasus-kickstart</strong></span> failing with the same exit codes. Sometimes, careful
examination of the returned data can help.</p>
<p>If the logfile is collected into a shared file, due to the size of the
data, simultaneous appends on a shared filesystem from different
machines may still mangle data. Currently, file locking is not even
attempted, although all data is written atomically from the perspective
of <span class="strong"><strong>pegasus-kickstart</strong></span>.</p>
<p>The upper limit of characters of command line characters is currently not
checked by <span class="strong"><strong>pegasus-kickstart</strong></span>. Thus, some variable substitutions could
potentially result in a command line that is larger than permissible.</p>
<p>If the output or error file is opened in append mode, but the
application decides to truncate its output file, as in the above example
by opening <span class="emphasis"><em>/dev/fd/1</em></span> inside <span class="emphasis"><em>keg</em></span>, the resulting file will still be
truncated. This is correct behavior, but sometimes not obvious.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_files"></a><h2>Files</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>/usr/share/pegasus/schema/iv-2.2.xsd</strong></span>
</span></dt>
<dd>
is the suggested location of the latest XML schema describing the data
on the submit host.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="METADATA"></a><h2>Metadata</h2>
<p>Kickstart creates a file to which the job should write metadata "key=value"
pairs. The contents of the file are inserted into the invocation record by
Kickstart, and transferred with the job’s stdio. If the job is run under
Pegasus, then pegasus-monitord will parse this metadata and merge it with
the metadata for the job in the Pegasus workflow database. Kickstart uses
the environment variable <span class="strong"><strong>KICKSTART_METADATA</strong></span> to tell the job to which file
it should write its metadata.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_environment_variables"></a><h2>Environment Variables</h2>
<p>Note: Pegasus 4.6 deprecated the "GRIDSTART_" prefix for environment variables
and replaced it with "KICKSTART_". The "GRIDSTART_" versions of the old variables
should still work.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>KICKSTART_TMP</strong></span>
</span></dt>
<dd>
is the hightest priority to look for a temporary directory, if
specified. This rather special variable was introduced to overcome
some peculiarities with the FNAL cluster.
</dd>
<dt><span class="term">
<span class="strong"><strong>TMP</strong></span>
</span></dt>
<dd>
is the next hightest priority to look for a temporary directory, if
specified.
</dd>
<dt><span class="term">
<span class="strong"><strong>TEMP</strong></span>
</span></dt>
<dd>
is the next priority for an environment variable denoting a
temporary files directory.
</dd>
<dt><span class="term">
<span class="strong"><strong>TMPDIR</strong></span>
</span></dt>
<dd>
is next in the checklist. If none of these are found, either the
<span class="emphasis"><em>stdio</em></span> definition <span class="emphasis"><em>P_tmpdir</em></span> is taken, or the fixed string
<span class="emphasis"><em>/tmp</em></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_SETUP</strong></span>
</span></dt>
<dd>
contains a string that starts a job to be executed unconditionally
before any other jobs, see above for a detailed description.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_PREJOB</strong></span>
</span></dt>
<dd>
contains a string that starts a job to be executed before the main
job, see above for a detailed description.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_POSTJOB</strong></span>
</span></dt>
<dd>
contains a string that starts a job to be executed conditionally
after the main job, see above for a detailed description.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_CLEANUP</strong></span>
</span></dt>
<dd>
contains a string that starts a job to be executed unconditionally
after any of the previous jobs, see above for a detailed description.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_PREPEND_PATH</strong></span>
</span></dt>
<dd>
the value of this variable is prepended to the PATH variable seen by
Kickstart and passed to the job. The modified PATH is also used to look
up executables for the main job and any pre/post/setup/cleanup jobs.
</dd>
<dt><span class="term">
<span class="strong"><strong>KICKSTART_WRAPPER</strong></span>
</span></dt>
<dd>
the value of this variable is prepended to the job arguments. It can
be used to wrap the task with a wrapper or launcher. For example, you
can set it to "mpiexec -n 128" to run an MPI job, or you can set it
to "tau_exec" to profile the job with TAU.
</dd>
</dl></div>
<p><span class="strong"><strong>KICKSTART_TRACE_ALL</strong></span>
If this variable is set, then the <span class="strong"><strong>-Z</strong></span> option will trace everything,
including stdio and directories. By default, stdio and directories are
ignored.</p>
<p><span class="strong"><strong>KICKSTART_TRACE_CWD</strong></span>
If this variable is set, then the <span class="strong"><strong>-Z</strong></span> option will only trace files in the
current working directory of the process.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>KICKSTART_TRACE_MATCH</strong></span>
</span></dt>
<dd>
If this variable is set, then the <span class="strong"><strong>-Z</strong></span> option will only trace files that
match one of the patterns specified. The value of this variable should
be a list of <span class="strong"><strong>fnmatch()</strong></span> patterns separated by <span class="emphasis"><em>:</em></span>.
</dd>
</dl></div>
<p><span class="strong"><strong>KICKSTART_TRACE_IGNORE</strong></span>
This is the inverse of <span class="strong"><strong>KICKSTART_TRACE_MATCH</strong></span>. Any files matching one of the
patterns will be ignored, and all other files will be traced.</p>
<p><span class="strong"><strong>KICKSTART_METADATA</strong></span>
Kickstart passes this environment variable to the job. The value of the
variable is the path to the metadata file to which the job should write its
metadata. See the <a class="link" href="cli-pegasus-kickstart.php#METADATA" title="Metadata"><span class="strong"><strong>METADATA</strong></span></a> section for more information.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_history"></a><h2>History</h2>
<p>As you may have noticed, <span class="strong"><strong>pegasus-kickstart</strong></span> had the name <span class="strong"><strong>kickstart</strong></span>
in previous incantations. We are slowly moving to the new name to avoid
clashes in a larger OS installation setting. However, there is no
pertinent need to change the internal name, too, as no name clashes are
expected.</p>
</div>
<div class="refsect1">
<a name="pegasus-kickstart_authors"></a><h2>Authors</h2>
<p>Michael Milligan <code class="literal">&lt;mbmillig@uchicago.edu&gt;</code></p>
<p>Mike Wilde <code class="literal">&lt;wilde@mcs.anl.gov&gt;</code></p>
<p>Yong Zhao <code class="literal">&lt;yongzh@cs.uchicago.edu&gt;</code></p>
<p>Jens-S. Vöckler <code class="literal">&lt;voeckler@isi.edu&gt;</code></p>
<p>Gideon Juve <code class="literal">&lt;gideon@isi.edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-keg.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-metadata.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-keg </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-metadata</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
