<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-run");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-run</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-run"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-run — executes a workflow that has been planned using *pegasus-plan*.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-run_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-run</strong></span> [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>…][<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>propsfile</em></span>][<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>level</em></span>]<br>
            [<span class="strong"><strong>-v][</strong></span>--grid*][rundir]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-run_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-run</strong></span> command executes a workflow that has been planned using
<span class="strong"><strong>pegasus-plan</strong></span>. By default pegasus-run can be invoked either in the planned
directory with no options and arguments or just the full path to the run
directory. <span class="strong"><strong>pegasus-run</strong></span> also can be used to resubmit a failed workflow by
running the same command again.</p>
</div>
<div class="refsect1">
<a name="pegasus-run_options"></a><h2>Options</h2>
<p>By default <span class="strong"><strong>pegasus-run</strong></span> does not require any options or arguments if
invoked from within the planned workflow directory. If running the command
outside the workflow directory then a full path to the workflow directory
needs to be specified.</p>
<p><span class="strong"><strong>pegasus-run</strong></span> takes the following options</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
<p class="simpara">
The <span class="strong"><strong>-D</strong></span> option allows an advanced user to override certain properties which
influence <span class="strong"><strong>pegasus-run</strong></span>. One may set several CLI properties by giving this
option multiple times.
</p>
<p class="simpara">The <span class="strong"><strong>-D</strong></span> option(s) must be the first option on the command line. CLI
properties take precedence over the file-based properties of the same key.</p>
<p class="simpara">See the <a class="link" href="cli-pegasus-run.php#PROPERTIES" title="Properties"><span class="strong"><strong>PROPERTIES</strong></span></a> section below.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>propsfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propsfile</em></span>
</span>
</dt>
<dd>
Provide a property file to override the default Pegasus properties file
from the planning directory. Ordinary users do not need to use this option
unless the specifically want to override several properties
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>level</em></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span> <span class="emphasis"><em>level</em></span>
</span>
</dt>
<dd>
Set the debug level for the client. Default is 0.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Raises debug level. Each invocation increase the level by 1.
</dd>
<dt><span class="term">
<span class="strong"><strong>--grid</strong></span>
</span></dt>
<dd>
Enable grid checks to see if your submit machine is GRID enabled.
</dd>
<dt><span class="term">
<span class="emphasis"><em>rundir</em></span>
</span></dt>
<dd>
Is the full qualified path to the base directory containing the planned
workflow DAG and submit files. This is optional if the <span class="strong"><strong>pegasus-run</strong></span> command
is invoked from within the run directory.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-run_return_value"></a><h2>Return Value</h2>
<p>If the workflow is submitted for execution <span class="strong"><strong>pegasus-run</strong></span> returns with
an exit code of 0. However, in case of error, a non-zero return value
indicates problems. An error message clearly marks the cause.</p>
</div>
<div class="refsect1">
<a name="pegasus-run_files"></a><h2>Files</h2>
<p>The following files are created, opened or written to:</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>braindump</strong></span>
</span></dt>
<dd>
This file is located in the rundir. pegasus-run uses this file to find
out paths to several other files, properties configurations etc.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.?????????.properties</strong></span>
</span></dt>
<dd>
This file is located in the rundir. pegasus-run uses this properties
file by default to configure its internal settings.
</dd>
<dt><span class="term">
<span class="strong"><strong>workflowname.dag</strong></span>
</span></dt>
<dd>
pegasus-run uses the workflowname.dag or workflowname.sh file and
submits it either to condor for execution or runs it locally in a
shell environment
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="PROPERTIES"></a><h2>Properties</h2>
<p>pegasus-run reads its properties from several locations.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>RUNDIR/pegasus.??????????.properties</strong></span>
</span></dt>
<dd>
The default location for pegasus-run to read the properties from
</dd>
<dt><span class="term">
<span class="strong"><strong>--conf propfile</strong></span>
</span></dt>
<dd>
properties file provided in the conf option replaces the default
properties file used.
</dd>
<dt><span class="term">
<span class="strong"><strong>$HOME/.pegasusrc</strong></span>
</span></dt>
<dd>
<p class="simpara">
will be used if neither default rundir properties or --conf
propertiesfile are found.
</p>
<p class="simpara">Additionally properties can be provided individually using the
<span class="strong"><strong>-Dpropkey</strong></span>=<span class="emphasis"><em>propvalue</em></span> option on the command line before all other
options. These properties will override properties provided using
either <span class="strong"><strong>--conf</strong></span> or <span class="emphasis"><em>RUNDIR/pegasus.???????.properties</em></span> or the
<span class="emphasis"><em>$HOME/.pegasusrc</em></span></p>
<p class="simpara">The merge logic is CONF PROPERTIES || DEFAULT RUNDIR PROPERTIES
|| PEGASUSRC overriden by Command line properties</p>
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-run_environment_variables"></a><h2>Environment Variables</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>PATH</strong></span>
</span></dt>
<dd>
The path variable is used to locate binaries for condor-submit-dag,
condor-dagman, condor-submit,pegasus-submit-dag, pegasus-dagman and
pegasus-monitord
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-run_see_also"></a><h2>See Also</h2>
<p>pegasus-plan(1)</p>
</div>
<div class="refsect1">
<a name="pegasus-run_authors"></a><h2>Authors</h2>
<p>Gaurang Mehta  <code class="literal">&lt;gmehta at isi dot edu&gt;</code></p>
<p>Jens-S. Vöckler <code class="literal">&lt;voeckler at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-remove.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-s3.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-remove </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-s3</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
