<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("6.4. Notifications");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="monitoring_debugging_stats.php">Monitoring, Debugging and Statistics</a></span> &gt; <span class="breadcrumb-node">Notifications</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="notifications"></a>6.4. Notifications</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="notifications.php#idm2728">6.4.1. Specifying Notifications in the DAX</a></span></dt>
<dt><span class="section"><a href="notifications.php#pegasus_notify_file">6.4.2. Notify File created by Pegasus in the submit directory</a></span></dt>
<dt><span class="section"><a href="notifications.php#idm2822">6.4.3. Configuring pegasus-monitord for notifications</a></span></dt>
<dt><span class="section"><a href="notifications.php#idm2858">6.4.4. Default Notification Scripts</a></span></dt>
</dl></div>
<p>The Pegasus Workflow Mapper now supports job and workflow level
    notifications. You can specify in the DAX with the job or the
    workflow</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>the event when the notification needs to be sent</p></li>
<li class="listitem"><p>the executable that needs to be invoked.</p></li>
</ul></div>
<p>The notifications are issued from the submit host by the
    pegasus-monitord daemon that monitors the Condor logs for the workflow.
    When a notification is issued, pegasus-monitord while invoking the
    notifying executable sets certain environment variables that contain
    information about the job and workflow state.</p>
<p>The Pegasus release comes with default notification clients that
    send notifications via email or jabber.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm2728"></a>6.4.1. Specifying Notifications in the DAX</h3></div></div></div>
<p>Currently, you can specify notifications for the jobs and the
      workflow by the use of invoke elements.</p>
<p>Invoke elements can be sub elements for the following elements in
      the DAX schema.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>job - to associate notifications with a compute job in the
            DAX.</p></li>
<li class="listitem"><p>dax - to associate notifications with a dax job in the
            DAX.</p></li>
<li class="listitem"><p>dag - to associate notifications with a dag job in the
            DAX.</p></li>
<li class="listitem"><p>executable - to associate notifications with a job that uses
            a particular notification</p></li>
</ul></div>
<p>The invoke element can be specified at the root element level of
      the DAX to indicate workflow level notifications.</p>
<p>The invoke element may be specified multiple times, as needed. It
      has a mandatory <span class="bold"><strong>when</strong></span> attribute with the
      following value set</p>
<div class="table">
<a name="notification_conditions_table"></a><p class="title"><b>Table 6.5. Invoke Element attributes and meaning.</b></p>
<div class="table-contents"><table class="table" summary="Invoke Element attributes and meaning." border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Enumeration of Values for when
              attribute</th>
<th align="center">Meaning</th>
</tr></thead>
<tbody>
<tr>
<td>never</td>
<td>(default). Never notify of anything. This is useful to
              temporarily disable an existing notifications.</td>
</tr>
<tr>
<td>start</td>
<td>create a notification when the job is submitted.</td>
</tr>
<tr>
<td>on_error</td>
<td>after a job finishes with failure (exitcode !=
              0).</td>
</tr>
<tr>
<td>on_success</td>
<td>after a job finishes with success (exitcode ==
              0).</td>
</tr>
<tr>
<td>at_end</td>
<td>after a job finishes, regardless of exitcode.</td>
</tr>
<tr>
<td>all</td>
<td>like start and at_end combined.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>You can specify multiple invoke elements corresponding to same
      when attribute value in the DAX. This will allow you to have multiple
      notifications for the same event.</p>
<p>Here is an example that illustrates that.</p>
<pre class="programlisting">&lt;job id="ID000001" namespace="example" name="mDiffFit" version="1.0"
       node-label="preprocess" &gt;
    &lt;argument&gt;-a top -T 6  -i &lt;file name="f.a"/&gt;  -o &lt;file name="f.b1"/&gt;&lt;/argument&gt;

    &lt;!-- profiles are optional --&gt;
    &lt;profile namespace="execution" key="site"&gt;isi_viz&lt;/profile&gt;
    &lt;profile namespace="condor" key="getenv"&gt;true&lt;/profile&gt;

    &lt;uses name="f.a" link="input"  register="false" transfer="true" type="data" /&gt;
    &lt;uses name="f.b" link="output" register="false" transfer="true" type="data" /&gt;

    &lt;!-- 'WHEN' enumeration: never, start, on_error, on_success, at_end, all --&gt;
    <span class="bold"><strong>&lt;invoke when="start"&gt;/path/to/notify1 arg1 arg2&lt;/invoke&gt;
    &lt;invoke when="start"&gt;/path/to/notify1 arg3 arg4&lt;/invoke&gt;
    &lt;invoke when="on_success"&gt;/path/to/notify2 arg3 arg4&lt;/invoke&gt;</strong></span>
  &lt;/job&gt;</pre>
<p>In the above example the executable notify1 will be invoked twice
      when a job is submitted ( when="start" ), once with arguments arg1 and
      arg2 and second time with arguments arg3 and arg4.</p>
<p>The DAX Generator API <a class="link" href="dax_generator_api.php" title="16.2. DAX Generator API">chapter</a> has information about how to
      add notifications to the DAX using the DAX api's.</p>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="pegasus_notify_file"></a>6.4.2. Notify File created by Pegasus in the submit directory</h3></div></div></div>
<p>Pegasus while planning a workflow writes out a notify file in the
      submit directory that contains all the notifications that need to be
      sent for the workflow. pegasus-monitord picks up this notifications file
      to determine what notifications need to be sent and when.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
<p>ENTITY_TYPE ID NOTIFICATION_CONDITION ACTION</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<p>ENTITY_TYPE can be either of the following keywords</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: circle; ">
<li class="listitem"><p>WORKFLOW - indicates workflow level
                  notification</p></li>
<li class="listitem"><p>JOB - indicates notifications for a job in the
                  executable workflow</p></li>
<li class="listitem"><p>DAXJOB - indicates notifications for a DAX Job in the
                  executable workflow</p></li>
<li class="listitem"><p>DAGJOB - indicates notifications for a DAG Job in the
                  executable workflow</p></li>
</ul></div>
</li>
<li class="listitem">
<p>ID indicates the identifier for the entity. It has
              different meaning depending on the entity type - -</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: circle; ">
<li class="listitem"><p>workflow - ID is wf_uuid</p></li>
<li class="listitem"><p>JOB|DAXJOB|DAGJOB - ID is the job identifier in the
                  executable workflow ( DAG ).</p></li>
</ul></div>
</li>
<li class="listitem"><p>NOTIFICATION_CONDITION is the condition when the
              notification needs to be sent. The notification conditions are
              enumerated in <a class="link" href="notifications.php#notification_conditions_table" title="Table 6.5. Invoke Element attributes and meaning.">this table</a></p></li>
<li class="listitem"><p>ACTION is what needs to happen when condition is
              satisfied. It is executable + arguments</p></li>
</ul></div>
</li>
<li class="listitem">
<p>INVOCATION JOB_IDENTIFIER INV.ID NOTIFICATION_CONDITION
          ACTION</p>
<p>The INVOCATION lines are only generated for clustered jobs, to
          specifiy the finer grained notifications for each constitutent
          job/invocation .</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>JOB IDENTIFIER is the job identifier in the executable
              workflow ( DAG ).</p></li>
<li class="listitem"><p>INV.ID indicates the index of the task in the clustered
              job for which the notification needs to be sent.</p></li>
<li class="listitem"><p>NOTIFICATION_CONDITION is the condition when the
              notification needs to be sent. The notification conditions are
              enumerated in <a class="link" href="notifications.php#notification_conditions_table" title="Table 6.5. Invoke Element attributes and meaning.">Table 1</a></p></li>
<li class="listitem"><p>ACTION is what needs to happen when condition is
              satisfied. It is executable + arguments</p></li>
</ul></div>
</li>
</ol></div>
<p>A sample notifications file generated is listed below.</p>
<pre class="programlisting">WORKFLOW d2c4f79c-8d5b-4577-8c46-5031f4d704e8 on_error /bin/date1

INVOCATION merge_vahi-preprocess-1.0_PID1_ID1 1 on_success /bin/date_executable
INVOCATION merge_vahi-preprocess-1.0_PID1_ID1 1 on_success /bin/date_executable
INVOCATION merge_vahi-preprocess-1.0_PID1_ID1 1 on_error /bin/date_executable

INVOCATION merge_vahi-preprocess-1.0_PID1_ID1 2 on_success /bin/date_executable
INVOCATION merge_vahi-preprocess-1.0_PID1_ID1 2 on_error /bin/date_executable

DAXJOB subdax_black_ID000003 on_error /bin/date13
JOB    analyze_ID00004    on_success /bin/date
</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm2822"></a>6.4.3. Configuring pegasus-monitord for notifications</h3></div></div></div>
<p>Whenever pegasus-monitord enters a workflow (or sub-workflow)
      directory, it will read the notifications file generated by Pegasus.
      Pegasus-monitord will match events in the running workflow against the
      notifications specified in the notifications file and will initiate the
      script specified in a notification when that notification matches an
      event in the workflow. It is important to note that there will be a
      delay between a certain event happening in the workflow, and
      pegasus-monitord processing the log file and executing the corresponding
      notification script.</p>
<p>The following command line options (and properties) can change how
      pegasus-monitord handles notifications:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>--no-notifications (pegasus.monitord.notifications=False):
          Will disable notifications completely.</p></li>
<li class="listitem"><p>--notifications-max=nn
          (pegasus.monitord.notifications.max=nn): Will limit the number of
          concurrent notification scripts to nn. Once pegasus-monitord reaches
          this number, it will wait until one notification script finishes
          before starting a new one. Notifications happening during this time
          will be queued by the system. The default number of concurrent
          notification scripts for pegasus-monitord is 10.</p></li>
<li class="listitem"><p>--notifications-timeout=nn
          (pegasus.monitord.notifications.timeout=nn): This setting is used to
          change how long will pegasus-monitord wait for a notification script
          to finish. By default pegasus-monitord will wait for as long as it
          takes (possibly indefinitely) until a notification script ends. With
          this option, pegasus-monitord will wait for at most nn seconds
          before killing the notification script.</p></li>
</ul></div>
<p>It is also important to understand that pegasus-monitord will not
      issue any notifications when it is executed in replay mode.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm2834"></a>6.4.3.1. Environment set for the notification scripts</h4></div></div></div>
<p>Whenever a notification in the notifications file matches an
        event in the running workflow, pegasus-monitord will run the
        corresponding script specified in the ACTION field of the
        notifications file. Pegasus-monitord will set the following
        environment variables for each notification script is starts:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>PEGASUS_EVENT: The NOTIFICATION_CONDITION that caused the
            notification. In the case of the "all" condition, pegasus-monitord
            will substitute it for the actual event that caused the match
            (e.g. "start" or "at_end").</p></li>
<li class="listitem"><p>PEGASUS_EVENT_TIMESTAMP: Timestamp in EPOCH format for the
            event (better for automated processing).</p></li>
<li class="listitem"><p>PEGASUS_EVENT_TIMESTAMP_ISO: Same as above, but in ISO
            format (better for human readability).</p></li>
<li class="listitem"><p>PEGASUS_SUBMIT_DIR: The submit directory for the workflow
            (usually the value from "submit_dir" in the braindump.txt
            file)</p></li>
<li class="listitem"><p>PEGASUS_STDOUT: For workflow notifications, this will
            correspond to the dagman.out file for that workflow. For job and
            invocation notifications, this field will contain the output file
            (stdout) for that particular job instance.</p></li>
<li class="listitem"><p>PEGASUS_STDERR: For job and invocation notifications, this
            field will contain the error file (stderr) for the particular
            executable job instance. This field does not exist in case of
            workflow notifications.</p></li>
<li class="listitem"><p>PEGASUS_WFID: Contains the workflow id for this notification
            in the form of DAX_LABEL + DAX_INDEX (from the braindump.txt
            file).</p></li>
<li class="listitem"><p>PEGASUS_JOBID: For workflow notifications, this contains the
            worfkflow wf_uuid (from the braindump.txt file). For job and
            invocation notifications, this field contains the job identifier
            in the executable workflow ( DAG ) for the particular
            notification.</p></li>
<li class="listitem"><p>PEGASUS_INVID: Contains the index of the task in the
            clustered job for the notification.</p></li>
<li class="listitem"><p>PEGASUS_STATUS: For workflow notifications, this contains
            DAGMan's exit code. For job and invocation notifications, this
            field contains the exit code for the particular job/task. Please
            note that this field is not present for 'start' notification
            events.</p></li>
</ul></div>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm2858"></a>6.4.4. Default Notification Scripts</h3></div></div></div>
<p>Pegasus ships with two reference notification scripts. These can
      be used as starting point when creating your own notification scripts,
      or if the default one is all you need, you can use them directly in your
      workflows. The scripts are:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<p><span class="bold"><strong>libexec/notification/email</strong></span> -
          sends email, including the output from
          <span class="command"><strong>pegasus-status</strong></span> (default) or
          <span class="command"><strong>pegasus-analyzer</strong></span>.</p>
<pre class="screen"><span class="bold"><strong>$ ./libexec/notification/email --help</strong></span>
Usage: email [options]

Options:
  -h, --help            show this help message and exit
  -t TO_ADDRESS, --to=TO_ADDRESS
                        The To: email address. Defines the recipient for the
                        notification.
  -f FROM_ADDRESS, --from=FROM_ADDRESS
                        The From: email address. Defaults to the required To:
                        address.
  -r REPORT, --report=REPORT
                        Include workflow report. Valid values are: none
                        pegasus-analyzer pegasus-status (default)
</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>libexec/notification/jabber </strong></span>-
          sends simple notifications to Jabber/GTalk. This can be useful for
          job failures.</p>
<pre class="screen"><span class="bold"><strong>$ ./libexec/notification/jabber --help</strong></span>
Usage: jabber [options]

Options:
  -h, --help            show this help message and exit
  -i JABBER_ID, --jabberid=JABBER_ID
                        Your jabber id. Example: user@jabberhost.com
  -p PASSWORD, --password=PASSWORD
                        Your jabber password
  -s HOST, --host=HOST  Jabber host, if different from the host in your jabber
                        id. For Google talk, set this to talk.google.com
  -r RECIPIENT, --recipient=RECIPIENT
                        Jabber id of the recipient. Not necessary if you want
                        to send to your own jabber id
</pre>
</li>
</ul></div>
<p>For example, if the DAX generator is written in Python and you
      want notifications on 'at_end' events (successful or failed):</p>
<pre class="programlisting"># job level notifications - in this case for at_end events
job.invoke('at_end', pegasus_home + "/libexec/notifications/email --to me@somewhere.edu")</pre>
<p>Please see the <a class="link" href="notifications_example.php" title="9.5. Notifications Example">notifications
      example</a> to see a full workflow using notifications.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="dashboard.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="monitoring_debugging_stats.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="monitoring.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">6.3. Dashboard </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 6.5. Monitoring Database</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
