<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("6.6. Stampede Workflow Events");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="monitoring_debugging_stats.php">Monitoring, Debugging and Statistics</a></span> &gt; <span class="breadcrumb-node">Stampede Workflow Events</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="stampede_wf_events"></a>6.6. Stampede Workflow Events</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="stampede_wf_events.php#idm3019">6.6.1. Typedefs</a></span></dt>
<dt><span class="section"><a href="stampede_wf_events.php#idm3047">6.6.2. Groupings</a></span></dt>
<dt><span class="section"><a href="stampede_wf_events.php#idm3096">6.6.3. Events</a></span></dt>
</dl></div>
<p>All the events generated by the system ( Pegasus planner and
    monitoring daemon) are formatted as Netlogger BP events. The netlogger
    events that Pegasus generates are described in Yang schema file that can
    be found in the share/pegasus/schema/ directory. The stampede yang schema
    is described below.</p>
<div class="literallayout"><p><br>
</p></div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm3019"></a>6.6.1. Typedefs</h3></div></div></div>
<p>The following typedefs are used in the yang schema to describe the
      certain event attributes.</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: disc; ">
<li class="listitem">
<p>distinguished-name</p>
<pre class="programlisting">typedef distinguished-name {
   type string;
}</pre>
</li>
<li class="listitem">
<p>uuid</p>
<pre class="programlisting">typedef uuid {
   type string {
       length "36";
       pattern
          '[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}';
   }
}
</pre>
</li>
<li class="listitem">
<p>intbool</p>
<pre class="programlisting">typedef intbool {
   type uint8 {
       range "0 .. 1";
   }
}</pre>
</li>
<li class="listitem">
<p>nl_ts</p>
<pre class="programlisting">typedef nl_ts {
    type string {
        pattern
          '(\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[\+\-]\d{2}:\d{2}))|(\d{1,9}(\.\d+)?)';
     }
}
</pre>
</li>
<li class="listitem">
<p>peg_inttype</p>
<pre class="programlisting">typedef peg_inttype {
    type uint8 {
        range "0 .. 11";
    }
}</pre>
</li>
<li class="listitem">
<p>peg_strtype</p>
<pre class="programlisting">typedef peg_strtype {
    type enumeration {
        enum "unknown" {
          value 0;
        }
        enum "compute" {
          value 1;
        }
        enum "stage-in-tx" {
          value 2;
        }
        enum "stage-out-tx" {
          value 3;
        }
        enum "registration" {
          value 4;
        }
        enum "inter-site-tx" {
          value 5;
        }
        enum "create-dir" {
          value 6;
        }
        enum "staged-compute" {
          value 7;
        }
        enum "cleanup" {
          value 8;
        }
        enum "chmod" {
          value 9;
        }
        enum "dax" {
          value 10;
        }
        enum "dag" {
          value 11;
        }
   }
}</pre>
</li>
<li class="listitem">
<p>condor_jobstates</p>
<pre class="programlisting">typedef condor_jobstates {
    type enumeration {
        enum "PRE_SCRIPT_STARTED" {
          value 0;
        }
        enum "PRE_SCRIPT_TERMINATED" {
          value 1;
        }
        enum "PRE_SCRIPT_SUCCESS" {
          value 2;
        }
        enum "PRE_SCRIPT_FAILED" {
          value 3;
        }
        enum "SUBMIT" {
          value 4;
        }
        enum "GRID_SUBMIT" {
          value 5;
        }
        enum "GLOBUS_SUBMIT" {
          value 6;
        }
        enum "SUBMIT_FAILED" {
          value 7;
        }
        enum "EXECUTE" {
          value 8;
        }
        enum "REMOTE_ERROR" {
          value 9;
        }
        enum "IMAGE_SIZE" {
          value 10;
        }
        enum "JOB_TERMINATED" {
          value 11;
        }
        enum "JOB_SUCCESS" {
          value 12;
        }
        enum "JOB_FAILURE" {
          value 13;
        }
        enum "JOB_HELD" {
          value 14;
        }
        enum "JOB_EVICTED" {
          value 15;
        }
        enum "JOB_RELEASED" {
          value 16;
        }
        enum "POST_SCRIPT_STARTED" {
          value 17;
        }
        enum "POST_SCRIPT_TERMINATED" {
          value 18;
        }
        enum "POST_SCRIPT_SUCCESS" {
          value 19;
        }
        enum "POST_SCRIPT_FAILED" {
          value 20;
        }
    }
}
</pre>
</li>
<li class="listitem">
<p>condor_wfstates</p>
<pre class="programlisting">typedef condor_wfstates {
    type enumeration {
        enum "WORKFLOW_STARTED" {
          value 0;
        }
        enum "WORKFLOW_TERMINATED" {
          value 1;
        }
    }
}</pre>
</li>
</ul></div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm3047"></a>6.6.2. Groupings</h3></div></div></div>
<p>Groupings are groups of common attributes that different type of
      events refer to. The following groupings are defined.</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: disc; ">
<li class="listitem">
<p><span class="bold"><strong>base-event</strong></span> - Common
            components in all events</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: circle; ">
<li class="listitem"><p>ts - Timestamp, ISO8601 or numeric seconds since
                1/1/1970"</p></li>
<li class="listitem"><p>level - Severity level of event. Subset of NetLogger BP
                levels. For '*.end' events, if status is non-zero then level
                should be Error."</p></li>
<li class="listitem"><p>xwf.id - DAG workflow UUID</p></li>
</ul></div>
<pre class="programlisting">grouping base-event {
      description
        "Common components in all events";
      leaf ts {
        type nl_ts;
        mandatory true;
        description
          "Timestamp, ISO8601 or numeric seconds since 1/1/1970";
      }

      leaf level {
        type enumeration {
          enum "Info" {
            value 0;
          }
          enum "Error" {
            value 1;
          }
        }
        description
          "Severity level of event. "
            + "Subset of NetLogger BP levels. "
            + "For '*.end' events, if status is non-zero then level should be Error.";
      }

      leaf xwf.id {
        type uuid;
        description "DAG workflow id";
      }
 }  // grouping base-event</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>base-job-inst</strong></span> - Common
            components for all job instance events</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: circle; ">
<li class="listitem"><p>all attributes from base-event</p></li>
<li class="listitem"><p>job_inst.id - Job instance identifier i.e the submit
                sequence generated by monitord.</p></li>
<li class="listitem"><p>js.id - Jobstate identifier</p></li>
<li class="listitem"><p>job.id - Identifier for corresponding job in the
                DAG</p></li>
</ul></div>
<pre class="programlisting">grouping base-job-inst {
      description
        "Common components for all job instance events";
      uses base-event;

      leaf job_inst.id {
        type int32;
        mandatory true;
        description
          "Job instance identifier i.e the submit sequence generated by monitord";
      }

      leaf js.id {
        type int32;
        description "Jobstate identifier";
      }

      leaf job.id {
        type string;
        mandatory true;
        description
          "Identifier for corresponding job in the DAG";
      }
    }</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>sched-job-inst</strong></span> - Scheduled
            job instance.</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: circle; ">
<li class="listitem"><p>all attributes from base-job-inst</p></li>
<li class="listitem"><p>sched.id - Identifier for job in scheduler</p></li>
</ul></div>
<pre class="programlisting">grouping sched-job-inst {
      description "Scheduled job instance";
      uses base-job-inst;

      leaf sched.id {
        type string;
        mandatory true;
        description
          "Identifier for job in scheduler";
      }
} </pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>base-metadata</strong></span></p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: circle; ">
<li class="listitem"><p>uses</p></li>
<li class="listitem"><p>key</p></li>
<li class="listitem"><p>value</p></li>
</ul></div>
<pre class="programlisting">grouping base-metadata {
      description
        "Common components for all metadata events that describe metadata for an entity.";
      uses base-event;

      leaf key {
        type string;
        mandatory true;
        description
          "Key for the metadata tuple";
      }

      leaf value {
        type string;
        description
          "Corresponding value of the key";
      }
}  // grouping base-metadata</pre>
</li>
</ul></div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm3096"></a>6.6.3. Events</h3></div></div></div>
<p>The system generates following types of events, that are described
      below.</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: disc; ">
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_wf_plan_event">stampede.wf.plan</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_static_start_event">stampede.static.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_static_end_event">stampede.static.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_xwf_start_event">stampede.xwf.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_xwf_end_event">stampede.xwf.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_task_info_event">stampede.task.info</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_task_edge_event">stampede.task.edge</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_wf_map_task_job_event">stampede.wf.map.task_job</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_xwf_map_subwf_job_event">stampede.xwf.map.subwf_job</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_info_event">stampede.job.info</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_edge_event">stampede.job.edge</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_pre_start_event">stampede.job_inst.pre.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_pre_term_event">stampede.job_inst.pre.term</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_pre_end_event">stampede.job_inst.pre.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_submit_start_event">stampede.job_inst.submit.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_submit_end_event">stampede.job_inst.submit.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_held_start_event">stampede.job_inst.held.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_held_end_event">stampede.job_inst.held.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_main_start_event">stampede.job_inst.main.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_main_term_event">stampede.job_inst.main.term</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_main_end_event">stampede.job_inst.main.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_post_start_event">stampede.job_inst.post.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_post_term_event">stampede.job_inst.post.term</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_post_end_event">stampede.job_inst.post.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_host_info_event">stampede.job_inst.host.info</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_job_inst_image_info_event">stampede.job_inst.image.info</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_inv_start_event">stampede.inv.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_inv_end_event">stampede.inv.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_static_meta_start_event">stampede.static.meta.start</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_static_meta_end_event">stampede.static.meta.end</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_xwf_meta_event">stampede.xwf.meta</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_task_meta_event">stampede.task.meta</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_rc_meta_event">stampede.rc.meta</a></p></li>
<li class="listitem"><p><a class="link" href="stampede_wf_events.php#stampede_wf_map_file_event">stampede.wf.map.file</a></p></li>
</ul></div>
<p>The events are described in detail below</p>
<div class="itemizedlist"><ul class="itemizedlist compact" style="list-style-type: disc; ">
<li class="listitem">
<p><a name="stampede_wf_plan_event"></a><span class="bold"><strong>stampede.wf.plan</strong></span></p>
<pre class="programlisting">container stampede.wf.plan {
            uses base-event;

            leaf submit.hostname {
              type inet:host;
              mandatory true;
              description
                "The hostname of the Pegasus submit host";
            }

            leaf dax.label {
              type string;
              default "workflow";
              description
                "Label for abstract workflow specification";
            }

            leaf dax.index {
              type string;
              default "workflow";
              description
                "Index for the DAX";
            }

            leaf dax.version {
              type string;
              mandatory true;
              description
                "Version number for DAX";
            }

            leaf dax.file {
              type string;
              mandatory true;
              description
                "Filename for for the DAX";
            }

            leaf dag.file.name {
              type string;
              mandatory true;
              description
                "Filename for the DAG";
            }

            leaf planner.version {
              type string;
              mandatory true;
              description
                "Version string for Pegasus planner, e.g. 3.0.0cvs";
            }

            leaf grid_dn {
              type distinguished-name;
              description
                "Grid DN of submitter";
            }

            leaf user {
              type string;
              description
                "User name of submitter";
            }

            leaf submit.dir {
              type string;
              mandatory true;
              description
                "Directory path from which workflow was submitted";
            }

            leaf argv {
              type string;
              description
                "All arguments given to planner on command-line";
            }

            leaf parent.xwf.id {
              type uuid;
              description
                "Parent workflow in DAG, if any";
            }

            leaf root.xwf.id {
              type string;
              mandatory true;
              description
                "Root of workflow hierarchy, in DAG. "
                  + "Use this workflow's UUID if it is the root";
            }
}  // container stampede.wf.plan</pre>
</li>
<li class="listitem">
<p><a name="stampede_static_start_event"></a><span class="bold"><strong>stampede.static.start</strong></span></p>
<pre class="programlisting">container stampede.static.start {
     uses base-event;
} </pre>
</li>
<li class="listitem">
<p><a name="stampede_static_end_event"></a><span class="bold"><strong>stampede.static.end</strong></span></p>
<pre class="programlisting">container stampede.static.end {
    uses base-event;
}  //</pre>
</li>
<li class="listitem">
<p><a name="stampede_xwf_start_event"></a><span class="bold"><strong>stampede.xwf.start</strong></span></p>
<pre class="programlisting">container stampede.xwf.start {
            uses base-event;

            leaf restart_count {
              type uint32;
              mandatory true;
              description
                "Number of times workflow was restarted (due to failures)";
            }
}  // container stampede.xwf.start</pre>
</li>
<li class="listitem">
<p><a name="stampede_xwf_end_event"></a><span class="bold"><strong>stampede.xwf.end</strong></span></p>
<pre class="programlisting">container stampede.xwf.end {
            uses base-event;

            leaf restart_count {
              type uint32;
              mandatory true;
              description
                "Number of times workflow was restarted (due to failures)";
            }

            leaf status {
              type int16;
              mandatory true;
              description
                "Status of workflow. 0=success, -1=failure";
            }
}  // container stampede.xwf.end
</pre>
</li>
<li class="listitem">
<p><a name="stampede_task_info_event"></a><span class="bold"><strong>stampede.task.info</strong></span></p>
<pre class="programlisting">container stampede.task.info {
            description
              "Information about task in DAX";
            uses base-event;

            leaf transformation {
              type string;
              mandatory true;
              description
                "Logical name of the underlying executable";
            }

            leaf argv {
              type string;
              description
                "All arguments given to transformation on command-line";
            }

            leaf type {
              type peg_inttype;
              mandatory true;
              description "Type of task";
            }

            leaf type_desc {
              type peg_strtype;
              mandatory true;
              description
                "String description of task type";
            }

            leaf task.id {
              type string;
              mandatory true;
              description
                "Identifier for this task in the DAX";
            }
          }  // container stampede.task.info</pre>
</li>
<li class="listitem">
<p><a name="stampede_task_edge_event"></a><span class="bold"><strong>stampede.task.edge</strong></span></p>
<pre class="programlisting">container stampede.task.edge {
            description
              "Represents child/parent relationship between two tasks in DAX";
            uses base-event;

            leaf parent.task.id {
              type string;
              mandatory true;
              description "Parent task";
            }

            leaf child.task.id {
              type string;
              mandatory true;
              description "Child task";
            }
}  // container stampede.task.edge</pre>
</li>
<li class="listitem">
<p><a name="stampede_wf_map_task_job_event"></a><span class="bold"><strong>stampede.wf.map.task_job</strong></span></p>
<pre class="programlisting">container stampede.wf.map.task_job {

            description
              "Relates a DAX task to a DAG job.";
            uses base-event;

            leaf task.id {
              type string;
              mandatory true;
              description
                "Identifier for the task in the DAX";
            }

            leaf job.id {
              type string;
              mandatory true;
              description
                "Identifier for corresponding job in the DAG";
            }
}  // container stampede.wf.map.task_job</pre>
</li>
<li class="listitem">
<p><a name="stampede_xwf_map_subwf_job_event"></a><span class="bold"><strong>stampede.xwf.map.subwf_job</strong></span></p>
<pre class="programlisting">container stampede.xwf.map.subwf_job {

            description
              "Relates a sub workflow to the corresponding job instance";
            uses base-event;

            leaf subwf.id {
              type string;
              mandatory true;
              description
                "Sub Workflow Identified / UUID";
            }

            leaf job.id {
              type string;
              mandatory true;
              description
                "Identifier for corresponding job in the DAG";
            }

            leaf job_inst.id {
              type int32;
              mandatory true;
              description
                "Job instance identifier i.e the submit sequence generated by monitord";
            }
}  // container stampede.xwf.map.subwf_job</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_info_event"></a><span class="bold"><strong>stampede.job.info</strong></span></p>
<pre class="programlisting">container stampede.job.info {

            description
              "A description of a job in the DAG";
            uses base-event;

            leaf job.id {
              type string;
              mandatory true;
              description
                "Identifier for job in the DAG";
            }

            leaf submit_file {
              type string;
              mandatory true;
              description
                "Name of file being submitted to the scheduler";
            }

            leaf type {
              type peg_inttype;
              mandatory true;
              description "Type of task";
            }

            leaf type_desc {
              type peg_strtype;
              mandatory true;
              description
                "String description of task type";
            }

            leaf clustered {
              type intbool;
              mandatory true;
              description
                "Whether job is clustered or not";
            }

            leaf max_retries {
              type uint32;
              mandatory true;
              description
                "How many retries are allowed for this job before giving up";
            }

            leaf task_count {
              type uint32;
              mandatory true;
              description
                "Number of DAX tasks for this job. "
                  + "Auxiliary jobs without a task in the DAX will have the value '0'";
            }

            leaf executable {
              type string;
              mandatory true;
              description
                "Program to execute";
            }

            leaf argv {
              type string;
              description
                "All arguments given to executable (on command-line)";
            }
}  // container stampede.job.info</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_edge_event"></a><span class="bold"><strong>stampede.job.edge</strong></span></p>
<pre class="programlisting">container stampede.job.edge {

            description
              "Parent/child relationship between two jobs in the DAG";
            uses base-event;

            leaf parent.job.id {
              type string;
              mandatory true;
              description "Parent job";
            }

            leaf child.job.id {
              type string;
              mandatory true;
              description "Child job";
            }
}  // container stampede.job.edge</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_pre_start_event"></a><span class="bold"><strong>stampede.job_inst.pre.start</strong></span></p>
<pre class="programlisting">container stampede.job_inst.pre.start {

            description
              "Start of a prescript for a job instance";
            uses base-job-inst;
}  // container stampede.job_inst.pre.start</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_pre_term_event"></a><span class="bold"><strong>stampede.job_inst.pre.term</strong></span></p>
<pre class="programlisting">container stampede.job_inst.pre.term {
            description
              "Job prescript is terminated (success or failure not yet known)";
}  // container stampede.job_inst.pre.term</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_pre_end_event"></a><span class="bold"><strong>stampede.job_inst.pre.end</strong></span></p>
<pre class="programlisting">container stampede.job_inst.pre.end {
            description
              "End of a prescript for a job instance";
            uses base-job-inst;

            leaf status {
              type int32;
              mandatory true;
              description
                "Status of prescript. 0 is success, -1 is error";
            }

            leaf exitcode {
              type int32;
              mandatory true;
              description
                "the exitcode with which the prescript exited";
            }
}  // container stampede.job_inst.pre.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_submit_start_event"></a><span class="bold"><strong>stampede.job_inst.submit.start</strong></span></p>
<pre class="programlisting">container stampede.job_inst.submit.start {
            description
              "When job instance is going to be submitted. "
                + "Scheduler job id is not yet known";
            uses sched-job-inst;
}  // container stampede.job_inst.submit.start</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_submit_end_event"></a><span class="bold"><strong>stampede.job_inst.submit.end</strong></span></p>
<pre class="programlisting">container stampede.job_inst.submit.end {
            description
              "When executable job is submitted";
            uses sched-job-inst;

            leaf status {
              type int16;
              mandatory true;
              description
                "Status of workflow. 0=success, -1=failure";
            }
}  // container stampede.job_inst.submit.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_held_start_event"></a><span class="bold"><strong>stampede.job_inst.held.start</strong></span></p>
<pre class="programlisting">container stampede.job_inst.held.start {
            description
              "When Condor holds the jobs";
            uses sched-job-inst;
}  // container stampede.job_inst.held.start</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_held_end_event"></a><span class="bold"><strong>stampede.job_inst.held.end</strong></span></p>
<pre class="programlisting">container stampede.job_inst.held.end {
            description
              "When the job is released after being held";
            uses sched-job-inst;

            leaf status {
              type int16;
              mandatory true;
              description
                "Status of workflow. 0=success, -1=failure";
            }
}  // container stampede.job_inst.held.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_main_start_event"></a><span class="bold"><strong>stampede.job_inst.main.start</strong></span></p>
<pre class="programlisting">container stampede.job_inst.main.start {
            description
              "Start of execution of a scheduler job";
            uses sched-job-inst;

            leaf stdin.file {
              type string;
              description
                "Path to file containing standard input of job";
            }

            leaf stdout.file {
              type string;
              mandatory true;
              description
                "Path to file containing standard output of job";
            }

            leaf stderr.file {
              type string;
              mandatory true;
              description
                "Path to file containing standard error of job";
            }
}  // container stampede.job_inst.main.start
</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_main_term_event"></a><span class="bold"><strong>stampede.job_inst.main.term</strong></span></p>
<pre class="programlisting">container stampede.job_inst.main.term {
            description
              "Job is terminated (success or failure not yet known)";
            uses sched-job-inst;

            leaf status {
              type int32;
              mandatory true;
              description
                "Execution status. 0=means job terminated, -1=job was evicted, not terminated";
            }
}  // container stampede.job_inst.main.term</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_main_end_event"></a><span class="bold"><strong>stampede.job_inst.main.end</strong></span></p>
<pre class="programlisting">container stampede.job_inst.main.end {
            description
              "End of main part of scheduler job";
            uses sched-job-inst;

            leaf stdin.file {
              type string;
              description
                "Path to file containing standard input of job";
            }

            leaf stdout.file {
              type string;
              mandatory true;
              description
                "Path to file containing standard output of job";
            }

            leaf stdout.text {
              type string;
              description
                "Text containing output of job";
            }

            leaf stderr.file {
              type string;
              mandatory true;
              description
                "Path to file containing standard error of job";
            }

            leaf stderr.text {
              type string;
              description
                "Text containing standard error of job";
            }

            leaf user {
              type string;
              description
                "Scheduler's name for user";
            }

            leaf site {
              type string;
              mandatory true;
              description
                "DAX name for the site at which the job ran";
            }

            leaf work_dir {
              type string;
              description
                "Path to working directory";
            }

            leaf local.dur {
              type decimal64 {
                fraction-digits 6;
              }
              units "seconds";
              description
                "Duration as seen at the local node";
            }

            leaf status {
              type int32;
              mandatory true;
              description
                "Execution status. 0=success, -1=failure";
            }

            leaf exitcode {
              type int32;
              mandatory true;
              description
                "the exitcode with which the executable exited";
            }

            leaf multiplier_factor {
              type int32;
              mandatory true;
              description
                "the multiplier factor for use in statistics";
            }

            leaf cluster.start {
              type nl_ts;
              description
                "When the enclosing cluster started";
            }

            leaf cluster.dur {
              type decimal64 {
                fraction-digits 6;
              }
              units "seconds";
              description
                "Duration of enclosing cluster";
            }
}  // container stampede.job_inst.main.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_post_start_event"></a><span class="bold"><strong>stampede.job_inst.post.start</strong></span></p>
<pre class="programlisting">container stampede.job_inst.post.start {
            description
              "Start of a postscript for a job instance";
            uses sched-job-inst;
}  // container stampede.job_inst.post.start
</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_post_term_event"></a><span class="bold"><strong>stampede.job_inst.post.term</strong></span></p>
<pre class="programlisting">container stampede.job_inst.post.term {
            description
              "Job postscript is terminated (success or failure not yet known)";
            uses sched-job-inst;
}  // container stampede.job_inst.post.term</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_post_end_event"></a><span class="bold"><strong>stampede.job_inst.post.end</strong></span></p>
<pre class="programlisting">container stampede.job_inst.post.end {
            description
              "End of a postscript for a job instance";
            uses sched-job-inst;

            leaf status {
              type int32;
              mandatory true;
              description
                "Status of postscript. 0 is success, -1=failure";
            }

            leaf exitcode {
              type int32;
              mandatory true;
              description
                "the exitcode with which the postscript exited";
            }
}  // container stampede.job_inst.post.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_host_info_event"></a><span class="bold"><strong>stampede.job_inst.host.info</strong></span></p>
<pre class="programlisting">container stampede.job_inst.host.info {
            description
              "Host information associated with a job instance";
            uses base-job-inst;

            leaf site {
              type string;
              mandatory true;
              description "Site name";
            }

            leaf hostname {
              type inet:host;
              mandatory true;
              description "Host name";
            }

            leaf ip {
              type inet:ip-address;
              mandatory true;
              description "IP address";
            }

            leaf total_memory {
              type uint64;
              description
                "Total RAM on host";
            }

            leaf uname {
              type string;
              description
                "Operating system name";
            }
}  // container stampede.job_inst.host.info</pre>
</li>
<li class="listitem">
<p><a name="stampede_job_inst_image_info_event"></a><span class="bold"><strong>stampede.job_inst.image.info</strong></span></p>
<pre class="programlisting">container stampede.job_inst.image.info {
            description
              "Image size associated with a job instance";
            uses base-job-inst;

            leaf size {
              type uint64;
              description "Image size";
            }

            leaf sched.id {
              type string;
              mandatory true;
              description
                "Identifier for job in scheduler";
            }
}  // container stampede.job_inst.image.info</pre>
</li>
<li class="listitem">
<p><a name="stampede_inv_start_event"></a><span class="bold"><strong>stampede.inv.start</strong></span></p>
<pre class="programlisting">container stampede.inv.start {
            description
              "Start of an invocation";
            uses base-event;

            leaf job_inst.id {
              type int32;
              mandatory true;
              description
                "Job instance identifier i.e the submit sequence generated by monitord";
            }

            leaf job.id {
              type string;
              mandatory true;
              description
                "Identifier for corresponding job in the DAG";
            }

            leaf inv.id {
              type int32;
              mandatory true;
              description
                "Identifier for invocation. "
                  + "Sequence number, with -1=prescript and -2=postscript";
            }
}  // container stampede.inv.start
</pre>
</li>
<li class="listitem">
<p><a name="stampede_inv_end_event"></a><span class="bold"><strong>stampede.inv.end</strong></span></p>
<pre class="programlisting">container stampede.inv.end {
            description
              "End of an invocation";
            uses base-event;

            leaf job_inst.id {
              type int32;
              mandatory true;
              description
                "Job instance identifier i.e the submit sequence generated by monitord";
            }

            leaf inv.id {
              type int32;
              mandatory true;
              description
                "Identifier for invocation. "
                  + "Sequence number, with -1=prescript and -2=postscript";
            }

            leaf job.id {
              type string;
              mandatory true;
              description
                "Identifier for corresponding job in the DAG";
            }

            leaf start_time {
              type nl_ts;
              description
                "The start time of the event";
            }

            leaf dur {
              type decimal64 {
                fraction-digits 6;
              }
              units "seconds";
              description
                "Duration of invocation";
            }

            leaf remote_cpu_time {
              type decimal64 {
                fraction-digits 6;
              }
              units "seconds";
              description
                "remote CPU time computed as the stime  + utime";
            }

            leaf exitcode {
              type int32;
              description
                "the exitcode with which the	            executable exited";
            }

            leaf transformation {
              type string;
              mandatory true;
              description
                "Transformation associated with this invocation";
            }

            leaf executable {
              type string;
              mandatory true;
              description
                "Program executed for this invocation";
            }

            leaf argv {
              type string;
              description
                "All arguments given to executable on command-line";
            }

            leaf task.id {
              type string;
              description
                "Identifier for related task in the DAX";
            }
}  // container stampede.inv.end</pre>
</li>
<li class="listitem">
<p><a name="stampede_static_meta_start_event"></a><span class="bold"><strong>stampede.static.meta.start</strong></span></p>
<pre class="programlisting">container stampede.static.meta.start {
            uses base-event;
}  // container stampede.static.meta.start
</pre>
</li>
<li class="listitem">
<p><a name="stampede_static_meta_end_event"></a><span class="bold"><strong>stampede.static.meta.end</strong></span></p>
<pre class="programlisting">container stampede.static.meta.end { 
            uses base-event; 
} // container stampede.static.meta.end </pre>
</li>
<li class="listitem">
<p><a name="stampede_xwf_meta_event"></a><span class="bold"><strong>stampede.xwf.meta</strong></span></p>
<pre class="programlisting">container stampede.xwf.meta {
            description
              "Metadata associated with a workflow";
            uses base-metadata;
}  // container stampede.xwf.meta
</pre>
</li>
<li class="listitem">
<p><a name="stampede_task_meta_event"></a><span class="bold"><strong>stampede.task.meta</strong></span></p>
<pre class="programlisting">container stampede.task.meta {
            description
              "Metadata associated with a task";
            uses base-metadata;

            leaf task.id {
              type string;
              description
                "Identifier for related task in the DAX";
            }
}  // container stampede.task.meta</pre>
</li>
<li class="listitem">
<p><a name="stampede_rc_meta_event"></a><span class="bold"><strong>stampede.rc.meta</strong></span></p>
<pre class="programlisting">container stampede.rc.meta {
            description
              "Metadata associated with a file in the replica catalog";
            uses base-metadata;

            leaf lfn.id {
              type string;
              description
                "Logical File Identifier for the file";
            }
}  // container stampede.rc.meta</pre>
</li>
<li class="listitem">
<p><a name="stampede_wf_map_file_event"></a><span class="bold"><strong>stampede.wf.map.file</strong></span></p>
<pre class="programlisting">container stampede.wf.map.file {
            description
              "Event that captures what task generates or consumes a particular file";
            uses base-event;

            leaf lfn.id {
              type string;
              description
                "Logical File Identifier for the file";
            }

            leaf task.id {
              type string;
              description
                "Identifier for related task in the DAX";
            }
}  // container stampede.wf.map.file</pre>
</li>
</ul></div>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="monitoring.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="monitoring_debugging_stats.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="execution_environments.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">6.5. Monitoring Database </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 7. Execution Environments</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
